/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.scripts.Task;
import inform.agent.scripts.libs.SnmpLogFactory;
import inform.common.SmartScriptableObject;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMP
extends SmartScriptableObject
implements Closeable {
    private final Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
    private final CommunityTarget target = new CommunityTarget();
    private String host = "127.0.0.1";
    private final UdpAddress addr = new UdpAddress(161);
    private final Task task;
    private boolean sended;
    private PDU responsePDU;
    private VariableBinding[] responseVarBinds;

    public SNMP(Task task, Scriptable scope) throws IOException {
        this.setParentScope(scope);
        this.task = task;
        this.snmp.listen();
        this.target.setCommunity(new OctetString("public"));
        this.target.setAddress((Address)this.addr);
    }

    @SmartScriptableObject.PropertyTag
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) throws UnknownHostException {
        this.host = host;
        this.addr.setInetAddress(InetAddress.getByName(host));
    }

    @SmartScriptableObject.PropertyTag
    public int getPort() {
        return this.addr.getPort();
    }

    public void setPort(int port) {
        this.addr.setPort(port);
    }

    @SmartScriptableObject.PropertyTag
    public String getCommunity() {
        return this.target.getCommunity().toString();
    }

    public void setCommunity(String community) {
        this.target.setCommunity(new OctetString(community));
    }

    @SmartScriptableObject.FunctionTag
    public static boolean getRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        SNMP self = (SNMP)thisObj;
        return self.executeRequest(self.prepareRequest(args, -96));
    }

    @SmartScriptableObject.FunctionTag
    public static boolean getNextRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        SNMP self = (SNMP)thisObj;
        return self.executeRequest(self.prepareRequest(args, -95));
    }

    @SmartScriptableObject.FunctionTag
    public static boolean setRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, ParseException {
        PDU pdu = new PDU();
        int c = args.length / 2;
        for (int i = 0; i < c; ++i) {
            pdu.add(new VariableBinding(new OID(String.valueOf(args[i * 2 + 0])), (Variable)new OctetString(String.valueOf(args[i * 2 + 1]))));
        }
        pdu.setType(-93);
        return ((SNMP)thisObj).executeRequest(pdu);
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.snmp.close();
        this.task.detachCloseable(this);
    }

    @SmartScriptableObject.PropertyTag
    public int getReplyErrorStatus() {
        if (this.responsePDU == null) {
            return this.sended ? -1 : 0;
        }
        return this.responsePDU.getErrorStatus();
    }

    @SmartScriptableObject.PropertyTag
    public int getReplyErrorIndex() {
        return this.responsePDU == null ? 0 : this.responsePDU.getErrorIndex();
    }

    @SmartScriptableObject.PropertyTag
    public int getReplyValueCount() {
        return this.responseVarBinds == null ? 0 : this.responseVarBinds.length;
    }

    @SmartScriptableObject.FunctionTag
    public String replyValueOid(int index) {
        if (this.responseVarBinds == null) {
            return "";
        }
        return this.responseVarBinds[index].getOid().toString();
    }

    @SmartScriptableObject.FunctionTag
    public String replyValue(int index) {
        if (this.responseVarBinds == null) {
            return "";
        }
        Variable v = this.responseVarBinds[index].getVariable();
        if (v instanceof OctetString) {
            int l;
            byte[] data = ((OctetString)v).getValue();
            for (l = data.length; l != 0 && data[l - 1] == 0; --l) {
            }
            return new String(data, 0, l, TaggedWriter.ANSI);
        }
        return v.toString();
    }

    private PDU prepareRequest(Object[] args, int pduType) throws IOException {
        PDU pdu = new PDU();
        for (Object arg : args) {
            pdu.add(new VariableBinding(new OID(String.valueOf(arg))));
        }
        pdu.setType(pduType);
        return pdu;
    }

    private boolean executeRequest(PDU pdu) throws IOException {
        this.responsePDU = this.snmp.send(pdu, (Target)this.target).getResponse();
        this.sended = true;
        if (this.responsePDU == null) {
            this.responseVarBinds = null;
            return false;
        }
        this.responseVarBinds = this.responsePDU.toArray();
        return this.responsePDU.getErrorStatus() == 0;
    }

    static {
        System.setProperty("snmp4j.LogFactory", SnmpLogFactory.class.getName());
    }
}

