/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.scripts.NetLibrary;
import inform.agent.scripts.Task;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.libs.XmlLibrary;
import inform.agent.scripts.soap.SoapMessage;
import inform.agent.scripts.soap.SoapMimeHeaders;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class SoapLibrary
extends SmartScriptableObject {
    public static final String PROTOCOL_VERSION_11 = "SOAP 1.1 Protocol";
    public static final String PROTOCOL_VERSION_12 = "SOAP 1.2 Protocol";
    private final Task task;

    public SoapLibrary(Task task) {
        this.task = task;
        SoapLibrary.putConstProperty(this, "PROTOCOL_VERSION_11", PROTOCOL_VERSION_11);
        SoapLibrary.putConstProperty(this, "PROTOCOL_VERSION_12", PROTOCOL_VERSION_12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public Object execute(String url, String action, Object data) throws InterruptedException, SOAPException, TransformerException, MalformedURLException, IOException, XMLStreamException {
        int slidx = action.lastIndexOf(47);
        QName actionQName = slidx == -1 ? new QName(action) : new QName(action.substring(0, slidx + 1), action.substring(slidx + 1));
        SOAPConnectionFactory cf = SOAPConnectionFactory.newInstance();
        try (SOAPConnection c = cf.createConnection();){
            SOAPMessage rs;
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage rq = mf.createMessage();
            SOAPBody rqBody = rq.getSOAPPart().getEnvelope().getBody();
            SOAPElement actionElement = rqBody.addChildElement(actionQName);
            if (data instanceof Scriptable) {
                Scriptable sdata = (Scriptable)data;
                for (Object id : sdata.getIds()) {
                    String k = id.toString();
                    Object v = sdata.get(k, sdata);
                    actionElement.addChildElement(k).setTextContent(String.valueOf(v));
                }
            }
            rq.getMimeHeaders().addHeader("SOAPAction", action);
            try {
                rs = c.call(rq, (Object)new URL(null, url, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        URL clone = new URL(url.toString());
                        return NetLibrary.openConnection(clone);
                    }
                }));
            }
            catch (SOAPException e) {
                Core.logger.info("soap exception", e);
                throw new InformException(e.getMessage()).detail("request: " + SoapLibrary.soapMessageToString(rq));
            }
            SOAPBody rsBody = rs.getSOAPBody();
            if (rsBody.hasFault()) {
                SOAPElement rsBodyFault = SoapLibrary.findFirstChild((SOAPElement)rsBody, "Fault");
                if (rsBodyFault == null) {
                    throw new InformException(SoapLibrary.xmlNodeToString((Node)rsBody));
                }
                SOAPElement rsBodyFaultString = SoapLibrary.findFirstChild(rsBodyFault, "faultstring");
                if (rsBodyFaultString == null) {
                    throw new InformException(SoapLibrary.xmlNodeToString((Node)rsBodyFault));
                }
                throw new InformException(rsBodyFaultString.getTextContent()).detail(SoapLibrary.xmlNodeToString((Node)rsBody)).detail("request: " + SoapLibrary.soapMessageToString(rq));
            }
            Iterator i = rsBody.getChildElements(new QName(actionQName.getNamespaceURI(), actionQName.getLocalPart() + "Response"));
            if (!i.hasNext()) {
                Core.logger.info("SOAP response message: {}", (Object)SoapLibrary.soapMessageToString(rs));
                throw new InformException("'*Response' tag is not found");
            }
            SOAPElement rsResponse = (SOAPElement)i.next();
            if (!(i = rsResponse.getChildElements(new QName(actionQName.getNamespaceURI(), actionQName.getLocalPart() + "Result"))).hasNext()) {
                throw new InformException("'*Result' tag is not found");
            }
            SoapResult soapResult = new SoapResult((SOAPElement)i.next(), this.task);
            return soapResult;
        }
    }

    private static SOAPElement findFirstChild(SOAPElement element, String localName) {
        Iterator i = element.getChildElements();
        while (i.hasNext()) {
            SOAPElement e = (SOAPElement)i.next();
            if (!localName.equals(e.getLocalName())) continue;
            return e;
        }
        return null;
    }

    private static String soapMessageToString(SOAPMessage m) throws SOAPException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        try {
            m.writeTo((OutputStream)tmp);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible case occured", e);
        }
        return new String(tmp.internalBuffer(), 0, tmp.size(), TaggedWriter.UTF8);
    }

    private static String xmlNodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(new DOMSource((org.w3c.dom.Node)node), new StreamResult(sw));
        return sw.toString();
    }

    @SmartScriptableObject.FunctionTag
    public SoapMessage createMessage(Object version, Object data, Object codepage, Object headers) throws Exception {
        SOAPMessage message;
        String protocol = version instanceof String ? (String)version : PROTOCOL_VERSION_11;
        MessageFactory mf = MessageFactory.newInstance((String)protocol);
        byte[] v = CryptoUtils.dataAsBytes(data, codepage);
        if (v == null || v.length == 0) {
            message = mf.createMessage();
        } else if (headers != null) {
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (headers instanceof NativeObject) {
                NativeObject o = (NativeObject)headers;
                for (Map.Entry<Object, Object> entry : o.entrySet()) {
                    mimeHeaders.setHeader(entry.getKey().toString(), entry.getValue().toString());
                }
            } else if (headers instanceof SoapMimeHeaders) {
                SoapMimeHeaders m = (SoapMimeHeaders)headers;
                Map<String, String> values = m.values();
                for (String key : values.keySet()) {
                    mimeHeaders.setHeader(key, values.get(key));
                }
            }
            message = mf.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(v));
        } else {
            message = mf.createMessage(null, (InputStream)new ByteArrayInputStream(v));
        }
        return new SoapMessage(this, message, protocol);
    }

    private static class SoapResult
    extends SmartScriptableObject {
        private final SOAPElement result;
        private final Task task;
        private String asString;
        private String asSource;

        SoapResult(SOAPElement result, Task task) {
            this.result = result;
            this.task = task;
        }

        @SmartScriptableObject.PropertyTag
        public String getAsString() {
            if (this.asString == null) {
                this.asString = this.result.getTextContent();
            }
            return this.asString;
        }

        @SmartScriptableObject.PropertyTag
        public String getAsSource() throws TransformerException {
            if (this.asSource == null) {
                this.asSource = SoapLibrary.xmlNodeToString((Node)this.result);
            }
            return this.asSource;
        }

        @SmartScriptableObject.FunctionTag
        public Object createXmlReader() throws Exception {
            return XmlLibrary.createReaderImpl(this.getAsSource(), this.task);
        }
    }
}

