/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.CancelRequestException;
import inform.agent.ServerSideHost;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Task;
import inform.agent.scripts.util.RunnableProcess;
import inform.agent.scripts.util.ScriptMutex;
import inform.common.SmartScriptableObject;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class SystemLibrary
extends SmartScriptableObject {
    public final ServerSideHost host;
    public final Task task;
    private static final HashSet<String> mutexSet = new HashSet();

    public SystemLibrary(Scriptable scope, ServerSideHost ssHost, Task task) {
        this.setParentScope(scope);
        this.host = ssHost;
        this.task = task;
    }

    @Override
    public String getClassName() {
        return "System";
    }

    @SmartScriptableObject.FunctionTag
    public static Object createProcess(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        SystemLibrary self = (SystemLibrary)thisObj;
        RunnableProcess process = new RunnableProcess(self.host, self.task);
        if (args.length > 0) {
            process.setApplication(args[0].toString());
        }
        for (int index = 1; index < args.length; ++index) {
            process.addArgument(ValueCaster.toString(args[index].toString()));
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object internalCreateMutex(String key, SystemLibrary systemLibrary) {
        SystemLibrary.checkMutexName(key);
        HashSet<String> hashSet = mutexSet;
        synchronized (hashSet) {
            if (mutexSet.add(key)) {
                return new ScriptMutex(key, systemLibrary);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object internalCreateMutex(Object arg, SystemLibrary systemLibrary) {
        boolean hasValidMutexName = false;
        HashSet<String> hashSet = mutexSet;
        synchronized (hashSet) {
            if (arg != null) {
                if (arg instanceof NativeArray) {
                    Object[] array = (Object[])Context.jsToJava(arg, Object[].class);
                    if (array != null) {
                        for (Object item : array) {
                            String key = ValueCaster.toString(item);
                            if (Strings.isVoid(key)) continue;
                            hasValidMutexName = true;
                            Object mutex = SystemLibrary.internalCreateMutex(key, systemLibrary);
                            if (mutex == null) continue;
                            return mutex;
                        }
                    }
                } else {
                    String key = ValueCaster.toString(arg);
                    if (!Strings.isVoid(key)) {
                        hasValidMutexName = true;
                        Object mutex = SystemLibrary.internalCreateMutex(key, systemLibrary);
                        if (mutex != null) {
                            return mutex;
                        }
                    }
                }
            }
        }
        if (!hasValidMutexName) {
            SystemLibrary.checkMutexName(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public static Object lockMutex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args == null || args.length == 0) {
            SystemLibrary.checkMutexName(null);
            return null;
        }
        Object mutex = null;
        HashSet<String> hashSet = mutexSet;
        synchronized (hashSet) {
            mutex = SystemLibrary.internalCreateMutex(args[0], (SystemLibrary)thisObj);
            if (mutex == null) {
                long timeout;
                long l = timeout = args.length > 1 ? (long)ValueCaster.toInt(args[1]) : 0L;
                if (timeout > 0L) {
                    try {
                        mutexSet.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        throw new CancelRequestException();
                    }
                    mutex = SystemLibrary.internalCreateMutex(args, (SystemLibrary)thisObj);
                }
            }
        }
        return mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMutex(String key) {
        SystemLibrary.checkMutexName(key);
        HashSet<String> hashSet = mutexSet;
        synchronized (hashSet) {
            if (!mutexSet.remove(key)) {
                throw new InformException("\u041c\u044c\u044e\u0442\u0435\u043a\u0441 " + key + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            mutexSet.notifyAll();
        }
    }

    private static void checkMutexName(String key) {
        if (Strings.isVoid(key)) {
            throw new InformException("\u0418\u043c\u044f \u043c\u044c\u044e\u0442\u0435\u043a\u0441\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0435 \u043f\u0443\u0441\u0442\u043e\u0435");
        }
    }
}

