/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SqlGenerator;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Security;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class TestInternalsLibrary
extends SmartScriptableObject {
    private final ServerSideHost ssHost;
    private static final String SEARCH_NODE_IS_NOT_SET = "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0418\u0414 \u0443\u0437\u0435\u043b\u0430 \u0442\u0438\u043f\u0430 \u041f\u043e\u0438\u0441\u043a";

    public TestInternalsLibrary(ServerSideHost ssHost) {
        this.ssHost = ssHost;
    }

    @SmartScriptableObject.FunctionTag
    public void applyTableStructure(double fromNodeId, double toNodeId, double dbNodeId) throws Exception {
        Node from = MtdEngine.getValidNode(fromNodeId);
        if (from.getType() != 12) {
            throw new InformException("1-\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0437\u043b\u043e\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        Node to = MtdEngine.getValidNode(toNodeId);
        if (to.getType() != 12) {
            throw new InformException("2-\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0437\u043b\u043e\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        Node db = MtdEngine.getValidNode(dbNodeId);
        if (db.getType() != 10) {
            throw new InformException("3-\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0437\u043b\u043e\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0411\u0414");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(output);
        TaggedReader reader = new TaggedReader(((TableNode)from).getContent());
        while (reader.next()) {
            if (reader.getCurrentTag() == 20) {
                writer.putEmpty(20);
                writer.putDouble(151, db.getId());
                continue;
            }
            reader.transferTag(writer);
        }
        byte[] content = output.toByteArray();
        MtdEngine.setNodeContent(this.ssHost.getSSContext(), this.ssHost, to.getId(), 0L, content, null, this.ssHost.getUserID(), this.ssHost.getSessionID(), Security.ZERO);
        ByteArrayOutputStream notification = new ByteArrayOutputStream();
        writer = new TaggedWriter(notification);
        writer.putEmpty(6);
        writer.putDouble(3, to.getId());
        writer.flush();
        AlertingEngine.sendChangeNotification(null, notification.internalBuffer(), notification.size(), 0L);
    }

    @SmartScriptableObject.FunctionTag
    public static Object sqlRepresentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        TestInternalsLibrary self = (TestInternalsLibrary)thisObj;
        ((TestInternalsLibrary)thisObj).ssHost.idle();
        double searchNodeId = 0.0;
        double databaseId = 0.0;
        int methodCode = -1;
        int databaseType = -500;
        if (args.length > 0) {
            searchNodeId = ValueCaster.toDouble(args[0]);
        }
        if (args.length > 1) {
            databaseId = ValueCaster.toDouble(args[1]);
        }
        if (args.length > 2) {
            methodCode = ValueCaster.toInt(args[2]);
        }
        if (args.length > 3) {
            databaseType = ValueCaster.toInt(args[3]);
        }
        if (searchNodeId == 0.0) {
            throw new InformException(SEARCH_NODE_IS_NOT_SET);
        }
        Node node = MtdEngine.getValidNode(searchNodeId);
        if (node.getType() != 19) {
            throw new InformException(SEARCH_NODE_IS_NOT_SET);
        }
        byte[] searchContent = MtdEngine.getNodeContent(searchNodeId);
        double tableId = SqlGenerator.extractRootTabled(searchContent);
        Node tableNode = MtdEngine.getValidNode(tableId);
        if (AccessMask.accessDenied(0x4000000, self.ssHost.security().accessMask(node))) {
            throw new InformException("\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0447\u0442\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        SqlGenerator.Method generationMethod = SqlGenerator.Method.DEFAULT;
        SqlGenerator sqlGen = new SqlGenerator(self.ssHost, Core.serverTimeZoneHost);
        if (databaseId != 0.0) {
            sqlGen.setDatabaseId(databaseId);
        }
        sqlGen.setTableId(tableId);
        sqlGen.setSearchId(searchNodeId);
        generationMethod = methodCode >= 0 ? SqlGenerator.Method.fromInt(methodCode) : SqlGenerator.extractSearchGenerationMethod(searchContent);
        sqlGen.setSearchContent(searchContent);
        GeneratedSql sql = sqlGen.getGeneratedSql(generationMethod, databaseType);
        if (sql.isHasError()) {
            throw new InformException(sql.getError()).detail(sql.getErrorDetailing());
        }
        String sqlText = sql.formatInsensitiveSql(false);
        return sqlText;
    }

    @Override
    public String getClassName() {
        return "TestInternals";
    }
}

