/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class XmlWriter
extends SmartScriptableObject {
    private final ArrayDeque<String> beginEndStack = new ArrayDeque();
    private String tagStack;
    private final StringBuffer beginEndStrBuff = new StringBuffer();
    private TagState currentState = TagState.StateTagClose;
    private boolean lastBeginFlag;
    private Charset _defaultCodepage = null;
    private boolean _calculateSize = false;
    private long _contentSize = 0L;
    private final char[] TABS = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    XmlWriter(String codepage) throws Exception {
        if (Strings.isVoid(codepage) || codepage.equalsIgnoreCase("undefined")) {
            codepage = "WINDOWS-1251";
        }
        this._defaultCodepage = Charset.forName(XmlWriter.codepageToCp(codepage));
    }

    private XmlWriter append(String text) {
        this.beginEndStrBuff.append(text);
        if (!this._calculateSize) {
            return this;
        }
        if (this._contentSize == 0L) {
            this._contentSize += (long)this.getHeader(this._defaultCodepage.displayName()).getBytes(this._defaultCodepage).length;
        }
        this._contentSize += (long)text.getBytes(this._defaultCodepage).length;
        return this;
    }

    private void tagHeaderOpen(String text) throws Exception {
        this.closeIfNeeded();
        this.appendFormatIfNeeded();
        this.append("<").append(text);
        this.currentState = TagState.StateTagHeaderOpen;
    }

    private void closeIfNeeded() {
        if (!this.lastBeginFlag) {
            switch (this.currentState) {
                case StateTagHeaderOpen: {
                    this.append("/>");
                    this.currentState = TagState.StateTagClose;
                    break;
                }
                case StateTagHeaderClose: {
                    this.append("</").append(this.tagStack).append(">");
                    this.currentState = TagState.StateTagClose;
                }
            }
        }
        if (this.lastBeginFlag && this.currentState == TagState.StateTagHeaderOpen) {
            this.append(">");
            this.currentState = TagState.StateTagHeaderClose;
        }
    }

    private void appendFormatIfNeeded() throws Exception {
        int c;
        if (this.beginEndStrBuff.length() <= 0) {
            return;
        }
        this.append("\r\n");
        if (this.beginEndStack.isEmpty()) {
            return;
        }
        int l = this.TABS.length;
        for (c = this.beginEndStack.size() * 2; c > l; c -= l) {
            this.append(String.valueOf(this.TABS, 0, l));
        }
        if (c > 0) {
            this.append(String.valueOf(this.TABS, 0, c));
        }
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter begin(String aTagName) throws Exception {
        if (aTagName.isEmpty()) {
            throw new InformException("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0442\u0435\u0433\u0430");
        }
        String tagName = this.replaceSpecChar(aTagName);
        this.tagHeaderOpen(tagName);
        this.beginEndStack.addLast(tagName);
        this.lastBeginFlag = true;
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter end(Object text) throws Exception {
        if (this.beginEndStack.isEmpty()) {
            throw new InformException("\u041d\u0435\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0435\u0433\u043e\u0432");
        }
        String lastTag = this.beginEndStack.pollLast();
        if (text != Undefined.instance && !lastTag.equals(text)) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0442\u0435\u0433\u0430 " + (String)text + " \u043f\u0440\u0438 \u043d\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u0442\u0435\u0433\u0435 " + lastTag);
        }
        switch (this.currentState) {
            case StateTagHeaderOpen: {
                if (this.lastBeginFlag) {
                    this.append("/>");
                    this.currentState = TagState.StateTagClose;
                    break;
                }
                this.append("/>");
                this.appendFormatIfNeeded();
                this.append("</").append(lastTag).append(">");
                this.currentState = TagState.StateTagClose;
                break;
            }
            case StateTagHeaderClose: {
                if (this.lastBeginFlag) {
                    this.appendFormatIfNeeded();
                    this.append("</").append(lastTag).append(">");
                    this.currentState = TagState.StateTagClose;
                    break;
                }
                this.append("</").append(this.tagStack).append(">");
                this.appendFormatIfNeeded();
                this.append("</").append(lastTag).append(">");
                this.currentState = TagState.StateTagClose;
                break;
            }
            case StateTagClose: {
                this.appendFormatIfNeeded();
                this.append("</").append(lastTag).append(">");
                this.currentState = TagState.StateTagClose;
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter tag(String aTagName, Object aText) throws Exception {
        if (aTagName.isEmpty()) {
            throw new InformException("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0442\u0435\u0433\u0430");
        }
        if (aText == Undefined.instance) {
            String tagName = this.replaceSpecChar(aTagName);
            this.tagHeaderOpen(tagName);
            this.tagStack = tagName;
            this.lastBeginFlag = false;
        } else {
            String tagName = this.replaceSpecChar(aTagName);
            this.tagHeaderOpen(tagName);
            this.tagStack = tagName;
            this.lastBeginFlag = false;
            this.text(ValueCaster.toString(aText));
            this.closeIfNeeded();
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter text(String aText) throws Exception {
        String text = this.replaceSpecChar(aText);
        if (this.currentState == TagState.StateTagHeaderOpen) {
            this.append(">");
            this.currentState = TagState.StateTagHeaderClose;
        }
        this.append(text);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter attr(String aAttrName, String aText) throws Exception {
        String attrName = this.replaceSpecChar(aAttrName);
        String text = this.replaceSpecChar(aText);
        this.append(" ").append(attrName).append("=\"").append(text).append("\"");
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter xml(Object xmlWrObj) throws Exception {
        if (xmlWrObj instanceof XmlWriter) {
            XmlWriter xmlWr = (XmlWriter)xmlWrObj;
            xmlWr.closeIfNeeded();
            this.xml(xmlWr.getAsString());
        }
        if (xmlWrObj instanceof String) {
            if (this.currentState == TagState.StateTagHeaderOpen) {
                this.append(">");
                this.currentState = TagState.StateTagHeaderClose;
            }
            this.append(String.valueOf(xmlWrObj));
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public XmlWriter cdata(Object xmlWrObj) throws Exception {
        String str = null;
        if (xmlWrObj instanceof XmlWriter) {
            XmlWriter xmlWr = (XmlWriter)xmlWrObj;
            xmlWr.closeIfNeeded();
            str = xmlWr.getAsString();
        }
        if (str == null) {
            if (this.currentState == TagState.StateTagHeaderOpen) {
                this.append(">");
                this.currentState = TagState.StateTagHeaderClose;
            }
            str = ValueCaster.toString(xmlWrObj);
        }
        if (!Strings.isVoid(str)) {
            this.appendFormatIfNeeded();
            str = str.replace("]]", "]]]]><![CDATA[>");
            this.append("<![CDATA[").append(str).append("]]>");
        }
        return this;
    }

    @SmartScriptableObject.PropertyTag
    public String getAsString() throws Exception {
        this.closeIfNeeded();
        this.check();
        return this.beginEndStrBuff.toString();
    }

    @SmartScriptableObject.PropertyTag
    public String getCodepage() {
        return this._defaultCodepage.displayName();
    }

    @SmartScriptableObject.PropertyTag
    public long getContentSize() {
        if (!this._calculateSize) {
            throw new InformException("\u0420\u0435\u0436\u0438\u043c \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
        }
        return this._contentSize;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getCalculateSize() {
        return this._calculateSize;
    }

    public void setCalculateSize(boolean calculateSize) {
        this._calculateSize = calculateSize;
    }

    @SmartScriptableObject.FunctionTag
    public String toString() {
        this.closeIfNeeded();
        this.check();
        return this.beginEndStrBuff.toString();
    }

    String getHeader(String codepage) {
        String HEADER0 = "<?xml version=\"1.0\" encoding=\"";
        String HEADER1 = "\"?>\r\n";
        return HEADER0 + codepage.toUpperCase() + HEADER1;
    }

    static String codepageToCp(String codepage) throws Exception {
        String cp;
        if (codepage.equalsIgnoreCase("WINDOWS-1251")) {
            cp = "Cp1251";
        } else if (codepage.equalsIgnoreCase("UTF-8")) {
            cp = "UTF-8";
        } else {
            throw new Exception("\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + codepage + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
        return cp;
    }

    byte[] getBytes(String codepage) throws Exception {
        return this.toString().getBytes(codepage);
    }

    void saveToStream(OutputStream stream, String codepage) throws Exception {
        codepage = codepage == null ? this._defaultCodepage.displayName().toUpperCase() : codepage.toUpperCase();
        String cp = XmlWriter.codepageToCp(codepage);
        stream.write(this.getHeader(codepage).getBytes(cp));
        stream.write(this.getBytes(cp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public static Object saveToFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        XmlWriter self = (XmlWriter)thisObj;
        String path = (String)args[0];
        String codepage = null;
        if (args.length > 1) {
            codepage = (String)args[1];
        }
        try (FileOutputStream fs = new FileOutputStream(Core.mountfs.resolvePath(path));){
            self.saveToStream(fs, codepage);
        }
        return Undefined.instance;
    }

    @SmartScriptableObject.FunctionTag
    public static void saveToBlob(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        XmlWriter self = (XmlWriter)thisObj;
        if (args.length > 0 && (args[0] instanceof BlobField || args[0] instanceof BlobFileField)) {
            String codepage = null;
            if (args.length > 1) {
                codepage = (String)args[1];
            }
            try (ByteArrayOutputStream bs = new ByteArrayOutputStream();){
                self.saveToStream(bs, codepage);
                byte[] content = bs.toByteArray();
                BinaryObject binary = new BinaryObject(content);
                DatasourceField field = (DatasourceField)args[0];
                field.assign(binary);
            }
        } else {
            throw new Exception("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435\u043c Blob");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public static Object toBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        XmlWriter self = (XmlWriter)thisObj;
        String codepage = null;
        if (args.length > 0) {
            codepage = (String)args[0];
        }
        try (ByteArrayOutputStream bs = new ByteArrayOutputStream();){
            BinaryObject blob;
            self.saveToStream(bs, codepage);
            byte[] content = bs.toByteArray();
            BinaryObject binaryObject = blob = new BinaryObject(content);
            return binaryObject;
        }
    }

    private void check() {
        if (!this.beginEndStack.isEmpty()) {
            throw new InformException("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0442\u0435\u0433 " + this.beginEndStack.peekLast());
        }
    }

    private String replaceSpecChar(String text) {
        StringBuilder tmp = new StringBuilder();
        block6: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    tmp.append("&quot;");
                    continue block6;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block6;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block6;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block6;
                }
                default: {
                    tmp.append(c);
                }
            }
        }
        return tmp.toString();
    }

    private static enum TagState {
        StateTagHeaderOpen,
        StateTagHeaderClose,
        StateTagClose;

    }
}

