/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.request.GetAccountNodeInfo;
import inform.agent.scripts.metadata.InetAddList;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptCustomNode;
import inform.agent.scripts.metadata.ScriptNode;
import inform.common.Empty;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class ScriptAccountNode
extends ScriptCustomNode {
    private static final int TAG_UI_FAST_SAVE = 1;
    private static final int TAG_UI_PROP_SETTING = 2;
    private static final int TAG_UI_NODE_TYPES = 3;
    private static final int TAG_UI_NODE_TYPES_ALL = 4;
    private static final int TAG_UI_SIMPLE_POPUP = 5;
    public static final int TAG_USER_SERVER_ALL_IP = 1;
    public static final int TAG_USER_SERVER_IP = 2;
    private static final int TAG_NODE_USER_GROUP_NODES = 34;
    private static final int TAG_NODE_USER_SERVER_IPS = 50;
    private static final int TAG_NODE_USER_INHERIT_SERVER_IPS = 51;
    protected double[] groups;
    protected byte[] constantsContent;
    protected boolean locked = false;
    protected boolean _locked = false;
    protected double passwordChangeDate = 0.0;
    protected boolean ineritedConnectionToServer = false;
    protected boolean allowConnectionToAnyServer = false;
    protected IntegerList specifiedConnectionsToServer = null;
    protected InetAddList scriptConnectionsToServer = null;
    public Roles roles = null;
    protected double[] parentRoles = null;
    protected Roles effectiveRoles = null;
    protected final AccountNode.UserInterface userInterface = new AccountNode.UserInterface();
    protected ScriptUserInterface scriptUI = null;
    private boolean newUserInterface = false;
    protected boolean activeDirectory = false;
    protected boolean inheritedStartup = false;
    protected double startupRootNodeId = 0.0;
    protected double startupStartNodeId = 0.0;
    protected int startupStartNodeAction = -1;
    protected double startupScriptId = 0.0;
    protected ScriptAccountNode startupAccountNode = null;
    protected double webStartNodeId;
    private static final String[] jsProperties = new String[]{"isInheritedConnections", "isAllowAnyConnections", "allowedConnections", "isLocked", "roles", "activeDirectory", "inheritedStartup", "startupRootNodeId", "startupStartNodeId", "startupStartNodeAction", "startupScriptId", "startupStartWebNodeId", "userInterface", "effectiveRoles", "userName", "userID", "userId", "startupRootNodeID", "startupStartNodeID", "startupScriptID", "startupStartWebNodeID"};

    public ScriptAccountNode(MetadataLibrary metadataLibrary, MetadataNodeReader metadataNode) {
        super(metadataLibrary, metadataNode);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, ScriptAccountNode.class, 0);
        }
    }

    public double getUserId() {
        return this.getId();
    }

    public double getUserID() {
        return this.getId();
    }

    public double getStartupRootNodeID() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupRootNodeId;
    }

    public double getStartupStartNodeID() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupStartNodeId;
    }

    public double getStartupScriptID() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupScriptId;
    }

    public double getStartupStartWebNodeID() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.webStartNodeId;
    }

    public boolean getActiveDirectory() {
        return this.activeDirectory;
    }

    UserRole getUserRole() {
        return UserRole.DEFAULT;
    }

    void findUserInterface(AccountNode.UserInterface ui, int bits) throws IOException, SQLException {
        ScriptNode node;
        ScriptAccountNode accountNode = this;
        for (int i = 0; i <= 1024 && bits != 0 && (node = this.getParent()) != null && node.getId() != 0.0 && accountNode.getId() != node.getId() && node instanceof ScriptAccountNode; ++i) {
            accountNode = (ScriptAccountNode)node;
            bits = ui.updateInheritedValues(accountNode.userInterface, bits);
        }
    }

    public String getUserName() {
        return this.getName();
    }

    public ScriptUserInterface getUserInterface() throws IOException, SQLException {
        if (this.scriptUI == null) {
            AccountNode.UserInterface realUI = new AccountNode.UserInterface(this.userInterface);
            this.findUserInterface(realUI, realUI.getInheritedBits());
            this.scriptUI = new ScriptUserInterface(this.getUserRole(), this.userInterface, realUI);
        }
        return this.scriptUI;
    }

    void findStartupAccount() throws IOException, SQLException {
        if (this.startupAccountNode == null) {
            ScriptNode parent;
            this.startupAccountNode = this;
            for (int i = 0; i <= 1024 && this.startupAccountNode.inheritedStartup && (parent = this.getParent()) != null && parent instanceof ScriptAccountNode && this.startupAccountNode.getId() != parent.getId(); ++i) {
                this.startupAccountNode = (ScriptAccountNode)parent;
            }
        }
    }

    public boolean getInheritedStartup() {
        return this.inheritedStartup;
    }

    public void setInheritedStartup(boolean value) {
        this.inheritedStartup = value;
    }

    public double getStartupRootNodeId() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupRootNodeId;
    }

    public double getStartupStartNodeId() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupStartNodeId;
    }

    public int getStartupStartNodeAction() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupStartNodeAction;
    }

    public double getStartupScriptId() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.startupScriptId;
    }

    public double getStartupStartWebNodeId() throws IOException, SQLException {
        this.findStartupAccount();
        return this.startupAccountNode.webStartNodeId;
    }

    void loadUISettings(TaggedReader in) throws IOException, TaggedReaderException {
        if (this.newUserInterface) {
            return;
        }
        this.idle();
        this.userInterface.setAllInherited(false);
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.userInterface.savePerRecord = in.getBoolean();
                    break;
                }
                case 2: {
                    this.userInterface.canSetupUser = in.getBoolean();
                    break;
                }
                case 3: {
                    this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(in.getRaw());
                    this.userInterface.canCreateAnyNodes = false;
                    break;
                }
                case 4: {
                    this.userInterface.canCreateAnyNodes = in.getBoolean();
                    break;
                }
                case 5: {
                    this.userInterface.simplePopup = in.getBoolean();
                }
            }
        }
        this.idle();
    }

    void loadServerIPs(TaggedReader in) throws IOException, TaggedReaderException {
        this.idle();
        this.ineritedConnectionToServer = false;
        this.allowConnectionToAnyServer = false;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.allowConnectionToAnyServer = true;
                    break;
                }
                case 2: {
                    if (this.specifiedConnectionsToServer == null) {
                        this.specifiedConnectionsToServer = new IntegerList(4);
                    }
                    this.specifiedConnectionsToServer.add(in.getInt());
                }
            }
        }
        this.idle();
    }

    void loadContentTag(int tag, TaggedReader in) throws IOException, TaggedReaderException {
        this.idle();
        switch (tag) {
            case 1: {
                this.startupRootNodeId = in.getNodeID();
                break;
            }
            case 2: {
                this.startupStartNodeId = in.getNodeID();
                break;
            }
            case 3: {
                this.startupStartNodeAction = in.getInt();
                break;
            }
            case 4: {
                this.startupScriptId = in.getNodeID();
                break;
            }
            case 12: {
                this.webStartNodeId = in.getNodeID();
                break;
            }
            case 6: {
                this.constantsContent = in.getSubStreamData();
                break;
            }
            case 8: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(in.getBoolean());
                break;
            }
            case 9: {
                this.loadUISettings(in.getStreamReader());
                break;
            }
            case 11: {
                this.loadServerIPs(in.getStreamReader());
                break;
            }
            case 14: {
                this.userInterface.savePerRecord = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 15: {
                this.userInterface.inheritedSavePerRecord = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 16: {
                this.userInterface.canSetupUser = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 17: {
                this.userInterface.inheritedCanSetupUser = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 18: {
                this.userInterface.canCreateAnyNodes = true;
                this.newUserInterface = true;
                break;
            }
            case 19: {
                this.userInterface.canCreateAnyNodes = false;
                this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(in.getRaw());
                this.newUserInterface = true;
                break;
            }
            case 20: {
                this.userInterface.inheritedCanCreateNodes = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 21: {
                this.userInterface.simplePopup = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 22: {
                this.userInterface.inheritedSimplePopup = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 23: {
                this.userInterface.canWritePublicFilters = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 24: {
                this.userInterface.inheritedCanWritePublicFilters = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 25: {
                this.userInterface.canUploadPex = this.userInterface.canWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 26: {
                this.userInterface.inheritedCanUploadPex = this.userInterface.inheritedCanWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 31: {
                this.userInterface.canWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 32: {
                this.userInterface.inheritedCanWritePex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 33: {
                this.userInterface.canUploadPex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 34: {
                this.userInterface.inheritedCanUploadPex = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 27: {
                this.userInterface.canViewDataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 28: {
                this.userInterface.inheritedCanViewDataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 29: {
                this.userInterface.canViewMetadataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 30: {
                this.userInterface.inheritedCanViewMetadataHistory = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 36: {
                this.userInterface.editNode = in.getBoolean();
                this.newUserInterface = true;
                break;
            }
            case 37: {
                this.userInterface.inheritedEditNode = in.getBoolean();
                this.newUserInterface = true;
            }
        }
    }

    void loadContent(TaggedReader in) throws IOException, TaggedReaderException {
        this.newUserInterface = false;
        this.userInterface.setAllInherited(true);
        while (in.getNextTag() != 0) {
            this.idle();
            this.loadContentTag(in.getCurrentTag(), in);
        }
    }

    @Override
    void load(TaggedReader reader) throws IOException, TaggedReaderException {
        this.idle();
        super.load(reader);
        if (this.metaNode.content != null) {
            this.loadContent(new TaggedReader(new ByteArrayInputStream(this.metaNode.content), this.metaNode.content.length));
        }
    }

    @Override
    void loadTag(int tag, TaggedReader reader) throws IOException, TaggedReaderException {
        this.idle();
        switch (tag) {
            case 105: {
                this.groups = LittleEndian.toDoubleArray(reader.getRaw());
                break;
            }
            case 104: {
                this.inheritedStartup = !reader.getBoolean();
                break;
            }
            case 107: {
                this.constantsContent = reader.getSubStreamData();
                break;
            }
            case 111: {
                if (this.newUserInterface) break;
                this.userInterface.setAllInherited(reader.getBoolean());
                break;
            }
            case 110: {
                this.loadUISettings(reader.getStreamReader());
                break;
            }
            case 115: {
                this._locked = this.locked = reader.getBoolean();
                break;
            }
            case 114: {
                this.ineritedConnectionToServer = reader.getBoolean();
                break;
            }
            case 113: {
                this.loadServerIPs(reader.getStreamReader());
                break;
            }
            case 120: {
                this.passwordChangeDate = reader.getInt();
                break;
            }
            case 119: {
                this.activeDirectory = reader.getBoolean();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    public boolean getIsInheritedConnections() {
        this.idle();
        return this.ineritedConnectionToServer;
    }

    public void setIsInheritedConnections(boolean v) {
        this.idle();
        if (this.ineritedConnectionToServer != v) {
            this.setAttrTagModified(51);
        }
        this.ineritedConnectionToServer = v;
    }

    public boolean getIsAllowAnyConnections() {
        this.idle();
        return this.allowConnectionToAnyServer;
    }

    public void setIsAllowAnyConnections(boolean v) {
        this.idle();
        if (this.allowConnectionToAnyServer != v) {
            this.setAttrTagModified(50);
        }
        this.allowConnectionToAnyServer = v;
    }

    public boolean getIsLocked() {
        this.idle();
        return this.locked;
    }

    public void setIsLocked(boolean locked) {
        this.idle();
        if (this.locked != locked) {
            this.setAttrTagModified(52);
        }
        this._locked = locked;
    }

    public Object getAllowedConnections() {
        this.idle();
        if (this.scriptConnectionsToServer == null) {
            this.scriptConnectionsToServer = new InetAddList(this, 50, this.specifiedConnectionsToServer);
        }
        return this.scriptConnectionsToServer;
    }

    @Override
    protected boolean saveModifiedAttrTag(int tag, TaggedWriter writer) throws IOException {
        this.idle();
        if (super.saveModifiedAttrTag(tag, writer)) {
            return true;
        }
        switch (tag) {
            case 34: {
                if (this.roles != null) {
                    writer.putRaw(tag, LittleEndian.doubleCursorToBinary(this.roles.roles.iterator(), this.roles.roles.size()));
                    return true;
                }
                return false;
            }
            case 51: {
                writer.putBool(tag, this.ineritedConnectionToServer);
                return true;
            }
            case 50: {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                TaggedWriter stream = new TaggedWriter(bytes);
                if (this.scriptConnectionsToServer != null) {
                    this.specifiedConnectionsToServer = this.scriptConnectionsToServer.getIps();
                }
                if (this.allowConnectionToAnyServer) {
                    stream.putEmpty(1);
                }
                if (this.specifiedConnectionsToServer != null) {
                    for (Cursor.Integer ip : this.specifiedConnectionsToServer) {
                        stream.putInt32(2, ip.value);
                    }
                }
                stream.flush();
                writer.putRaw(tag, bytes);
                return true;
            }
            case 52: {
                writer.putBool(tag, this._locked);
                return true;
            }
        }
        return false;
    }

    public Object getRoles() {
        if (this.roles == null) {
            this.roles = new Roles(this);
        }
        return this.roles;
    }

    public double[] parentGroups() throws IOException, SQLException {
        if (this.parentRoles == null) {
            double[] tmp = new double[1024];
            int idx = 0;
            ScriptNode node = this;
            do {
                if ((node = node.getParent()) == null || !(node instanceof ScriptAccountNode)) continue;
                tmp[idx++] = node.getId();
            } while (node != null);
            this.parentRoles = idx == 0 ? Empty.doubleArray : Arrays.copyOf(tmp, idx + 1);
        }
        return this.parentRoles;
    }

    public Object getEffectiveRoles() throws IOException, SQLException {
        if (this.effectiveRoles == null) {
            double[] parentGroup = new double[]{this.getParentID()};
            double[] r = GetAccountNodeInfo.calcEffectiveRoles(parentGroup, this.groups);
            this.effectiveRoles = new Roles(this, r);
        }
        return this.effectiveRoles;
    }

    public static class ScriptUserInterface
    extends SmartScriptableObject {
        final AccountNode.UserInterface ui;
        final AccountNode.UserInterface realUI;
        final UserRole accessLevel;

        public ScriptUserInterface(UserRole accessLevel, AccountNode.UserInterface ui, AccountNode.UserInterface realUI) {
            this.ui = ui;
            this.realUI = realUI;
            this.accessLevel = accessLevel;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanSetupUser() {
            return this.ui.inheritedCanSetupUser;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanSetupUser() {
            return this.realUI.canSetupUser;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanWritePublicFilters() {
            return this.realUI.canWritePublicFilters;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanWritePublicFilters() {
            return this.ui.inheritedCanWritePublicFilters;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getSimplePopup() {
            return this.realUI.simplePopup;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedSimplePopup() {
            return this.ui.inheritedSimplePopup;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanWritePex() {
            return this.realUI.canWritePex || this.accessLevel == UserRole.ADMIN;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanWritePex() {
            return this.ui.inheritedCanWritePex;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanUploadPex() {
            return this.realUI.canUploadPex || this.accessLevel == UserRole.ADMIN;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanUploadPex() {
            return this.ui.inheritedCanUploadPex;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanViewDataHistory() {
            return this.realUI.canViewDataHistory || this.accessLevel == UserRole.ADMIN;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanViewDataHistory() {
            return this.ui.inheritedCanViewDataHistory;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanViewMetadataHistory() {
            return this.realUI.canViewMetadataHistory || this.accessLevel == UserRole.ADMIN;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanViewMetadataHistory() {
            return this.ui.inheritedCanViewMetadataHistory;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getCanCreateAnyNodes() {
            return this.realUI.canCreateAnyNodes;
        }

        @SmartScriptableObject.PropertyTag
        public Object getCanCreateNodeTypes() {
            return Context.javaToJS(this.realUI.canCreateNodeTypes, this);
        }

        @SmartScriptableObject.PropertyTag
        public boolean getInheritedCanCreateNodes() {
            return this.ui.inheritedCanCreateNodes;
        }
    }

    public static class Roles
    extends SmartScriptableObject {
        final ScriptAccountNode node;
        final DoubleList roles;
        DoubleSet hash;

        public Roles(ScriptAccountNode node) {
            this.node = node;
            this.roles = new DoubleList(4);
            this.hash = new DoubleSet();
            if (node.groups != null) {
                for (double g : node.groups) {
                    if (!this.hash.add(g)) continue;
                    this.roles.add(g);
                }
            }
            this.setParentScope(node);
        }

        public Roles(ScriptAccountNode node, double[] groups) {
            this.node = node;
            this.roles = new DoubleList(4);
            this.hash = new DoubleSet();
            if (groups != null) {
                for (double g : groups) {
                    if (!this.hash.add(g)) continue;
                    this.roles.add(g);
                }
            }
            this.setParentScope(node);
        }

        @Override
        public String getClassName() {
            return "AccountRoles";
        }

        @SmartScriptableObject.PropertyTag
        public int getLength() {
            return this.roles.size();
        }

        @Override
        public Object get(int index, Scriptable start) {
            if (index < 0 || index >= this.roles.size()) {
                return super.get(index, start);
            }
            return this.roles.get(index);
        }

        @SmartScriptableObject.PropertyTag
        public int getCount() {
            return this.roles.size();
        }

        @SmartScriptableObject.FunctionTag
        public void clear() {
            if (this.roles.empty()) {
                return;
            }
            this.roles.clear();
            this.hash = new DoubleSet();
            this.node.setAttrTagModified(34);
        }

        @SmartScriptableObject.FunctionTag
        public void add(double group) {
            if (this.hash.add(group)) {
                this.roles.add(group);
                this.node.setAttrTagModified(34);
            }
        }

        @SmartScriptableObject.FunctionTag
        public void remove(double group) {
            if (this.hash.remove(group)) {
                for (int i = 0; i < this.roles.size(); ++i) {
                    if (this.roles.get(i) != group) continue;
                    this.roles.remove(i);
                    break;
                }
                this.node.setAttrTagModified(34);
            }
        }

        @SmartScriptableObject.FunctionTag
        public boolean contains(double group) {
            return this.hash.contains(group);
        }
    }
}

