/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptAccountNode;
import inform.agent.scripts.metadata.ScriptNode;
import java.io.IOException;
import java.sql.SQLException;

public class ScriptUserGroupNode
extends ScriptAccountNode {
    private boolean activeDirectoryLogin = false;

    public ScriptUserGroupNode(MetadataLibrary metadataLibrary, MetadataNodeReader metadataNode) {
        super(metadataLibrary, metadataNode);
    }

    @Override
    public String getClassName() {
        return "UserGroupNode";
    }

    @Override
    void loadTag(int tag, TaggedReader reader) throws IOException, TaggedReaderException {
        this.idle();
        switch (tag) {
            case 119: {
                this.activeDirectoryLogin = reader.getBoolean();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    void updateImplicitGroups(DoubleSet set) throws IOException, InformException, SQLException {
        this.idle();
        double groupId = this.getId();
        if (!set.add(groupId)) {
            return;
        }
        for (ScriptNode node = this.getParent(); node != null; node = node.getParent()) {
            this.idle();
            if (!(node instanceof ScriptUserGroupNode)) break;
            ScriptUserGroupNode group = (ScriptUserGroupNode)node;
            group.updateImplicitGroups(set);
        }
        if (this.groups == null) {
            return;
        }
        for (double g : this.groups) {
            this.idle();
            ScriptNode node = this.metaLib.getNode(g);
            if (!(node instanceof ScriptUserGroupNode)) continue;
            ScriptUserGroupNode group = (ScriptUserGroupNode)node;
            group.updateImplicitGroups(set);
        }
    }
}

