/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.Acl;
import inform.agent.mtd.CalculateAccessMask;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.scripts.Constants;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptAccountNode;
import inform.agent.scripts.metadata.ScriptCustomNode;
import inform.agent.scripts.metadata.ScriptNode;
import inform.agent.scripts.metadata.ScriptUserGroupNode;
import java.io.IOException;
import java.sql.SQLException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ScriptUserNode
extends ScriptAccountNode {
    public static final int TAG_NODE_USER_FIO = 1;
    public static final int TAG_NODE_USER_SUBDIVISION = 2;
    public static final int TAG_NODE_USER_POST = 3;
    public static final int TAG_NODE_USER_PHONE = 4;
    public static final int TAG_NODE_USER_EMAIL = 5;
    public static final int TAG_NODE_USER_REGISTERNUMBER = 6;
    public static final int TAG_NODE_USER_UI_SCALE = 7;
    private static final String[] jsMethods = new String[]{"hasRole", "getAccessMaskForNode"};
    private static final String[] jsProperties = new String[]{"fio", "subdivision", "post", "phone", "email", "registerNumber", "constants", "accessLevel", "singleLogin", "changePasswordOnLogin", "possibleLoginCount"};
    protected UserRole accessLevel = UserRole.DEFAULT;
    protected String propFio;
    protected String propSubDivision;
    protected String propPost;
    protected String propPhone;
    protected String propEmail;
    protected String propRegisterNumber;
    protected double propUIScale = 1.0;
    protected boolean singleLogin = false;
    protected int possibleLoginCount = 0;
    protected Constants constants = null;
    protected boolean changePasswordOnLogin = false;
    protected DoubleSet implicitGroups;
    protected double parentGroupId;
    protected boolean needInitializeParentGroupId = true;

    public ScriptUserNode(MetadataLibrary metadataLibrary, MetadataNodeReader metadataNode) {
        super(metadataLibrary, metadataNode);
        this.defineFunctionProperties(jsMethods, ScriptUserNode.class, 0);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, ScriptUserNode.class, 1);
        }
    }

    public static Object hasRole(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, SQLException {
        Double roleId = null;
        if (args.length > 0) {
            roleId = ValueCaster.toDouble(args[0]);
        }
        if (roleId == null) {
            return false;
        }
        ScriptUserNode self = (ScriptUserNode)thisObj;
        return self.containsRole(roleId);
    }

    public static Object getAccessMaskForNode(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, SQLException {
        if (args.length == 0) {
            return 0;
        }
        ScriptUserNode self = (ScriptUserNode)thisObj;
        double nodeId = ValueCaster.toDouble(args[0]);
        ScriptNode aNode = self.metaLib.getNode(nodeId);
        if (aNode == null) {
            return 0;
        }
        ScriptCustomNode node = aNode.getRefNode();
        if (node == null) {
            return 0;
        }
        return node.calculateAccessMask(self);
    }

    int getAccessMask(Acl acl) throws IOException, InformException, SQLException {
        this.idle();
        this.updateImplicitGroups();
        CalculateAccessMask masks = new CalculateAccessMask();
        if (this.implicitGroups != null) {
            acl.updateAccessMasks(masks, this.implicitGroups);
        }
        double[] self = new double[]{this.getId(), -1.0};
        acl.updateAccessMasks(masks, self);
        this.idle();
        return masks.getMask();
    }

    @Override
    UserRole getUserRole() {
        return this.accessLevel;
    }

    public int getAccessLevel() {
        return this.accessLevel.toInt();
    }

    public boolean getSingleLogin() {
        return this.singleLogin;
    }

    public int getPossibleLoginCount() {
        return this.possibleLoginCount;
    }

    public boolean getChangePasswordOnLogin() {
        return this.changePasswordOnLogin;
    }

    @Override
    public String getClassName() {
        return "UserNode";
    }

    void loadUserProps(TaggedReader in) throws IOException {
        while (in.getNextTag() != 0) {
            this.idle();
            switch (in.getCurrentTag()) {
                case 1: {
                    this.propFio = in.getString();
                    break;
                }
                case 2: {
                    this.propSubDivision = in.getString();
                    break;
                }
                case 3: {
                    this.propPost = in.getString();
                    break;
                }
                case 4: {
                    this.propPhone = in.getString();
                    break;
                }
                case 5: {
                    this.propEmail = in.getString();
                    break;
                }
                case 6: {
                    this.propRegisterNumber = in.getString();
                    break;
                }
                case 7: {
                    this.propUIScale = in.getDouble();
                }
            }
        }
    }

    @Override
    void loadContentTag(int tag, TaggedReader in) throws IOException {
        this.idle();
        switch (tag) {
            case 7: {
                this.loadUserProps(in.getStreamReader());
                break;
            }
            case 35: {
                this.possibleLoginCount = in.getInt();
                this.singleLogin = this.possibleLoginCount == 1;
                break;
            }
            case 38: {
                break;
            }
            default: {
                super.loadContentTag(tag, in);
            }
        }
    }

    @Override
    void loadTag(int tag, TaggedReader reader) throws IOException {
        this.idle();
        switch (tag) {
            case 100: {
                if (reader.getInt() != 0) break;
                this.accessLevel = UserRole.ADMIN;
                break;
            }
            case 106: {
                this.accessLevel = UserRole.ADMIN;
                break;
            }
            case 108: {
                int intVal = reader.getInt();
                this.accessLevel = UserRole.get(intVal);
                assert (this.accessLevel != null);
                break;
            }
            case 109: {
                this.loadUserProps(reader.getStreamReader());
                break;
            }
            case 116: {
                this.singleLogin = reader.getBoolean();
                if (this.possibleLoginCount == 0) {
                    if (!this.singleLogin) break;
                    this.possibleLoginCount = 1;
                    break;
                }
                this.singleLogin = this.possibleLoginCount == 1;
                break;
            }
            case 117: {
                this.changePasswordOnLogin = reader.getBoolean();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    private void updateImplicitGroups() throws IOException, InformException, SQLException {
        this.idle();
        if (this.implicitGroups != null) {
            return;
        }
        this.implicitGroups = new DoubleSet();
        if (this.groups != null) {
            for (double g : this.groups) {
                this.idle();
                ScriptNode node = this.metaLib.getNode(g);
                if (!(node instanceof ScriptUserGroupNode)) continue;
                ScriptUserGroupNode group = (ScriptUserGroupNode)node;
                group.updateImplicitGroups(this.implicitGroups);
            }
        }
        for (ScriptNode node = this.getParent(); node != null; node = node.getParent()) {
            this.idle();
            if (!(node instanceof ScriptUserGroupNode)) break;
            ScriptUserGroupNode group = (ScriptUserGroupNode)node;
            group.updateImplicitGroups(this.implicitGroups);
        }
    }

    boolean containsRole(double roleId) throws IOException, InformException, SQLException {
        this.idle();
        this.updateImplicitGroups();
        return this.implicitGroups.contains(roleId);
    }

    double getParentGroupId() {
        if (this.needInitializeParentGroupId) {
            this.needInitializeParentGroupId = false;
            ScriptNode node = null;
            try {
                node = this.getParent();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            catch (SQLException e) {
                throw InformException.wrap(e);
            }
            this.parentGroupId = node instanceof ScriptUserGroupNode ? ((ScriptUserGroupNode)node).getId() : 0.0;
        }
        return this.parentGroupId;
    }

    public String getFio() {
        return this.propFio;
    }

    public String getSubdivision() {
        return this.propSubDivision;
    }

    public String getPost() {
        return this.propPost;
    }

    public String getPhone() {
        return this.propPhone;
    }

    public String getEmail() {
        return this.propEmail;
    }

    public String getRegisterNumber() {
        return this.propRegisterNumber;
    }

    public Constants getConstants() throws InformException, IOException {
        this.idle();
        if (this.constants == null) {
            this.constants = new Constants(this.getId());
            this.constants.loadFromUser(this.getParentGroupId(), this.metaLib.getGlobalConstantsContent(), this.constantsContent);
            this.constants.setParentScope(this);
        }
        this.idle();
        return this.constants;
    }

    @Override
    public void save() throws Exception {
        if (this.constants != null && this.constants.isModified()) {
            throw new InformException("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442 \u0443\u0437\u043b\u0430 \u0442\u0438\u043f\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
        super.save();
    }
}

