/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.notify;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.js.Serialization;
import inform.agent.scripts.notify.Topic;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class Notification
extends ScriptableObject {
    public static final int TAG_SS_NTFCTN_TOPIC_KEY = 1;
    public static final int TAG_SS_NTFCTN_KEY = 2;
    public static final int TAG_SS_NTFCTN_TEXT = 3;
    public static final int TAG_SS_NTFCTN_PARAM = 4;
    public static final int TAG_SS_NTFCTN_ICON = 5;
    public static final int TAG_SS_NTFCTN_ORDER = 6;
    public static final int TAG_SS_NTFCTN_ACTIVATION_NODE = 7;
    public static final int TAG_SS_NTFCTN_ACTIVATION_FUNC = 8;
    private Topic topic;
    private String key;
    private String text;
    private double icon = 0.0;
    private double order = 0.0;
    private Object activationParameter = null;
    private String activationFunction = "";
    private double activationNode = -1.0;
    private static final String[] jsReadonlyProps = new String[]{"key", "topic"};
    private static final String[] jsProps = new String[]{"text", "icon", "order", "activationNode", "activationFunction", "activationParameter"};

    public Notification(Topic topic, String key) {
        this.topic = topic;
        this.key = key;
        for (String propertyName : jsReadonlyProps) {
            this.defineProperty(propertyName, Notification.class, 1);
        }
        for (String propertyName : jsProps) {
            this.defineProperty(propertyName, Notification.class, 0);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void storeBody(TaggedWriter out) throws IOException {
        Serialization s = new Serialization();
        s.Serialize(this.activationParameter, out);
    }

    public double getIcon() {
        return this.icon;
    }

    public void setIcon(double icon) {
        this.icon = icon;
    }

    public double getOrder() {
        return this.order;
    }

    public void setOrder(double order) {
        this.order = order;
    }

    public String getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(String activationFunction) {
        this.activationFunction = activationFunction;
    }

    public double getActivationNode() {
        return this.activationNode;
    }

    public void setActivationNode(double activationNode) {
        this.activationNode = activationNode;
    }

    public Object getActivationParameter() {
        return this.activationParameter;
    }

    public void setActivationParameter(Object activationParameter) {
        this.activationParameter = activationParameter;
    }

    public void store(TaggedWriter out) throws IOException {
        out.putDouble(1, this.topic.getTopicID());
        out.putString(2, this.key);
        out.putDouble(5, this.getIcon());
        out.putDouble(6, this.getOrder());
        if (this.text != null && !this.text.isEmpty()) {
            out.putString(3, this.text);
        }
        if (this.getActivationNode() != -1.0) {
            out.putDouble(7, this.getActivationNode());
        }
        if (!this.getActivationFunction().isEmpty()) {
            out.putString(8, this.getActivationFunction());
        }
        if (this.activationParameter != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter bodyOut = new TaggedWriter(stream);
            this.storeBody(bodyOut);
            bodyOut.flush();
            if (stream.size() > 0) {
                out.putRaw(4, stream);
            }
        }
    }

    public void storeAs(int tag, TaggedWriter writer) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(stream);
        this.store(out);
        out.flush();
        if (stream.size() > 0) {
            writer.putRaw(tag, stream);
        }
    }

    @Override
    public String getClassName() {
        return "Notification";
    }
}

