/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.notify;

import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.types.ValueCaster;
import inform.agent.js.Serialization;
import inform.agent.scripts.notify.Notification;
import inform.agent.scripts.notify.NotificationList;
import java.io.IOException;
import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Topic
extends ScriptableObject {
    public static final int TAG_SS_NTFCTN_TOPIC_KEY = 1;
    public static final int TAG_SS_NTFCTN_TOPIC_TEXT = 2;
    public static final int TAG_SS_NTFCTN_TOPIC_PARAM = 3;
    public static final int TAG_SS_NTFCTN_TOPIC_ACTIVATION_NODE = 4;
    public static final int TAG_SS_NTFCTN_TOPIC_NOTIFICATION = 5;
    public static final int TAG_SS_NTFCTN_TOPIC_ACTIVATION_FUNC = 6;
    public static final int TAG_SS_NTFCTN_TOPIC_ICON = 7;
    public static final int TAG_SS_NTFCTN_TOPIC_ALERT_ICON = 8;
    public static final int TAG_SS_NTFCTN_TOPIC_ORDER = 9;
    public static final int TAG_SS_NTFCTN_TOPIC_IS_SYSTEM = 10;
    private double topicID = 0.0;
    private String text = "";
    private double activationNode = -1.0;
    private double icon = 0.0;
    private double alertIcon = 0.0;
    private double order = 0.0;
    protected boolean isSystem = false;
    private Object activationParameter = null;
    private String activationFunction = "";
    private NotificationList notifications;
    private DoubleSet recipients = null;
    private static final String[] jsMethods = new String[]{"add", "sendToUser", "clear", "send", "addRecipient", "clearRecipients"};
    private static final String[] jsReadonlyProps = new String[]{"count", "topicID"};
    private static final String[] jsProps = new String[]{"text", "activationNode", "activationFunction", "icon", "alertIcon", "order", "activationParameter"};

    public Topic(double topicID) {
        this.topicID = topicID;
        this.defineFunctionProperties(jsMethods, Topic.class, 0);
        for (String propertyName : jsReadonlyProps) {
            this.defineProperty(propertyName, Topic.class, 1);
        }
        for (String propertyName : jsProps) {
            this.defineProperty(propertyName, Topic.class, 0);
        }
        this.notifications = new NotificationList(this.getParentScope());
    }

    public Topic(double topicID, boolean scripLess) {
        this.topicID = topicID;
    }

    public void storeBody(TaggedWriter out) throws IOException {
        Serialization s = new Serialization();
        s.Serialize(this.activationParameter, out);
    }

    public void store(TaggedWriter out) throws IOException {
        out.putDouble(1, this.getTopicID());
        if (this.text != null && !this.text.isEmpty()) {
            out.putString(2, this.text);
        }
        out.putDouble(7, this.getIcon());
        out.putDouble(9, this.getOrder());
        out.putDouble(8, this.getAlertIcon());
        if (this.getActivationNode() != -1.0) {
            out.putDouble(4, this.getActivationNode());
        }
        if (!this.getActivationFunction().isEmpty()) {
            out.putString(6, this.getActivationFunction());
        }
        if (this.activationParameter != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter bodyOut = new TaggedWriter(stream);
            this.storeBody(bodyOut);
            bodyOut.flush();
            if (stream.size() > 0) {
                out.putRaw(3, stream);
            }
        }
        if (this.isSystem) {
            out.putEmpty(10);
        }
        if (this.notifications != null) {
            Iterator<Notification> it = this.notifications.getIterator();
            while (it.hasNext()) {
                Notification n = it.next();
                n.storeAs(5, out);
            }
        }
    }

    public void storeAs(int tag, TaggedWriter writer) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(stream);
        this.store(out);
        out.flush();
        if (stream.size() > 0) {
            writer.putRaw(tag, stream);
        }
    }

    public byte[] getContent() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(stream);
        this.store(out);
        out.flush();
        if (stream.size() > 0) {
            return stream.toByteArray();
        }
        return null;
    }

    public double getTopicID() {
        return this.topicID;
    }

    public void setTopicID(double topicID) {
        this.topicID = topicID;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getActivationNode() {
        return this.activationNode;
    }

    public void setActivationNode(double activationNode) {
        this.activationNode = activationNode;
    }

    public void clear() {
        this.notifications = null;
        this.text = null;
    }

    public double getAlertIcon() {
        return this.alertIcon;
    }

    public void setAlertIcon(double alertIcon) {
        this.alertIcon = alertIcon;
    }

    public double getIcon() {
        return this.icon;
    }

    public void setIcon(double icon) {
        this.icon = icon;
    }

    public double getOrder() {
        return this.order;
    }

    public void setOrder(double order) {
        this.order = order;
    }

    public String getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(String activationFunction) {
        this.activationFunction = activationFunction;
    }

    public Object getActivationParameter() {
        return this.activationParameter;
    }

    public void setActivationParameter(Object activationParameter) {
        this.activationParameter = activationParameter;
    }

    @Override
    public String getClassName() {
        return "Topic";
    }

    public int getCount() {
        if (this.notifications == null) {
            return 0;
        }
        return this.notifications.size();
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.notifications != null && index < this.notifications.size()) {
            return this.notifications.getByIndex(index);
        }
        return super.get(index, start);
    }

    public static Object add(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (args.length == 0) {
            return null;
        }
        Topic self = (Topic)thisObj;
        String notificationKey = ValueCaster.toString(args[0]);
        Notification notification = new Notification(self, notificationKey);
        if (self.notifications == null) {
            self.notifications = new NotificationList(self.getParentScope());
        }
        self.notifications.put(notification);
        return notification;
    }

    public Notification createNotification(String notificationKey) throws InformException {
        Notification notification = new Notification(this, notificationKey);
        if (this.notifications == null) {
            this.notifications = new NotificationList(this.getParentScope());
        }
        this.notifications.put(notification);
        return notification;
    }

    public static void sendToUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException, IOException {
        if (args.length == 0) {
            return;
        }
        Double user = ValueCaster.toDouble(args[0]);
        Topic self = (Topic)thisObj;
        byte[] content = self.getContent();
        Core.sendUserNotification(user, content);
    }

    public void send() throws InformException, IOException {
        byte[] content = this.getContent();
        for (Cursor.Double userId : this.recipients) {
            Core.sendUserNotification(userId.value, content);
        }
    }

    public void addRecipient(double userId) {
        if (this.recipients == null) {
            this.recipients = new DoubleSet();
        }
        this.recipients.add(userId);
    }

    public void clearRecipients() {
        this.recipients = null;
    }

    public DoubleSet getRecipients() {
        return this.recipients;
    }
}

