/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.server;

import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.db.types.ValueCaster;
import inform.agent.net.AgentConnection;
import inform.agent.net.ClientProtocol;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.TaggedIOLibrary;
import inform.agent.scripts.Task;
import inform.agent.scripts.notify.Topic;
import inform.common.SmartScriptableObject;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ServerConnection
extends SmartScriptableObject
implements Closeable {
    private final Task task;
    private final String connectionName;
    private DoubleSet users = null;
    private ScriptAgentConnection connection = null;

    public ServerConnection(Task task, Scriptable scope, String connectionName) {
        this.task = task;
        this.connectionName = connectionName;
        this.setParentScope(scope);
    }

    @Override
    public String getClassName() {
        return "SeverConnection";
    }

    @SmartScriptableObject.PropertyTag
    public String getServerVersion() throws InformException {
        this.checkConnection();
        return this.connection.getVersionInfo().toString();
    }

    @SmartScriptableObject.PropertyTag
    public String getAgentId() throws InformException {
        this.checkConnection();
        return this.connection.getAgentId();
    }

    @SmartScriptableObject.PropertyTag
    public String getServerId() throws InformException {
        this.checkConnection();
        return this.connection.getServerId();
    }

    @SmartScriptableObject.FunctionTag
    public Object getConnectedUserIDs() throws InformException, IOException, TaggedReaderException {
        this.updateConnectedUsers();
        return Context.javaToJS(this.users.toArray(), this);
    }

    @SmartScriptableObject.FunctionTag
    public boolean isUserConnected(double userId) throws InformException, IOException, TaggedReaderException {
        this.updateConnectedUsers();
        return this.users.contains(userId);
    }

    @SmartScriptableObject.FunctionTag
    public void sendNotification(Topic topic) throws InformException, IOException {
        this.checkConnection();
        DoubleSet users = topic.getRecipients();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(content);
        for (Cursor.Double userId : users) {
            out.putDouble(1, userId.value);
        }
        out.putRaw(2, topic.getContent());
        out.flush();
        AgentConnection.Request request = new AgentConnection.Request(135, 0.0);
        request.setParams(content.toByteArray());
        this.connection.request(request);
        this.connection.waitForResult();
    }

    @SmartScriptableObject.FunctionTag
    public void sendNotificationToUser(double userId, Topic topic) throws InformException, IOException {
        this.checkConnection();
        DoubleSet users = topic.getRecipients();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(content);
        out.putDouble(1, userId);
        out.putRaw(2, topic.getContent());
        out.flush();
        AgentConnection.Request request = new AgentConnection.Request(135, 0.0);
        request.setParams(content.toByteArray());
        this.connection.request(request);
        this.connection.waitForResult();
    }

    private void updateConnectedUsers() throws InformException, IOException {
        if (this.users != null) {
            return;
        }
        this.checkConnection();
        this.users = new DoubleSet();
        AgentConnection.Request request = new AgentConnection.Request(73, 0.0);
        this.connection.request(request);
        this.connection.waitForResult();
        byte[][] chunks = request.getResult();
        if (chunks == null) {
            return;
        }
        for (byte[] result : chunks) {
            TaggedReader in = new TaggedReader(result);
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 3: {
                        this.users.add(in.getDouble());
                    }
                }
            }
        }
    }

    private void checkConnection() throws InformException {
        if (this.connection == null) {
            throw new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 " + this.connectionName + " \u0437\u0430\u043a\u0440\u044b\u0442\u043e");
        }
    }

    public void connect(String serverName, String agentName, double userId, String userName, String password) throws IOException, InformException {
        this.close();
        InetSocketAddress address = ScriptAgentConnection.s2a(serverName);
        this.connection = new ScriptAgentConnection(this.task.getHost(), address, serverName, agentName, userId, userName, password);
    }

    @Override
    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        if (this.connection != null) {
            this.users = null;
            try {
                this.connection.close();
            }
            catch (InformException e) {
                throw new IOException(e);
            }
            this.connection = null;
        }
    }

    @SmartScriptableObject.FunctionTag
    public static Object executeModule(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        Object[] ids;
        if (args.length < 1) {
            throw new IllegalStateException();
        }
        double nodeId = ValueCaster.toNumber(args[0]).doubleValue();
        Scriptable arg = null;
        String[] names = null;
        java.io.ByteArrayOutputStream paramContent = null;
        if (args.length > 1 && args[1] != null && args[1] instanceof Scriptable && (ids = (arg = (Scriptable)args[1]).getIds()) != null && ids.length != 0) {
            names = new String[ids.length];
            paramContent = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(paramContent);
            int index = 0;
            for (Object id : ids) {
                String name = ValueCaster.toString(id);
                names[index++] = name;
                Object value = arg.get(name, arg);
                if (value == Scriptable.NOT_FOUND) continue;
                ParametersList.storeNamedParameter(out, name, value);
            }
            out.flush();
        }
        AgentConnection.Request request = new AgentConnection.Request(501, nodeId);
        if (paramContent != null && paramContent.size() != 0) {
            ByteArrayOutputStream requestContent = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(requestContent);
            out.putEmpty(153);
            out.putRaw(202, (ByteArrayOutputStream)paramContent);
            out.flush();
            request.setParams(requestContent.toByteArray());
        }
        ServerConnection self = (ServerConnection)thisObj;
        self.connection.request(request);
        self.connection.waitForResult();
        byte[][] result = request.getResult();
        if (result == null) {
            return null;
        }
        Object resObj = null;
        for (int i = 0; i < result.length; ++i) {
            TaggedReader in = new TaggedReader(result[i]);
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 3: {
                        TaggedReader resIn = in.getStreamReader();
                        resObj = TaggedIOLibrary.deserializeToJS(cx, self.getParentScope(), resIn);
                        break;
                    }
                    case 153: {
                        if (arg == null || names == null || names.length == 0) break;
                        TaggedReader paramIn = in.getSubStreamReader();
                        ParametersList.loadScriptParams(self.getParentScope(), paramIn, arg, names);
                    }
                }
            }
        }
        return resObj;
    }

    class ScriptAgentConnection
    extends AgentConnection {
        public ScriptAgentConnection(ServerSideHost ssHost, InetSocketAddress address, String server, String agent, double userId, String user, String password) throws InformException {
            super(ClientProtocol.ClientType.ServerScript, ssHost, address, agent, userId, user, password, 0.0, new ScriptAgentConnectionContext(address, agent, user));
        }
    }

    public static class ScriptAgentConnectionContext
    extends AgentConnection.Context {
        public ScriptAgentConnectionContext(InetSocketAddress addr, String agent, String user) {
            super(addr, agent, user, 0.0);
        }

        @Override
        public InformException remakeException(String text, Throwable cause) {
            StringBuilder result = new StringBuilder();
            result.append("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443, ").append(text).append('\n');
            result.append(cause.getMessage());
            return new ServerConnectionException(result.toString(), cause);
        }

        class ServerConnectionException
        extends InformException {
            ServerConnectionException(String text, Throwable cause) {
                super(text, cause);
            }
        }
    }
}

