/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.server;

import inform.adt.InformException;
import inform.agent.AgentJARVersion;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.sql.ParserStringReader;
import inform.agent.db.types.ValueCaster;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class SessionLib
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"compareClientVersion", "compareServerVersion"};
    private static final String[] jsProps = new String[]{"clientVersion", "currentUserID", "clientHost", "clientIP", "clientOSUserName", "sessionID", "serverVersion", "agentName", "agentID", "serverID", "agentInstanceID", "isCurrentUserAnonymous"};
    private ServerSideHost ssHost;

    public SessionLib(Scriptable scope, ServerSideHost ssHost) {
        this.setParentScope(scope);
        this.ssHost = ssHost;
        this.defineFunctionProperties(jsMethods, SessionLib.class, 0);
        for (String propertyName : jsProps) {
            this.defineProperty(propertyName, SessionLib.class, 1);
        }
    }

    @Override
    public String getClassName() {
        return "SessionLib";
    }

    public Object getClientVersion() {
        if (this.ssHost == null) {
            return Undefined.instance;
        }
        VersionInfo v = this.ssHost.getClientVersion();
        if (v == null) {
            return Undefined.instance;
        }
        return v.toString();
    }

    public Object getServerVersion() {
        return AgentJARVersion.asString();
    }

    public Object getAgentID() {
        return Ini.AgentID;
    }

    public String getAgentName() {
        return Ini.AgentName;
    }

    public Object getServerID() {
        return Ini.ServerID;
    }

    public Object getAgentInstanceID() {
        return Core.getApplicationId();
    }

    public Object getCurrentUserID() {
        if (this.ssHost == null) {
            return Undefined.instance;
        }
        return this.ssHost.getUserID();
    }

    public Object getIsCurrentUserAnonymous() {
        if (this.ssHost == null || this.ssHost.client() == null) {
            return Undefined.instance;
        }
        return this.ssHost.client().isCurrentUserAnonymous();
    }

    public Object getClientHost() {
        if (this.ssHost == null || this.ssHost.client() == null) {
            return Undefined.instance;
        }
        return this.ssHost.client().getHostComputerName();
    }

    public Object getClientIP() {
        if (this.ssHost == null || this.ssHost.client() == null) {
            return Undefined.instance;
        }
        return this.ssHost.client().getHostIP();
    }

    public Object getClientOSUserName() {
        if (this.ssHost == null || this.ssHost.client() == null) {
            return Undefined.instance;
        }
        return this.ssHost.client().getHostUserName();
    }

    public Object getSessionID() {
        if (this.ssHost == null) {
            return Undefined.instance;
        }
        return this.ssHost.getSessionID();
    }

    public static long versionToNumber(long major, long minor, long release) {
        return major << 24 | minor << 16 | release;
    }

    public static long parseStringVersion(String v) throws IOException {
        String str = v.replace('.', ' ').replace('-', ' ');
        ParserStringReader reader = new ParserStringReader(str);
        StreamTokenizer parser = new StreamTokenizer(reader);
        parser.parseNumbers();
        int[] version = new int[]{0, 0, 0};
        int index = 0;
        int tokenType = 0;
        while (index < version.length && tokenType != -1) {
            tokenType = parser.nextToken();
            if (tokenType != -2) continue;
            version[index] = (int)parser.nval;
            ++index;
        }
        return SessionLib.versionToNumber(version[0], version[1], version[2]);
    }

    public static Object compareClientVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException {
        return SessionLib.compareVersion(args, ((SessionLib)thisObj).getClientVersion());
    }

    public static Object compareServerVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException {
        return SessionLib.compareVersion(args, ((SessionLib)thisObj).getServerVersion());
    }

    private static Object compareVersion(Object[] args, Object def) throws IOException {
        long v2;
        long v1 = SessionLib.parseStringVersion(ValueCaster.toString(args[0]));
        if (args.length > 1) {
            v2 = SessionLib.parseStringVersion(ValueCaster.toString(args[1]));
        } else {
            Object s = def;
            if (s == null || Undefined.instance == s) {
                return Undefined.instance;
            }
            v2 = SessionLib.parseStringVersion((String)s);
        }
        return v1 - v2;
    }
}

