/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.soap.SoapAttachmentPart;
import inform.agent.scripts.soap.SoapAttachmentParts;
import inform.agent.scripts.soap.SoapBody;
import inform.agent.scripts.soap.SoapEnvelope;
import inform.agent.scripts.soap.SoapHeader;
import inform.agent.scripts.soap.SoapMimeHeaders;
import inform.agent.scripts.soap.SoapName;
import inform.agent.scripts.soap.SoapPart;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.mozilla.javascript.Scriptable;

public class SoapMessage
extends SmartScriptableObject {
    private final SOAPMessage message;
    private final SOAPPart soapPart;
    private final String protocolVersion;
    private SoapEnvelope envelope = null;
    private SoapHeader header = null;
    private SoapBody body = null;
    private SoapMimeHeaders mimeHeaders = null;
    private SoapAttachmentParts parts = null;
    private SoapPart messagePart = null;

    public SoapMessage(Scriptable scope, SOAPMessage message, String protocolVersion) {
        this.setParentScope(scope);
        this.message = message;
        this.soapPart = message.getSOAPPart();
        this.protocolVersion = protocolVersion;
    }

    @SmartScriptableObject.FunctionTag
    public SoapName createName(Object localName, Object prefix, Object uri) throws SOAPException {
        String n;
        String string = n = localName instanceof String ? (String)localName : null;
        if (n == null) {
            return null;
        }
        String p = prefix instanceof String ? (String)prefix : null;
        String u = uri instanceof String ? (String)uri : null;
        SOAPEnvelope env = this.soapPart.getEnvelope();
        Name name = env.createName(n, p, u);
        return name == null ? null : new SoapName((Scriptable)this, name);
    }

    @SmartScriptableObject.PropertyTag
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @SmartScriptableObject.PropertyTag
    public String getContentID() throws SOAPException {
        return this.soapPart.getContentId();
    }

    public void setContentID(String v) throws SOAPException {
        this.soapPart.setContentId(v);
    }

    @SmartScriptableObject.PropertyTag
    public SoapEnvelope getEnvelope() throws SOAPException {
        if (this.envelope == null) {
            this.envelope = new SoapEnvelope((Scriptable)this, this.soapPart.getEnvelope());
        }
        return this.envelope;
    }

    @SmartScriptableObject.PropertyTag
    public SoapHeader getHeader() throws SOAPException {
        if (this.header == null) {
            this.header = new SoapHeader((Scriptable)this, this.message.getSOAPHeader());
        }
        return this.header;
    }

    @SmartScriptableObject.PropertyTag
    public SoapBody getBody() throws SOAPException {
        if (this.body == null) {
            this.body = new SoapBody((Scriptable)this, this.message.getSOAPBody());
        }
        return this.body;
    }

    @SmartScriptableObject.PropertyTag
    public SoapPart getSoapPart() throws SOAPException {
        if (this.messagePart == null) {
            this.messagePart = new SoapPart((Scriptable)this, this.soapPart);
        }
        return this.messagePart;
    }

    private ByteArrayOutputStream getBytesStream() throws Exception {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        if (this.message.saveRequired() || this.message.countAttachments() > 0) {
            this.message.saveChanges();
        }
        this.message.writeTo((OutputStream)tmp);
        tmp.flush();
        return tmp;
    }

    @SmartScriptableObject.FunctionTag
    public String toString(Object codepage) throws Exception {
        ByteArrayOutputStream stream = this.getBytesStream();
        if (stream == null) {
            return null;
        }
        Charset charset = TaggedWriter.ANSI;
        if (codepage instanceof String && !((String)codepage).isEmpty()) {
            charset = Charset.forName((String)codepage);
        }
        return new String(stream.internalBuffer(), 0, stream.size(), charset);
    }

    @SmartScriptableObject.PropertyTag
    public String getAsString() throws Exception {
        ByteArrayOutputStream stream = this.getBytesStream();
        if (stream == null) {
            return null;
        }
        return new String(stream.internalBuffer(), 0, stream.size(), TaggedWriter.ANSI);
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getAsBinary() throws Exception {
        ByteArrayOutputStream stream = this.getBytesStream();
        if (stream == null) {
            return null;
        }
        return new BinaryObject(stream.toByteArray());
    }

    @SmartScriptableObject.PropertyTag
    public SoapMimeHeaders getMimeHeaders() {
        if (this.mimeHeaders == null) {
            this.mimeHeaders = new SoapMimeHeaders((Scriptable)this, this.message);
        }
        return this.mimeHeaders;
    }

    @SmartScriptableObject.PropertyTag
    public int getPartsCount() {
        return this.message.countAttachments();
    }

    @SmartScriptableObject.PropertyTag
    public SoapAttachmentParts getParts() {
        if (this.parts == null) {
            this.parts = new SoapAttachmentParts((Scriptable)this, this.message);
        }
        return this.parts;
    }

    @SmartScriptableObject.FunctionTag
    public SoapAttachmentPart addPart(String contentType, Object data, Object codepage) throws Exception {
        SoapAttachmentPart result;
        if (this.parts == null) {
            this.parts = new SoapAttachmentParts((Scriptable)this, this.message);
        }
        if ((result = this.parts.createAttachmentPart()) != null) {
            result.setContent(contentType, data, codepage);
        }
        return result;
    }

    @SmartScriptableObject.FunctionTag
    public void clearParts() throws SOAPException {
        if (this.parts == null) {
            this.parts = new SoapAttachmentParts((Scriptable)this, this.message);
        }
        this.parts.clearAttachmentParts();
    }
}

