/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.excel;

import inform.adt.InformException;
import inform.agent.scripts.spreadsheets.excel.ExcelFont;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbook;
import inform.common.SmartScriptableObject;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelCellStyle
extends SmartScriptableObject {
    private static final String MESSAGE_BADORIENTATION = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u0438 \u0442\u0435\u043a\u0441\u0442\u0430: '%s'. \u0427\u0438\u0441\u043b\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 -90 \u0434\u043e 90.";
    private static final String MESSAGE_BADBORDERSIDE = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u044f\u0447\u0435\u0439\u043a\u0438: '%s'. \u0427\u0438\u0441\u043b\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 0 \u0434\u043e 5.";
    private static final String MESSAGE_BADBORDERSTYLE = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043b\u0438\u043d\u0438\u0438 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    private final ExcelWorkbook book;
    final CellStyle style;

    ExcelCellStyle(ExcelWorkbook book) {
        this.setParentScope(book);
        this.book = book;
        this.style = book.workbook.createCellStyle();
    }

    ExcelCellStyle(ExcelWorkbook book, ExcelCellStyle cellStyle) {
        this(book);
        if (cellStyle != null) {
            this.style.cloneStyleFrom(cellStyle.style);
        }
    }

    ExcelCellStyle(ExcelWorkbook book, CellStyle cellStyle) {
        this.setParentScope(book);
        this.book = book;
        this.style = cellStyle != null ? cellStyle : book.workbook.createCellStyle();
    }

    @Override
    public String getClassName() {
        return "ExcelCellStyle";
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setFont(ExcelFont value) {
        this.style.setFont(value.font);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont getFont() {
        Font font = this.book.workbook.getFontAt(this.style.getFontIndex());
        return this.book.createFont(font);
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setHorizontalAlignment(Object value) {
        this.style.setAlignment(HorizontalAlignment.forInt((int)((Number)value).intValue()));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setVerticalAlignment(Object value) {
        this.style.setVerticalAlignment(VerticalAlignment.forInt((int)((Number)value).intValue()));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setIndent(int value) {
        this.style.setIndention((short)value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setShrinkToFit(boolean value) {
        this.style.setShrinkToFit(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setWrapText(boolean value) {
        this.style.setWrapText(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setRotation(Object value) {
        int v = ((Number)value).intValue();
        if (v < -90 || v > 90) {
            throw new InformException(String.format(MESSAGE_BADORIENTATION, value));
        }
        this.style.setRotation((short)v);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setBorderColor(Object borderSide, Object borderColor) {
        int side = this.parseBorderSide(borderSide);
        Color color = this.book.parseColor(borderColor);
        if (this.book.workbook instanceof XSSFWorkbook) {
            XSSFColor colorValue = (XSSFColor)color;
            XSSFCellStyle cellStyle = (XSSFCellStyle)this.style;
            switch (side) {
                case 0: {
                    cellStyle.setTopBorderColor(colorValue);
                    break;
                }
                case 1: {
                    cellStyle.setRightBorderColor(colorValue);
                    break;
                }
                case 2: {
                    cellStyle.setBottomBorderColor(colorValue);
                    break;
                }
                case 3: {
                    cellStyle.setLeftBorderColor(colorValue);
                    break;
                }
                case 4: {
                    cellStyle.setTopBorderColor(colorValue);
                    cellStyle.setRightBorderColor(colorValue);
                    cellStyle.setBottomBorderColor(colorValue);
                    cellStyle.setLeftBorderColor(colorValue);
                }
            }
        } else if (this.book.workbook instanceof HSSFWorkbook) {
            HSSFColor colorValue = (HSSFColor)color;
            HSSFCellStyle cellStyle = (HSSFCellStyle)this.style;
            short colorIndex = colorValue.getIndex();
            switch (side) {
                case 0: {
                    cellStyle.setTopBorderColor(colorIndex);
                    break;
                }
                case 1: {
                    cellStyle.setRightBorderColor(colorIndex);
                    break;
                }
                case 2: {
                    cellStyle.setBottomBorderColor(colorIndex);
                    break;
                }
                case 3: {
                    cellStyle.setLeftBorderColor(colorIndex);
                    break;
                }
                case 4: {
                    cellStyle.setTopBorderColor(colorIndex);
                    cellStyle.setRightBorderColor(colorIndex);
                    cellStyle.setBottomBorderColor(colorIndex);
                    cellStyle.setLeftBorderColor(colorIndex);
                }
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setBorderType(Object borderSide, Object borderType) {
        int side = this.parseBorderSide(borderSide);
        BorderStyle type = this.parseBorderType(borderType);
        switch (side) {
            case 0: {
                this.style.setBorderTop(type);
                break;
            }
            case 1: {
                this.style.setBorderRight(type);
                break;
            }
            case 2: {
                this.style.setBorderBottom(type);
                break;
            }
            case 3: {
                this.style.setBorderLeft(type);
                break;
            }
            case 4: {
                this.style.setBorderTop(type);
                this.style.setBorderRight(type);
                this.style.setBorderBottom(type);
                this.style.setBorderLeft(type);
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setBackgroundColor(Object value) {
        Color color = this.book.parseColor(value);
        if (this.book.workbook instanceof XSSFWorkbook) {
            XSSFColor colorValue = (XSSFColor)color;
            ((XSSFCellStyle)this.style).setFillBackgroundColor(colorValue);
        } else if (this.book.workbook instanceof HSSFWorkbook) {
            HSSFColor colorValue = (HSSFColor)color;
            this.style.setFillBackgroundColor(colorValue.getIndex());
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setForegroundColor(Object value) {
        Color color = this.book.parseColor(value);
        if (this.book.workbook instanceof XSSFWorkbook) {
            XSSFColor colorValue = (XSSFColor)color;
            ((XSSFCellStyle)this.style).setFillForegroundColor(colorValue);
        } else if (this.book.workbook instanceof HSSFWorkbook) {
            HSSFColor colorValue = (HSSFColor)color;
            this.style.setFillForegroundColor(colorValue.getIndex());
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setFillType(Object fillType) {
        int value = ((Number)fillType).intValue();
        this.style.setFillPattern(FillPatternType.forInt((int)value));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelCellStyle setFormat(Object format) {
        short df = this.book.workbook.createDataFormat().getFormat((String)format);
        this.style.setDataFormat(df);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public String getFormat() {
        return this.style.getDataFormatString();
    }

    private int parseBorderSide(Object value) {
        int v = ((Number)value).intValue();
        if (v < 0 || v > 4) {
            throw new InformException(String.format(MESSAGE_BADBORDERSIDE, value));
        }
        return v;
    }

    private BorderStyle parseBorderType(Object value) {
        int v = ((Number)value).intValue();
        if (v < 0 || v > 13) {
            throw new InformException(String.format(MESSAGE_BADBORDERSTYLE, value));
        }
        return BorderStyle.valueOf((short)((short)v));
    }
}

