/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.excel;

import inform.adt.InformException;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbook;
import inform.common.SmartScriptableObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFont
extends SmartScriptableObject {
    private static final String MESSAGE_MISSING_FONTUNDERLINE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0434\u0447\u0435\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f \u0448\u0440\u0438\u0444\u0442\u0430: '%s'";
    private final ExcelWorkbook book;
    Font font;

    ExcelFont(ExcelWorkbook book) {
        this.setParentScope(book);
        this.book = book;
        this.font = book.workbook.createFont();
    }

    ExcelFont(ExcelWorkbook book, ExcelFont excelFont) {
        this(book);
        if (excelFont != null) {
            this.font = this.cloneFontFrom(excelFont.font);
        }
    }

    ExcelFont(ExcelWorkbook book, Font excelFont) {
        this.setParentScope(book);
        this.book = book;
        this.font = excelFont != null ? excelFont : book.workbook.createFont();
    }

    @Override
    public String getClassName() {
        return "ExcelFont";
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setName(String name) {
        this.font.setFontName(name);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setSize(int size) {
        this.font.setFontHeightInPoints((short)size);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setColor(Object value) {
        Color color = this.book.parseColor(value);
        if (this.book.workbook instanceof XSSFWorkbook) {
            XSSFColor colorValue = (XSSFColor)color;
            ((XSSFFont)this.font).setColor(colorValue);
        } else if (this.book.workbook instanceof HSSFWorkbook) {
            HSSFColor colorValue = (HSSFColor)color;
            this.font.setColor(colorValue.getIndex());
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setBold(boolean value) {
        this.font.setBold(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setItalic(boolean value) {
        this.font.setItalic(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setStrikeout(boolean value) {
        this.font.setStrikeout(value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setVerticalOffset(int value) {
        this.font.setTypeOffset((short)value);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public ExcelFont setUnderline(int value) {
        try {
            this.font.setUnderline(FontUnderline.valueOf((int)value).getByteValue());
            return this;
        }
        catch (Exception e) {
            throw new InformException(String.format(MESSAGE_MISSING_FONTUNDERLINE, value));
        }
    }

    private Font cloneFontFrom(Font font) {
        Font newFont = this.book.workbook.createFont();
        if (font != null) {
            newFont.setFontName(font.getFontName());
            newFont.setBold(font.getBold());
            newFont.setColor(font.getColor());
            newFont.setFontHeight(font.getFontHeight());
            newFont.setItalic(font.getItalic());
            newFont.setStrikeout(font.getStrikeout());
            newFont.setTypeOffset(font.getTypeOffset());
            newFont.setUnderline(font.getUnderline());
        }
        return newFont;
    }
}

