/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.ods;

import inform.adt.InformException;
import inform.agent.scripts.spreadsheets.ods.OdsWorkbook;
import inform.common.SmartScriptableObject;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class OdsFont
extends SmartScriptableObject {
    private static final String MESSAGE_MISSING_FONTUNDERLINE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0434\u0447\u0435\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f \u0448\u0440\u0438\u0444\u0442\u0430: '%s'";
    private final Map<String, String> propertiesFont;

    OdsFont(OdsWorkbook book) {
        this.setParentScope(book);
        this.propertiesFont = new HashMap<String, String>();
    }

    OdsFont(OdsWorkbook book, OdsFont odsFont) {
        this(book);
        if (odsFont != null) {
            this.propertiesFont.putAll(odsFont.propertiesFont);
        }
    }

    OdsFont(OdsWorkbook book, Map<String, String> map) {
        this(book);
        this.propertiesFont.putAll(map);
    }

    @Override
    public String getClassName() {
        return "OdsFont";
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setName(String name) {
        this.propertiesFont.put("fo:font-family", name);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setSize(int size) {
        this.propertiesFont.put("fo:font-size", String.valueOf(size));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setColor(Object value) {
        org.odftoolkit.odfdom.type.Color color = OdsWorkbook.parseColor(value);
        Color awtColor = color.getAWTColor();
        String hex = String.format("#%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        this.propertiesFont.put("fo:color", hex);
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setBold(boolean value) {
        if (value) {
            this.propertiesFont.put("fo:font-weight", "bold");
        } else {
            this.propertiesFont.put("fo:font-weight", "normal");
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setItalic(boolean value) {
        if (value) {
            this.propertiesFont.put("fo:font-style", "italic");
        } else {
            this.propertiesFont.put("fo:font-style", "normal");
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setStrikeout(boolean value) {
        if (value) {
            this.propertiesFont.put("style:text-line-through-type", "single");
        } else {
            this.propertiesFont.put("style:text-line-through-type", "none");
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont setUnderline(int value) {
        try {
            switch (value) {
                case 1: {
                    this.propertiesFont.put("style:text-underline-style", "solid");
                    break;
                }
                default: {
                    this.propertiesFont.put("style:text-underline-style", "none");
                }
            }
            return this;
        }
        catch (Exception e) {
            throw new InformException(String.format(MESSAGE_MISSING_FONTUNDERLINE, value));
        }
    }

    public Map<String, String> getPropertiesFont() {
        return this.propertiesFont;
    }
}

