/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;

public class DatasourceUsage {
    private final IntegerHash<Usage> usage = new IntegerHash();
    private final Query query;

    public DatasourceUsage(Query query) {
        this.query = query;
    }

    public boolean contains(int id) {
        return this.usage.get(id) != null;
    }

    public boolean contains(int id, int fieldId) {
        Usage u = this.usage.get(id);
        if (u == null || u.fields == null) {
            return false;
        }
        return u.fields.contains(fieldId);
    }

    public Usage add(int id) {
        Usage u = this.usage.get(id);
        if (u == null) {
            int parentId;
            u = new Usage(id);
            this.usage.add(u);
            GenericQueryNode node = this.query.findNodeById(id);
            if (node != null && (parentId = node.getParentEntryId()) != 0 && parentId != id) {
                this.add(parentId);
            }
        }
        return u;
    }

    public void add(int id, int fieldId) {
        Usage u = this.add(id);
        if (u.fields == null) {
            u.fields = new IntegerSet();
        }
        u.fields.add(fieldId);
    }

    public IntegerSet getFieldsUsage(int id) {
        Usage u = this.usage.get(id);
        if (u == null) {
            return null;
        }
        return u.fields;
    }

    static class Usage
    implements IntegerHash.Entry {
        public final int id;
        public IntegerSet fields = null;

        public Usage(int id) {
            this.id = id;
        }

        @Override
        public int key() {
            return this.id;
        }
    }
}

