/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import java.io.IOException;

public class PeriodicBind {
    private static final int TAG_PERIODIC_ARG_FIELD = 1;
    private static final int TAG_PERIODIC_ARG_VALUE = 2;
    private static final int TAG_PERIODIC_ARG_PARAMETER = 3;
    public static final int KIND_DEFAULT = 0;
    public static final int KIND_BIND = 1;
    public static final int KIND_VALUE = 2;
    public static final int KIND_PARAMETER = 3;
    private int kind = 0;
    private int fieldId = 0;
    private double value = 0.0;

    public void load(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.value = reader.getDouble();
                    this.kind = 2;
                    break;
                }
                case 3: {
                    this.fieldId = reader.getInt();
                    this.kind = 3;
                }
            }
        }
    }

    double resolve(Query query, QueryNode node) throws InformException {
        switch (this.kind) {
            case 2: {
                break;
            }
            case 3: {
                Parameter param = query.getInputParameters().get(this.fieldId);
                if (param == null) {
                    node.throwNodeError(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440(id: %d) \u0434\u043b\u044f \u0442\u043e\u0447\u043a\u0438 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", this.fieldId));
                    break;
                }
                if (!param.getDataType().isNumeric() || param.getIsIgnored() || param.getIsNull()) {
                    node.throwNodeError(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440(id: %d) \u0434\u043b\u044f \u0442\u043e\u0447\u043a\u0438 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f", this.fieldId));
                }
                if (param.getDataType() == DataType.DATE_TIME) {
                    this.value = param.getAsDateValue();
                    break;
                }
                this.value = param.getAsNumber();
                break;
            }
            default: {
                Constant actualPoint = query.getConstants().get(-7);
                this.value = actualPoint == null || actualPoint.getIsIgnored() || actualPoint.getDataType() != DataType.DATE_TIME || actualPoint.getRawValue() == null ? DateTime.currentDateTime() : ValueCaster.toNumber(actualPoint.getRawValue()).doubleValue();
            }
        }
        return this.value;
    }

    public void setValue(double value) {
        this.kind = 2;
        this.value = value;
    }
}

