/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.SortField;
import inform.agent.db.SortFieldPath;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.ISqlBuilderState;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.db.sql.ValueSqlGenerator;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Constants;
import inform.agent.scripts.DataTypesLibrary;
import inform.agent.scripts.DateLibrary;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.StringsLibrary;
import inform.agent.scripts.sql.DatabaseTypesLibrary;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.QueryDescriptor;
import inform.agent.scripts.sql.QueryGeneratedSql;
import inform.agent.scripts.sql.QueryKind;
import inform.agent.scripts.sql.QueryMetadataPool;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeMetadata;
import inform.agent.scripts.sql.QueryOptimizerHint;
import inform.agent.scripts.sql.QueryParameterList;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.sql.RootQueryNode;
import inform.agent.scripts.sql.expr.Condition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class Query
extends ScriptableObject
implements ValueSqlGenerator {
    private static final String[] availJSFunctionsNames = new String[]{"toString"};
    private ServerSideHost ssHost;
    protected QueryKind kind = null;
    private Node nodeInfo = null;
    private IntegerHash<GenericQueryNode> nodeByEntryIdHash = new IntegerHash();
    protected HashMap<String, GenericQueryNode> nodeByNameHash = new HashMap();
    final RootQueryNode root;
    private String scriptText = null;
    private String sqlText = null;
    private final ParametersList inputParams;
    private Constants constants;
    private byte[] constansContent;
    private QueryMetadataPool metadataPool = new QueryMetadataPool();
    protected QueryParameterList sqlParameters = null;
    private LinkDescriptor relations = null;
    private QuerySortFieldList sortFields = null;
    private ISqlBuilderState builderState = null;
    private Query parentQuery = null;
    private String caption = null;
    private int entryId = -1;
    private String onInitialize;
    private String onGetData;
    private ResultKind resultKind = ResultKind.DEFAULT;
    private QueryNode proxyNode = null;
    private String procedureName = null;
    private boolean inlineParams = false;
    private StringBuilder debugBuilder = null;
    private int fetchLimit = -1;
    private boolean pagedFetch = false;
    private GeneratedSql.Sorting sortingGeneration = GeneratedSql.Sorting.DEFAULT;
    private int blobReceiving = 0;
    private int aliasGenerator = 0;
    private QueryOptimizerHint optimizerHint = null;
    public double overriderDatabaseID = 0.0;
    private ArrayList<ExtraField> extraFields = null;
    private ExpressionFilterQuery expressionFilter = null;
    private boolean hierarchical = false;
    private int nullSortKind;
    private static final int TAG_FS_SORTING_ENTRY_ID = 1;
    private static final int TAG_FS_SORTING_FIELD_ID = 2;
    private static final int TAG_FS_SORTING_ASCENDING = 3;

    public void setInlineParams(boolean inlineParams) {
        this.inlineParams = inlineParams;
    }

    public boolean isInlineParams() {
        return this.inlineParams;
    }

    public StringBuilder getDebugBuilder() {
        return this.debugBuilder;
    }

    public void setDebugBuilder(StringBuilder debugBuilder) {
        this.debugBuilder = debugBuilder;
    }

    public void processDebugBuilder() {
        if (this.parentQuery == null || this.debugBuilder == null) {
            return;
        }
        this.debugBuilder.append(": [id:").append(this.entryId).append(", f: ").append((long)this.parentQuery.getNodeId()).append(']');
        this.parentQuery.processDebugBuilder();
    }

    private DatabaseCaps getRootTableDBCaps() throws InformException {
        return this.getResultMetadata().tableDescriptor.getDatabaseDescriptor().getDatabaseType().caps();
    }

    private void initScript() {
        Query.putConstProperty(this, "parameters", this.inputParams);
        Query.putConstProperty(this, "module", this);
        this.defineFunctionProperties(availJSFunctionsNames, Query.class, 0);
    }

    public Query(ServerSideHost ssHost, int nullSortKind) {
        this.ssHost = ssHost;
        this.root = this.createRootNode();
        this.constants = new Constants(ssHost.getUserID());
        this.inputParams = new ParametersList();
        this.inputParams.setParentScope(this);
        this.nullSortKind = nullSortKind;
        this.initScript();
    }

    protected RootQueryNode createRootNode() {
        return new RootQueryNode(this);
    }

    private Query(ServerSideHost ssHost, QueryDescriptor descriptor) {
        this.parentQuery = descriptor.getParentQuery();
        this.ssHost = ssHost;
        this.root = this.createRootNode();
        this.root.returnedFields.setReturnedFields(descriptor.getReturnedFields());
        this.constants = descriptor.getConstants();
        this.constansContent = descriptor.getConstantsContent();
        this.caption = descriptor.getTitle();
        this.entryId = descriptor.getEntryId();
        this.setParentScope(descriptor.getParentScope());
        this.inputParams = new ParametersList();
        this.inputParams.setParentScope(this);
        this.sortFields = descriptor.getSortFields();
        this.nullSortKind = descriptor.getNullSortKind();
        if (this.parentQuery != null) {
            this.inlineParams = this.parentQuery.isInlineParams();
            this.debugBuilder = this.parentQuery.getDebugBuilder();
        }
        this.initScript();
    }

    public int getNullSortKind() {
        return this.nullSortKind;
    }

    public void setNullSortKind(int nullSortKind) {
        this.nullSortKind = nullSortKind;
    }

    public DatabaseCaps getDatabaseCaps() {
        return this.root.getDatabaseCaps();
    }

    public DatabaseType getDatabaseType() {
        return this.root.getDatabaseType();
    }

    public ServerSideHost getHost() {
        return this.ssHost;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public int nextAlias() {
        if (this.parentQuery != null) {
            return this.parentQuery.nextAlias();
        }
        return this.aliasGenerator++;
    }

    public QueryNode getProxyNode() {
        return this.proxyNode;
    }

    public RootQueryNode getRootNode() {
        return this.root;
    }

    public int getBlobReceiving() {
        return this.blobReceiving;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.blobReceiving = blobReceiving;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    public boolean isPagedFetch() {
        return this.pagedFetch;
    }

    public void setPagedFetch() {
        this.pagedFetch = this.fetchLimit > 0;
    }

    public QuerySortFieldList getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(QuerySortFieldList sortFields) {
        this.sortFields = sortFields;
    }

    public GenericQueryNode findNodeByName(String scriptName) {
        return this.nodeByNameHash.get(scriptName);
    }

    public GenericQueryNode findNodeById(int entryId) {
        return this.nodeByEntryIdHash.get(entryId);
    }

    public GenericQueryNode getNodeById(int entryId) throws InformException {
        GenericQueryNode node = this.findNodeById(entryId);
        if (node == null) {
            this.throwError(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a (entryId: %d) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", entryId));
        }
        return node;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getOnInitialize() {
        return this.onInitialize;
    }

    public String getOnGetData() {
        return this.onGetData;
    }

    public boolean hasOnGetData() {
        return !Strings.isVoid(this.onGetData);
    }

    public double getNodeId() {
        if (this.nodeInfo == null) {
            return 0.0;
        }
        return this.nodeInfo.getId();
    }

    public QueryKind getQueryKind() {
        return this.kind;
    }

    public ResultKind getResultKind() {
        return this.resultKind;
    }

    public GeneratedSql.Sorting getSortingGeneration() {
        return this.sortingGeneration;
    }

    public void setSortingGeneration(GeneratedSql.Sorting sortingGeneration) {
        this.sortingGeneration = sortingGeneration;
    }

    public ParametersList getInputParameters() {
        return this.inputParams;
    }

    public void setConstantsContent(byte[] content) throws IOException, TaggedReaderException {
        this.constansContent = content;
        this.constants.load(content, (TimeZoneHost)this.ssHost);
    }

    public byte[] getConstansContent() {
        return this.constansContent;
    }

    public Constants getConstants() {
        return this.constants;
    }

    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    public QueryNodeMetadata getResultMetadata() {
        return this.root.getMetadata();
    }

    public QueryNodeMetadata getTableMetadata(double tableNodeId) throws IOException, InformException {
        return this.metadataPool.getNodeMetadata(tableNodeId);
    }

    void registerNode(GenericQueryNode node) {
        switch (node.getKind()) {
            case ROOT: 
            case TABLE: 
            case QUERY: 
            case SEARCH: 
            case DIRECTORY: 
            case SUBJECT_SOURCE: {
                this.nodeByEntryIdHash.add(node);
                this.nodeByNameHash.put(node.getScriptName(), node);
                Query.putConstProperty(this, node.getScriptName(), node);
            }
        }
    }

    public QueryParameterList getSqlParameters() {
        return this.sqlParameters;
    }

    public void setTableRelations(LinkDescriptor relations) {
        this.relations = relations;
    }

    public boolean hasExtraFields() {
        return this.extraFields != null && !this.extraFields.isEmpty();
    }

    public Collection<ExtraField> getExtraFields() {
        return this.extraFields;
    }

    public void beginGenerate(ISqlBuilderState builderState) {
        this.sqlParameters = new QueryParameterList();
        this.builderState = builderState;
    }

    public void endGenerate() {
        this.builderState = null;
    }

    public void generateParameter(int paramId, StringBuilder sql) throws InformException {
        Parameter param = this.inputParams.get(paramId);
        if (param == null) {
            this.throwError(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 (id: %d) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", paramId));
        }
        this.generateParameter(param, false, sql);
    }

    private String generateParamSQLValue(Parameter param, int index, DatabaseCaps caps) throws InformException {
        switch (param.getDataType()) {
            case DIRECTORY: 
            case FLOAT: 
            case INTERVAL: 
            case METATREE_NODE: 
            case PRIMARY_KEY: {
                return caps.c_float2sql(param.getAsNumberByIndex(index));
            }
            case DATE_TIME: {
                return caps.c_dateTime2sql(param.getAsDateValueByIndex(index));
            }
            case BOOLEAN: {
                return caps.c_bool2sql(param.getAsBooleanByIndex(index));
            }
            case INTEGER: {
                return "" + param.getAsIntNumberByIndex(index);
            }
            case BIG_NUMBER: 
            case STRING: 
            case UNICODE: {
                return caps.c_string2sql(param.getAsStringByIndex(index));
            }
        }
        this.sqlParameters.addParam(param);
        return "?";
    }

    @Override
    public void generateParameter(Parameter param, boolean needInline, StringBuilder sql) throws InformException {
        if (this.inlineParams) {
            needInline = true;
        }
        if (param.getIsIgnored()) {
            if (needInline) {
                sql.append("null");
            } else {
                this.sqlParameters.addParam(param);
                sql.append('?');
            }
            return;
        }
        if (!needInline) {
            this.sqlParameters.addParam(param);
        }
        int valueCount = param.getValueCount();
        int comma = 32;
        DatabaseCaps caps = this.getRootTableDBCaps();
        for (int i = 0; i < valueCount; ++i) {
            sql.append((char)comma);
            sql.append(needInline ? this.generateParamSQLValue(param, i, caps) : Character.valueOf('?'));
            comma = 44;
        }
    }

    @Override
    public void generateBoolValueSql(boolean value, StringBuilder sql) {
        if (this.inlineParams) {
            sql.append(value ? "true" : "false");
        } else {
            this.sqlParameters.addBool(value);
            sql.append('?');
        }
    }

    @Override
    public void generateIntValueSql(int value, StringBuilder sql) {
        if (!this.inlineParams) {
            this.sqlParameters.addInt(value);
        }
        sql.append(this.inlineParams ? value : 63);
    }

    @Override
    public void generateDoubleValueSql(double value, StringBuilder sql) throws InformException {
        if (this.inlineParams) {
            DatabaseCaps caps = this.getRootTableDBCaps();
            sql.append(caps.c_number2sql(value));
        } else {
            this.sqlParameters.addDouble(value);
            sql.append('?');
        }
    }

    @Override
    public void generateInterval(double value, StringBuilder sql) {
        DatabaseCaps caps = this.getRootTableDBCaps();
        if (this.inlineParams) {
            sql.append("interval '").append(caps.c_number2sql((long)(value * 24.0 * 60.0 * 60.0))).append("' second");
        } else {
            SqlParameter p = caps.intervalParameter(sql, value);
            if (p.getType() == SqlDataType.STRING) {
                this.sqlParameters.addAnsiString(p.getString());
            } else {
                this.sqlParameters.addDouble(p.getDouble());
            }
        }
    }

    @Override
    public void generateDateValueSql(double value, StringBuilder sql) throws InformException {
        DatabaseCaps caps = this.getRootTableDBCaps();
        sql.append(caps.c_dateTime2sql(value));
    }

    @Override
    public void generateAnsiStringValueSql(String value, StringBuilder sql) throws InformException {
        if (this.inlineParams) {
            DatabaseCaps caps = this.getRootTableDBCaps();
            sql.append(caps.c_string2sql(value));
        } else {
            this.sqlParameters.addAnsiString(value);
            sql.append('?');
        }
    }

    @Override
    public void generateUTFStringValueSql(String value, StringBuilder sql) throws InformException {
        if (this.inlineParams) {
            DatabaseCaps caps = this.getRootTableDBCaps();
            sql.append(caps.c_string2sql(value));
        } else {
            this.sqlParameters.addUTFString(value);
            sql.append('?');
        }
    }

    void generateLinkExpression(QueryNode node, QueryNode parentDatasouce, LinkDescriptor link, StringBuilder sql) throws InformException {
        boolean generated = false;
        block13: for (LinkField field : link.getFields()) {
            if (field.getLinkType() == 0) continue;
            if (generated) {
                sql.append(" AND ");
            }
            switch (field.getLinkType()) {
                case 1: {
                    sql.append('(');
                    node.generateFieldAlias(sql, field.getFieldId(), false);
                    int vc = field.getValueCount();
                    sql.append(vc == 1 ? " = " : " IN (");
                    boolean has_null = false;
                    boolean has_gen = false;
                    block14: for (int i = 0; i < vc; ++i) {
                        Object v = field.getValueByIndex(i);
                        if (v == null) {
                            has_null = true;
                            continue;
                        }
                        if (has_gen) {
                            sql.append(',');
                        }
                        has_gen = true;
                        switch (field.getConstType()) {
                            case INTEGER: {
                                this.generateIntValueSql(((Number)v).intValue(), sql);
                                continue block14;
                            }
                            case FLOAT: {
                                this.generateDoubleValueSql(((Number)v).doubleValue(), sql);
                                continue block14;
                            }
                            case DATE_TIME: {
                                this.generateDateValueSql(((Number)v).doubleValue(), sql);
                                continue block14;
                            }
                            case STRING: {
                                this.generateAnsiStringValueSql((String)v, sql);
                                continue block14;
                            }
                            case UNICODE: {
                                this.generateUTFStringValueSql((String)v, sql);
                                continue block14;
                            }
                            default: {
                                node.throwNodeError("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b \u0434\u043b\u044f \u0441\u0432\u044f\u0437\u0438");
                            }
                        }
                    }
                    if (vc != 1) {
                        sql.append(')');
                    }
                    if (has_null) {
                        sql.append(" OR ");
                        node.generateFieldAlias(sql, field.getFieldId(), false);
                        sql.append(" IS NULL");
                    }
                    sql.append(')');
                    break;
                }
                case 2: {
                    assert (parentDatasouce != null);
                    node.generateFieldAlias(sql, field.getFieldId(), false);
                    sql.append(" = ");
                    parentDatasouce.generateFieldAlias(sql, field.getLinkField(), false);
                    break;
                }
                case 3: {
                    assert (parentDatasouce != null);
                    node.generateFieldAlias(sql, field.getFieldId(), false);
                    sql.append(" = ");
                    parentDatasouce.generateFieldAlias(sql, -1, false);
                    break;
                }
                case 4: {
                    sql.append(" IS NULL");
                    break;
                }
                default: {
                    continue block13;
                }
            }
            generated = true;
        }
    }

    public String getTableRelationsSql() throws InformException {
        if (this.relations == null) {
            return null;
        }
        StringBuilder relationStringBuilder = new StringBuilder();
        this.generateLinkExpression(this.root, null, this.relations, relationStringBuilder);
        String relationSql = relationStringBuilder.toString();
        if (relationSql.isEmpty()) {
            return null;
        }
        return relationSql;
    }

    public void generateTableRelations(StringBuilder sql) throws InformException {
        if (this.relations == null) {
            return;
        }
        StringBuilder relationStringBuilder = new StringBuilder();
        this.generateLinkExpression(this.root, null, this.relations, relationStringBuilder);
        String relationSql = relationStringBuilder.toString();
        if (relationSql.isEmpty()) {
            return;
        }
        sql.append('(');
        sql.append(relationSql);
        sql.append(')');
    }

    private void appendOrderByField(String field, boolean ascending, StringBuilder sql, DatabaseCaps caps) {
        String suffix = null;
        if (this.nullSortKind != 0) {
            if (caps.isNullSortSupport()) {
                int nsk = this.nullSortKind;
                if (!ascending) {
                    nsk = nsk == 1 ? 2 : 1;
                }
                switch (nsk) {
                    case 1: {
                        suffix = " NULLS FIRST ";
                        break;
                    }
                    case 2: {
                        suffix = " NULLS LAST ";
                    }
                }
            } else {
                switch (this.nullSortKind) {
                    case 1: {
                        sql.append("case when ").append(field).append(" is null then 0 else 1 end");
                        break;
                    }
                    case 2: {
                        sql.append("case when ").append(field).append(" is null then 1 else 0 end");
                    }
                }
                if (ascending) {
                    sql.append(" ASC ");
                } else {
                    sql.append(" DESC ");
                }
                sql.append(',');
            }
        }
        sql.append(field);
        if (ascending) {
            sql.append(" ASC ");
        } else {
            sql.append(" DESC ");
        }
        if (suffix != null) {
            sql.append(suffix);
        }
    }

    public void generateOrderBy(StringBuilder sql) throws InformException {
        if (this.sortFields == null) {
            return;
        }
        DatabaseCaps caps = this.getRootTableDBCaps();
        StringBuilder orderSql = new StringBuilder();
        if (this.sortFields.querySortFields.isEmpty()) {
            if (this.kind == QueryKind.ADVANCED) {
                this.sortingGeneration = GeneratedSql.Sorting.FAILED;
                return;
            }
            for (SortField sortField : this.sortFields.fields()) {
                if (sortField.size() == 1) continue;
                this.sortingGeneration = GeneratedSql.Sorting.FAILED;
                return;
            }
            boolean comma = false;
            for (SortField sortField : this.sortFields.fields()) {
                if (comma) {
                    orderSql.append(',');
                }
                StringBuilder orderField = new StringBuilder();
                this.root.generateFieldAlias(orderField, ((SortFieldPath)sortField.get((int)0)).fieldId, false);
                this.appendOrderByField(orderField.toString(), sortField.isAscending(), orderSql, caps);
                comma = true;
            }
        } else {
            int comma = 32;
            if (this.kind == QueryKind.SIMPLE) {
                for (QuerySortFieldList.QuerySortField field : this.sortFields.querySortFields) {
                    FieldDescriptor fieldDescriptor = field.node.getFieldById(field.fieldId);
                    orderSql.append((char)comma);
                    StringBuilder orderField = new StringBuilder();
                    if (fieldDescriptor != null && fieldDescriptor.isRightPadded()) {
                        StringBuilder alias = new StringBuilder();
                        field.node.generateFieldAlias(alias, field.fieldId, false);
                        caps.lpad(orderField, alias.toString(), fieldDescriptor.getSize());
                    } else {
                        field.node.generateFieldAlias(orderField, field.fieldId, false);
                    }
                    this.appendOrderByField(orderField.toString(), field.ascending, orderSql, caps);
                    comma = 44;
                }
            } else {
                for (QuerySortFieldList.QuerySortField field : this.sortFields.querySortFields) {
                    FieldDescriptor fieldDescriptor = field.node.getFieldById(field.fieldId);
                    if (fieldDescriptor != null && fieldDescriptor.isRightPadded() && field.fieldSql != null) {
                        StringBuilder orderField = new StringBuilder();
                        caps.lpad(orderField, field.fieldSql, fieldDescriptor.getSize());
                        orderSql.append((char)comma);
                        this.appendOrderByField(orderField.toString(), field.ascending, orderSql, caps);
                    } else if (this.nullSortKind != 0) {
                        if (field.fieldSql == null) continue;
                        this.appendOrderByField(field.fieldSql, field.ascending, orderSql, caps);
                    } else {
                        if (field.fieldPosition < 0) {
                            this.sortingGeneration = GeneratedSql.Sorting.FAILED;
                            return;
                        }
                        orderSql.append((char)comma).append(field.fieldPosition);
                        if (field.ascending) {
                            orderSql.append(" ASC");
                        } else {
                            orderSql.append(" DESC");
                        }
                    }
                    comma = 44;
                }
            }
        }
        if (orderSql.length() != 0) {
            sql.append(" ORDER BY ").append((CharSequence)orderSql);
            this.sortingGeneration = GeneratedSql.Sorting.GENERATED;
        }
    }

    public void loadFromMetadata(double nodeId, Node nodeInfo) throws InformException, IOException {
        this.nodeInfo = nodeInfo == null ? MtdEngine.getNode(nodeId) : nodeInfo;
        if (nodeInfo == null) {
            this.throwError(String.format("\u0423\u0437\u0435\u043b \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u0443\u0437\u0435\u043b: %s)", NumberConverter.doubleToString(nodeId)));
        } else if (nodeInfo.getType() != 49) {
            this.throwError(String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 (\u0443\u0437\u0435\u043b: %s, \u0442\u0438\u043f: %d)", NumberConverter.doubleToString(nodeId), nodeInfo.getType()));
        }
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(nodeId)));
        this.load(reader);
    }

    public void loadFromStream(double nodeId, Node nodeInfo, TaggedReader reader) throws IOException, InformException {
        this.nodeInfo = nodeInfo == null ? MtdEngine.getNode(nodeId) : nodeInfo;
        if (nodeInfo == null) {
            this.throwError(String.format("\u0423\u0437\u0435\u043b \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u0443\u0437\u0435\u043b: %s)", NumberConverter.doubleToString(nodeId)));
        } else if (nodeInfo.getType() != 49) {
            this.throwError(String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 (\u0443\u0437\u0435\u043b: %s, \u0442\u0438\u043f: %d)", NumberConverter.doubleToString(nodeId), nodeInfo.getType()));
        }
        this.load(reader);
    }

    private void loadSorting(TaggedReader in) throws IOException {
        this.sortFields = new QuerySortFieldList();
        int entryId = 0;
        int fieldId = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    entryId = in.getInt();
                    break;
                }
                case 2: {
                    fieldId = in.getInt();
                    break;
                }
                case 3: {
                    int ascending = in.getInt();
                    QuerySortFieldList.QuerySortField sortField = new QuerySortFieldList.QuerySortField();
                    GenericQueryNode node = this.findNodeById(entryId);
                    if (node == null || !(node instanceof QueryNode)) break;
                    sortField.ascending = ascending != 0;
                    sortField.fieldId = fieldId;
                    sortField.node = (QueryNode)node;
                    this.sortFields.querySortFields.add(sortField);
                }
            }
        }
    }

    public void load(TaggedReader in) throws IOException, InformException {
        this.hierarchical = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 2: {
                    in.skip();
                    this.root.load(new TaggedReader(in.getSubStream()));
                    this.registerNode(this.root);
                    break;
                }
                case 15: {
                    int kindId = in.getInt();
                    this.kind = QueryKind.fromInt(kindId);
                    if (this.relations == null || this.kind != QueryKind.SQL) break;
                    this.throwError("\u0421\u0432\u044f\u0437\u044c \u0438 \u0441\u0432\u044f\u0437\u044c \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0441 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u043c \u0432 \u0432\u0438\u0434\u0435 SQL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
                    break;
                }
                case 20: {
                    this.scriptText = in.getAnsi();
                    break;
                }
                case 22: {
                    this.sqlText = in.getAnsi();
                    break;
                }
                case 24: {
                    this.onInitialize = in.getAnsi();
                    break;
                }
                case 25: {
                    this.resultKind = ResultKind.valueById(in.getInt());
                    break;
                }
                case 26: {
                    this.procedureName = in.getAnsi();
                    break;
                }
                case 28: {
                    this.fetchLimit = in.getInt();
                    break;
                }
                case 29: {
                    in.skip();
                    this.loadSorting(in.getSubStreamReader());
                    break;
                }
                case 36: {
                    if (this.optimizerHint == null) {
                        this.optimizerHint = new QueryOptimizerHint();
                    }
                    this.optimizerHint.load(in);
                    break;
                }
                case 31: {
                    this.overriderDatabaseID = in.getNodeID();
                    break;
                }
                case 32: {
                    if (this.extraFields == null) {
                        this.extraFields = new ArrayList();
                    }
                    this.extraFields.add(new ExtraField(in.getSubStreamReader()));
                    break;
                }
                case 33: {
                    this.onGetData = in.getAnsi();
                    break;
                }
                case 35: {
                    this.hierarchical = true;
                    break;
                }
                case 153: {
                    in.skip();
                    this.inputParams.load(this.constants, new TaggedReader(in.getSubStream()), this.ssHost);
                }
            }
        }
        if (this.kind == QueryKind.PROCEDURE) {
            this.defineProperty("procedureName", this.getClass(), 0);
        }
    }

    public QueryOptimizerHint.OptimizerHint getOptimizerHint() {
        if (this.optimizerHint == null) {
            return null;
        }
        return this.optimizerHint.getOptimizer(DatabaseType.getMetabaseType());
    }

    public void addSortField(TaggedReader reader) throws IOException, TaggedReaderException {
        if (this.sortFields == null) {
            this.sortFields = new QuerySortFieldList();
        } else if (!this.sortFields.querySortFields.isEmpty()) {
            return;
        }
        this.sortFields.addFromStream(19, reader);
    }

    @Override
    public String getClassName() {
        return "Query";
    }

    public String toString() {
        return this.getClassName() + "(" + NumberConverter.doubleToString(this.getNodeId()) + ")";
    }

    public String toLogString() {
        StringBuilder log = new StringBuilder();
        log.append("\u0417\u0430\u043f\u0440\u043e\u0441 '").append(this.nodeInfo.getName());
        log.append("'(\u0443\u0437\u0435\u043b: ").append(NumberConverter.doubleToString(this.nodeInfo.getId()));
        log.append(")");
        return log.toString();
    }

    private void writeDetailing(StringBuilder detailing) {
        if (this.parentQuery != null) {
            this.parentQuery.writeDetailing(detailing);
            detailing.append("\u0417\u0430\u043f\u0440\u043e\u0441 '").append(this.caption);
            detailing.append("'(entryId: ").append(this.entryId);
            detailing.append(" ,\u0443\u0437\u0435\u043b: ").append(NumberConverter.doubleToString(this.nodeInfo.getId()));
            detailing.append(")\n");
        } else if (this.nodeInfo != null) {
            detailing.append("\u0417\u0430\u043f\u0440\u043e\u0441 '").append(this.nodeInfo.getName());
            detailing.append("'(\u0443\u0437\u0435\u043b: ").append(NumberConverter.doubleToString(this.nodeInfo.getId()));
            detailing.append(")\n");
        }
        if (this.builderState != null) {
            detailing.append("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f SQL\n");
            detailing.append(this.builderState.getCurrentState()).append(":\n");
        }
    }

    public void throwError(Throwable cause) {
        StringBuilder detailing = new StringBuilder();
        this.writeDetailing(detailing);
        throw InformException.detail(cause, detailing.toString());
    }

    public void throwError(String message) {
        StringBuilder detailing = new StringBuilder();
        this.writeDetailing(detailing);
        throw new InformException(message).detail(detailing.toString());
    }

    public void throwError(String message, String adetailing) {
        StringBuilder detailing = new StringBuilder();
        this.writeDetailing(detailing);
        detailing.append('\n').append(adetailing);
        throw new InformException(message).detail(detailing.toString());
    }

    public void throwDetailingError(String message, StringBuilder detailing) {
        this.writeDetailing(detailing);
        throw new InformException(message).detail(detailing.toString());
    }

    public Node getNodeInfo() {
        return this.nodeInfo;
    }

    protected boolean prepareScript(Context context) throws IOException, InformException {
        boolean hasJavaScriptCalls;
        boolean bl = hasJavaScriptCalls = !Strings.isVoid(this.scriptText);
        if (hasJavaScriptCalls) {
            ScriptableObject.putConstProperty(this.getParentScope(), "Dates", new DateLibrary(this.getParentScope()));
            ScriptableObject.putConstProperty(this.getParentScope(), "Strings", new StringsLibrary(this.getParentScope()));
            ScriptableObject.putConstProperty(this.getParentScope(), "DataTypes", new DataTypesLibrary(this.getParentScope(), this.ssHost));
            ScriptableObject.putConstProperty(this.getParentScope(), "database", new DatabaseTypesLibrary(this.getParentScope(), this.getDatabaseType()));
            return true;
        }
        return false;
    }

    protected Object callOnInitialize(Context context) {
        if (Strings.isVoid(this.onInitialize)) {
            if (this.kind == QueryKind.PROXY) {
                this.throwError("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a onInitialize \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            }
            return null;
        }
        if (this.kind == QueryKind.SIMPLE && this.root.getWhere() != null) {
            Query.putConstProperty(this, "condition", this.root.getWhere());
        }
        context.evaluateString(this, this.getScriptText(), this.nodeInfo.toLogString(), 1, null);
        Object rootObject = ScriptableObject.callMethod(context, this, this.onInitialize, null);
        if (this.kind == QueryKind.PROXY) {
            if (rootObject == null || !(rootObject instanceof QueryNode)) {
                this.throwError("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a onInitialize \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0438\u043b \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a");
            } else {
                this.proxyNode = (QueryNode)rootObject;
                if (this.proxyNode.tableNodeId != this.root.tableNodeId) {
                    this.throwError("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a onInitialize \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0438\u043b \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0449\u0438\u0439 \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c");
                }
            }
        }
        return rootObject;
    }

    public String generateSqlText(Context context, SqlBuilder.GenerateParams generateParams) throws Exception {
        this.sortingGeneration = this.sortFields == null || this.sortFields.isEmpty() ? GeneratedSql.Sorting.DEFAULT : GeneratedSql.Sorting.FAILED;
        if (this.prepareScript(context)) {
            this.callOnInitialize(context);
        }
        SqlBuilder sqlBuilder = this.getQueryKind().createSqlBuilder(this);
        return sqlBuilder.generate(generateParams);
    }

    static QueryGeneratedSql generateSqlText(Context context, double nodeId, ServerSideHost ssHost, QueryDescriptor descriptor, SqlBuilder.GenerateParams generateParams) throws Exception {
        Node nodeInfo = MtdEngine.getValidNode(nodeId);
        Query query = new Query(ssHost, descriptor);
        query.setBlobReceiving(descriptor.getBlobReceiving());
        query.loadFromMetadata(nodeId, nodeInfo);
        if (descriptor.getParameters() != null) {
            for (Parameter p : descriptor.getParameters().values()) {
                Parameter queryParam = query.inputParams.get(p.getId());
                if (queryParam == null) continue;
                if (p.getParamBinding() != 0) {
                    Parameter rootParam = query.inputParams.get(p.getParamBinding());
                    if (rootParam == null) continue;
                    queryParam.applyParamBinding(rootParam);
                    continue;
                }
                queryParam.applyParamBinding(p);
            }
        }
        if (descriptor.getDataRelations() != null) {
            LinkDescriptor relations = new LinkDescriptor();
            relations.loadRelations(new TaggedReader(descriptor.getDataRelations()));
            query.setTableRelations(relations);
        }
        if (descriptor.getParentQuery() != null) {
            query.setInlineParams(descriptor.getParentQuery().inlineParams);
        }
        if (descriptor.getSortFields() != null) {
            query.setSortFields(descriptor.getSortFields());
        }
        query.setFetchLimit(descriptor.getFetchLimit());
        return new QueryGeneratedSql(query, query.generateSqlText(context, generateParams), query.sqlParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryGeneratedSql generateSqlText(double nodeId, ServerSideHost ssHost, QueryDescriptor descriptor, SqlBuilder.GenerateParams generateParams) throws Exception {
        Context context = Core.asmoJsContextFactory.enterContext();
        try {
            descriptor.setParentScope(context.initStandardObjects());
            QueryGeneratedSql queryGeneratedSql = Query.generateSqlText(context, nodeId, ssHost, descriptor, generateParams);
            return queryGeneratedSql;
        }
        finally {
            try {
                Context.exit();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
    }

    public void createParameterizedTable(double nodeId) throws IOException {
        this.nodeInfo = MtdEngine.getNode(nodeId);
        this.kind = QueryKind.SIMPLE;
        this.resultKind = ResultKind.DEFAULT;
        this.root.setParameterizedTable(nodeId);
        this.registerNode(this.root);
        FieldDescriptor pkFieldDescriptor = this.root.getMetadata().getRecordIdField();
        if (pkFieldDescriptor != null) {
            this.inputParams.createParameter(-1, pkFieldDescriptor.getType());
        }
        block3: for (FieldDescriptor field : this.root.getMetadata().getFields()) {
            if (field.isAbstract()) continue;
            switch (field.getType()) {
                case VARIANT: 
                case BLOB: 
                case FILE: 
                case GEOMETRY: {
                    continue block3;
                }
            }
            this.inputParams.createParameterByField(field);
        }
        this.root.createParameterizedTable();
    }

    public Condition createParameterizedTableCondition(double nodeId) throws IOException {
        this.nodeInfo = MtdEngine.getNode(nodeId);
        this.kind = QueryKind.SIMPLE;
        this.resultKind = ResultKind.DEFAULT;
        this.root.setParameterizedTable(nodeId);
        this.registerNode(this.root);
        return this.root.createParameterizedTableCondition();
    }

    public ExpressionFilterQuery getExpressionFilter() {
        return this.expressionFilter;
    }

    public void setExpressionFilter(ExpressionFilterQuery expressionFilter) {
        this.expressionFilter = expressionFilter;
    }

    public static enum ResultKind {
        DEFAULT(0),
        EDITABLE(1),
        VIRTUAL(2);

        private int kind;

        private ResultKind(int kind) {
            this.kind = kind;
        }

        public int value() {
            return this.kind;
        }

        public static ResultKind valueById(int kind) {
            for (ResultKind k : ResultKind.values()) {
                if (k.kind != kind) continue;
                return k;
            }
            return DEFAULT;
        }
    }
}

