/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.TimeZoneHost;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.ServerSideHost;
import inform.agent.scripts.Constants;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.sql.ReturnedFields;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class QueryDescriptor {
    private ScriptableObject parentScope = null;
    private Query parentQuery;
    private Constants constants;
    private byte[] constantsContent;
    private String title;
    private int entryId;
    private ParametersList parameters;
    private TaggedReader bindedParameters = null;
    private QuerySortFieldList sortFields = null;
    private int blobReceiving = 0;
    private ReturnedFields returnedFields = null;
    private byte[] dataRelations = null;
    private final int nullSortKind;
    private int fetchLimit = -1;

    public QueryDescriptor(Query parentQuery, ReturnedFields returnedFields, ParametersList parameters, String caption, int entryId, int nullSortKind) {
        assert (parentQuery != null);
        this.parentQuery = parentQuery;
        this.constants = parentQuery.getConstants();
        this.constantsContent = parentQuery.getConstansContent();
        this.title = caption;
        this.entryId = entryId;
        this.parameters = parameters;
        this.sortFields = null;
        this.returnedFields = returnedFields;
        this.nullSortKind = nullSortKind;
    }

    public QueryDescriptor(ParametersList parameters, ServerSideHost ssHost, byte[] constantsContent, String caption, int entryId, QuerySortFieldList sorting, int nullSortKind) throws IOException, TaggedReaderException {
        this.parentQuery = null;
        this.constants = new Constants(ssHost.getUserID());
        this.constantsContent = constantsContent;
        if (constantsContent != null) {
            this.constants.load(constantsContent, (TimeZoneHost)ssHost);
        }
        this.title = caption;
        this.entryId = entryId;
        this.parameters = parameters;
        this.sortFields = sorting;
        this.nullSortKind = nullSortKind;
    }

    public int getNullSortKind() {
        return this.nullSortKind;
    }

    public int getBlobReceiving() {
        return this.blobReceiving;
    }

    public void setBlobReceiving(int blobReceiving) {
        this.blobReceiving = blobReceiving;
    }

    public Constants getConstants() {
        return this.constants;
    }

    public int getEntryId() {
        return this.entryId;
    }

    public ParametersList getParameters() {
        return this.parameters;
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public ScriptableObject getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(ScriptableObject parentScope) {
        this.parentScope = parentScope;
    }

    public String getTitle() {
        return this.title;
    }

    public TaggedReader getBindedParameters() {
        return this.bindedParameters;
    }

    public void setBindedParameters(TaggedReader bindedParameters) {
        this.bindedParameters = bindedParameters;
    }

    public byte[] getConstantsContent() {
        return this.constantsContent;
    }

    public QuerySortFieldList getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(QuerySortFieldList sortFields) {
        this.sortFields = sortFields;
    }

    public ReturnedFields getReturnedFields() {
        return this.returnedFields;
    }

    public void setReturnedFields(ReturnedFields fields) {
        this.returnedFields = fields;
    }

    public void setReturnedFields(IntegerSet fields) {
        this.returnedFields = fields != null && !fields.empty() ? new ReturnedFields(fields) : null;
    }

    public byte[] getDataRelations() {
        return this.dataRelations;
    }

    public void setDataRelations(byte[] dataRelations) {
        this.dataRelations = dataRelations;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }
}

