/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.SqlGenerator;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.db.sql.TableSqlGenerator;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.DirectoryQueryNode;
import inform.agent.scripts.sql.FieldBind;
import inform.agent.scripts.sql.FieldBindList;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.JoinType;
import inform.agent.scripts.sql.PeriodicBind;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryField;
import inform.agent.scripts.sql.QueryNodeKind;
import inform.agent.scripts.sql.QueryNodeMetadata;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.sql.QuerySubjectsNode;
import inform.agent.scripts.sql.ReturnedFields;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class QueryNode
extends GenericQueryNode {
    double tableNodeId = 0.0;
    private int dataLink = 0;
    protected int directoryLink = 0;
    protected JoinType joinType = JoinType.INNER;
    private FieldBindList fieldBinds;
    private PeriodicBind periodicBind;
    private final IntegerHash<QueryField> fields = new IntegerHash();
    private final HashMap<String, QueryField> fieldMap = new HashMap();
    protected final ReturnedFields returnedFields = new ReturnedFields();
    private boolean excludable = true;
    private boolean ignored = false;
    private final IntegerSet referencedTo = new IntegerSet();
    protected boolean debugBuilderProcessed = false;
    public boolean generated = false;
    public boolean isProxyNode = false;
    protected QueryNodeMetadata metadata = null;

    QueryNode(Query query, GenericQueryNode parentNode) {
        super(query, parentNode);
    }

    QueryNode(Query query, GenericQueryNode parentNode, double tableId) throws IOException {
        super(query, parentNode);
        this.tableNodeId = tableId;
        this.initMetadata();
    }

    public double getTableId() {
        return this.tableNodeId;
    }

    public void setReturnedFields(ReturnedFields fields) {
        this.returnedFields.setReturnedFields(fields);
    }

    public void updateDatasourceUsage(DatasourceUsage usage) throws IOException {
        if (this.fieldBinds != null) {
            LinkDescriptor link;
            QueryNode parentDatasouce;
            for (FieldBind bind : this.fieldBinds) {
                if (bind.type != FieldBind.BindType.FIELD) continue;
                usage.add(this.getEntryId(), bind.getFieldId());
                usage.add(bind.getBindedDatasource(), bind.getBindedField());
            }
            if (this.dataLink != 0 && (parentDatasouce = this.getParentDatasource()) != null && (link = parentDatasouce.getDataLink(this, this.dataLink)) != null) {
                for (LinkField field : link.getFields()) {
                    if (field.getLinkType() == 0) continue;
                    usage.add(this.getEntryId(), field.getFieldId());
                    switch (field.getLinkType()) {
                        case 2: {
                            usage.add(parentDatasouce.getEntryId(), field.getLinkField());
                            break;
                        }
                        case 3: {
                            usage.add(parentDatasouce.getEntryId(), -1);
                        }
                    }
                }
            }
        }
    }

    public DirectoryQueryNode createDirectory(double tableId, int directoryFieldId) throws IOException {
        for (GenericQueryNode node : this.children) {
            DirectoryQueryNode directory;
            if (node.getKind() != QueryNodeKind.DIRECTORY || (directory = (DirectoryQueryNode)node).getTableId() != tableId || directory.getDirectoryFieldId() != directoryFieldId) continue;
            return directory;
        }
        DirectoryQueryNode directory = new DirectoryQueryNode(this.query, this, tableId, directoryFieldId);
        directory.generateEntryID();
        this.children.add(directory);
        this.query.registerNode(directory);
        return directory;
    }

    public boolean canExclude(DatasourceUsage usage) {
        if (!this.excludable) {
            return false;
        }
        if (usage.contains(this.getEntryId())) {
            return false;
        }
        for (GenericQueryNode child : this.children) {
            if (!(child instanceof QueryNode)) continue;
            QueryNode node = (QueryNode)child;
            if (node.dataLink == 0 && node.fieldBinds == null || node.canExclude(usage)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void enumFromTablesThis(ArrayList<QueryNode> joins, ArrayList<QueryNode> nonjoins) {
        this.generated = false;
        if (this.dataLink != 0 || this.directoryLink != 0 || this.fieldBinds != null) {
            joins.add(this);
        } else {
            nonjoins.add(this);
        }
    }

    public QueryNode getParentDatasource() {
        GenericQueryNode node = this.parent;
        while (node != null) {
            switch (node.getKind()) {
                case TABLE: 
                case DIRECTORY: 
                case QUERY: 
                case SEARCH: 
                case ROOT: {
                    return (QueryNode)node;
                }
            }
            node = node.parent;
        }
        return null;
    }

    public boolean isSubject() {
        return this.parent instanceof QuerySubjectsNode;
    }

    @Override
    public QueryNodeKind getKind() {
        if (this.tableNodeId == 0.0) {
            return QueryNodeKind.ERROR;
        }
        return QueryNodeKind.TABLE;
    }

    public QueryNodeMetadata getMetadata() {
        return this.metadata;
    }

    public DatabaseCaps getDatabaseCaps() {
        return this.metadata.getMetadataCaps();
    }

    public boolean isDirectoryLink() {
        return this.directoryLink != 0;
    }

    public boolean isDistinctTableRelations() throws IOException {
        if (this.isIgnored()) {
            return false;
        }
        if (this.isDirectoryLink()) {
            return false;
        }
        if (this.dataLink == 0 && this.fieldBinds == null) {
            return true;
        }
        boolean hasLink = false;
        if (this.dataLink != 0) {
            QueryNode parentDatasouce = this.getParentDatasource();
            assert (parentDatasouce != null);
            LinkDescriptor link = parentDatasouce.getDataLink(this, this.dataLink);
            if (link != null) {
                block3: for (LinkField field : link.getFields()) {
                    switch (field.getLinkType()) {
                        case 0: 
                        case 3: {
                            hasLink = true;
                            continue block3;
                        }
                    }
                    return true;
                }
            }
        }
        if (this.fieldBinds != null) {
            for (FieldBind bind : this.fieldBinds) {
                FieldDescriptor field = this.getFieldById(bind.getFieldId());
                if (field == null) {
                    return true;
                }
                if (!field.isPrimaryKey()) {
                    return true;
                }
                if (bind.type == FieldBind.BindType.PARAM) {
                    Parameter param = this.query.getInputParameters().get(bind.getBindedParam());
                    if (param == null) {
                        return true;
                    }
                    if (!param.getIsIgnored() && param.getValueCount() > 1) {
                        return true;
                    }
                }
                hasLink = true;
            }
        }
        return !hasLink;
    }

    @Override
    public void generateAlias(StringBuilder sql, boolean rootExpr) throws InformException {
        if (rootExpr) {
            this.throwNodeError("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0432 \u043f\u043e\u0441\u0442-\u0443\u0441\u043b\u043e\u0432\u0438\u0438");
        }
        this.internalGenerateAlias(sql);
    }

    @Override
    public void internalGenerateAlias(StringBuilder sql) {
        StringBuilder debugBuilder = this.debugBuilderProcessed ? null : this.query.getDebugBuilder();
        this.debugBuilderProcessed = true;
        switch (this.query.getQueryKind()) {
            case SIMPLE: 
            case ADVANCED: {
                sql.append("Q").append(this.aliasNo);
                if (debugBuilder == null) break;
                debugBuilder.append("\r\n").append('Q').append(this.aliasNo).append(": [id:").append(this.getEntryId()).append(", f: ").append((long)this.getQuery().getNodeId()).append(']');
                this.query.processDebugBuilder();
                break;
            }
            default: {
                sql.append(this.scriptName);
                if (debugBuilder == null) break;
                debugBuilder.append("\r\n").append(this.scriptName).append(": [").append(this.getEntryId()).append((long)this.getQuery().getNodeId()).append(']');
                this.query.processDebugBuilder();
            }
        }
    }

    @Override
    public void generateChildAlias(StringBuilder sql, String itemName) throws InformException {
        this.generateAlias(sql, false);
        sql.append('.');
        if ("*".equals(itemName)) {
            sql.append(itemName);
            return;
        }
        FieldDescriptor field = this.getFieldByName(itemName);
        if (field == null) {
            this.throwNodeError("\u041f\u043e\u043b\u0435 '" + itemName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
        } else {
            sql.append(field.getRawName());
        }
    }

    @Override
    public void generateFieldAlias(StringBuilder sql, int fieldId, boolean rootExpr) throws InformException {
        FieldDescriptor field = this.getFieldById(fieldId);
        if (field == null) {
            this.throwNodeError(String.format("\u041f\u043e\u043b\u0435(id: %d) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", fieldId));
        } else {
            if (!rootExpr) {
                this.generateAlias(sql, rootExpr);
                sql.append('.');
            }
            sql.append(field.getRawName());
        }
    }

    public void generateSelect(StringBuilder sql, SqlBuilder.GenerateParams generateParams) throws Exception {
        GeneratedSql generatedSql;
        SqlGenerator sqlGen = new SqlGenerator(this.query.getHost(), Core.serverTimeZoneHost);
        sqlGen.setTableId(this.tableNodeId);
        sqlGen.setConstantsContent(this.query.getConstansContent(), this.query.getHost());
        QuerySortFieldList sortFields = this.query.getSortFields();
        if (sortFields != null && !sortFields.isEmpty()) {
            sqlGen.getSortFields().addAll(sortFields.fields());
        }
        if (this.isProxyNode && sortFields != null) {
            sqlGen.getSortFields().addAll(sortFields.fields());
        }
        if (generateParams != null) {
            sqlGen.setCustomSubjectFieldId(generateParams.subjectFieldId);
        }
        if (this.periodicBind != null) {
            sqlGen.setActualPoint(this.periodicBind.resolve(this.query, this));
        }
        if ((generatedSql = sqlGen.getGeneratedSql(SqlGenerator.Method.DEFAULT, -500)).isHasError()) {
            this.query.throwError(generatedSql.getError(), generatedSql.getErrorDetailing());
        }
        sql.append(generatedSql.getSqlText());
        this.query.getSqlParameters().addFromStream(generatedSql.getParamersReader());
    }

    @Override
    public void generateRaw(StringBuilder sql, IntegerSet fieldsUsage, SqlBuilder.GenerateParams generateParams) throws Exception {
        if (this.metadata.hasPeriodicStorage() && generateParams == null) {
            if (this.periodicBind == null) {
                this.periodicBind = new PeriodicBind();
            }
            sql.append('(');
            TableSqlGenerator.generatePeriodicFromSql(this.metadata.tableDescriptor, this.periodicBind.resolve(this.query, this), this.returnedFields, fieldsUsage, this.query, sql);
            sql.append(')');
        } else if (this.metadata.hasPeriodicStorage() || generateParams != null) {
            GeneratedSql generatedSql;
            SqlGenerator sqlGen = new SqlGenerator(this.query.getHost(), Core.serverTimeZoneHost);
            for (Cursor.Integer returnedField : this.returnedFields) {
                sqlGen.addUsedField(returnedField.value);
            }
            sqlGen.setTableId(this.tableNodeId);
            sqlGen.setConstantsContent(this.query.getConstansContent(), this.query.getHost());
            if (generateParams != null) {
                sqlGen.setCustomSubjectFieldId(generateParams.subjectFieldId);
            }
            if (this.periodicBind != null) {
                sqlGen.setActualPoint(this.periodicBind.resolve(this.query, this));
            }
            if ((generatedSql = sqlGen.getGeneratedSql(SqlGenerator.Method.DEFAULT, -500)).isHasError()) {
                this.query.throwError(generatedSql.getError(), generatedSql.getErrorDetailing());
            }
            String sqlText = generatedSql.getSqlText();
            sql.append('(').append(sqlText).append(')');
            this.query.getSqlParameters().addFromStream(generatedSql.getParamersReader());
        } else {
            Node node = MtdEngine.getValidNode(this.metadata.getDatabaseId());
            if (!(node instanceof DatabaseNode)) {
                MtdEngine.throwDetailError("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", this.metadata.getDatabaseId());
                return;
            }
            DatabaseNode databaseNode = (DatabaseNode)node;
            DatabaseDescriptor db = databaseNode.getDescriptor();
            sql.append(db.getTableRawName(this.metadata.getRawName()));
        }
    }

    protected void generateDirectoryLinkSqlExpression(StringBuilder sql) throws IOException, InformException {
        assert (this.directoryLink != 0);
        QueryNode parentDatasouce = this.getParentDatasource();
        assert (parentDatasouce != null);
        FieldDescriptor linkField = parentDatasouce.getFieldById(this.directoryLink);
        if (linkField == null) {
            this.query.throwError(String.format("\u041f\u043e\u043b\u0435 \u0441\u0432\u044f\u0437\u044c(entryId: %d, fieldId: %d) \u0434\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430(entryID: %d) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", parentDatasouce.getEntryId(), this.directoryLink, this.getEntryId()));
        } else if (!linkField.getType().isNumberPresentation()) {
            this.query.throwError(String.format("\u041f\u043e\u043b\u0435 \u0441\u0432\u044f\u0437\u044c(entryId: %d, fieldId: %d) \u0434\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430(entryID: %d) \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u0432\u044b\u043c", parentDatasouce.getEntryId(), this.directoryLink, this.getEntryId()));
        } else if (linkField.getReferenceId() != this.getTableId()) {
            this.query.throwError(String.format("\u041f\u043e\u043b\u0435 \u0441\u0432\u044f\u0437\u044c(entryId: %d, fieldId: %d) \u0434\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430(entryID: %d) \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u0434\u0440\u0443\u0433\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443", parentDatasouce.getEntryId(), this.directoryLink, this.getEntryId()));
        }
        this.generateFieldAlias(sql, -1, false);
        sql.append('=');
        parentDatasouce.generateFieldAlias(sql, this.directoryLink, false);
    }

    protected void generateDataLinkSqlExpression(StringBuilder sql) throws IOException, InformException {
        assert (this.dataLink != 0);
        QueryNode parentDatasouce = this.getParentDatasource();
        assert (parentDatasouce != null);
        LinkDescriptor link = parentDatasouce.getDataLink(this, this.dataLink);
        if (link == null) {
            this.throwNodeError(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0432\u044f\u0437\u044c(%d)", this.dataLink));
        }
        this.query.generateLinkExpression(this, parentDatasouce, link, sql);
    }

    @Override
    public void generateJoin(StringBuilder sql, IntegerSet fieldsUsage) throws Exception {
        StringBuilder stringBuilder;
        this.joinType.generateSql(sql);
        this.generateRaw(sql, fieldsUsage, null);
        sql.append(' ');
        this.generateAlias(sql, false);
        String dataLinkSql = null;
        String fieldBindsSql = null;
        if (this.dataLink != 0) {
            stringBuilder = new StringBuilder();
            this.generateDataLinkSqlExpression(stringBuilder);
            dataLinkSql = stringBuilder.toString();
            if (dataLinkSql.isEmpty()) {
                dataLinkSql = null;
            }
        } else if (this.directoryLink != 0) {
            stringBuilder = new StringBuilder();
            this.generateDirectoryLinkSqlExpression(stringBuilder);
            dataLinkSql = stringBuilder.toString();
            if (dataLinkSql.isEmpty()) {
                dataLinkSql = null;
            }
        }
        if (this.fieldBinds != null) {
            stringBuilder = new StringBuilder();
            this.fieldBinds.generateSql(this.query, this, stringBuilder);
            fieldBindsSql = stringBuilder.toString();
            if (fieldBindsSql.isEmpty()) {
                fieldBindsSql = null;
            }
        }
        if (dataLinkSql == null && fieldBindsSql == null) {
            return;
        }
        sql.append(" ON ");
        if (dataLinkSql != null) {
            sql.append('(').append(dataLinkSql).append(')');
            if (fieldBindsSql != null) {
                sql.append(" AND ");
            }
        }
        if (fieldBindsSql != null) {
            sql.append('(').append(fieldBindsSql).append(')');
        }
    }

    protected LinkDescriptor getDataLink(QueryNode node, int linkId) throws IOException, InformException {
        LinkDescriptor link = this.metadata.getLinkList().getLink(linkId);
        if (link == null) {
            this.throwNodeError(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0432\u044f\u0437\u044c(%d)", linkId));
        } else if (link.getTable() != node.getTableId()) {
            this.throwNodeError(String.format("\u041d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0432\u044f\u0437\u044c '%s'(id: %d)", link.getName(), linkId));
        }
        return link;
    }

    protected QueryField getScriptField(int id) {
        QueryField queryField = this.fields.get(id);
        if (queryField != null) {
            return queryField;
        }
        FieldDescriptor fieldDescriptor = this.getFieldById(id);
        if (fieldDescriptor != null) {
            queryField = new QueryField(fieldDescriptor, this);
            this.fields.add(queryField);
            String name = fieldDescriptor.getIdent();
            if (Strings.isVoid(name)) {
                name = fieldDescriptor.getRawName();
            }
            this.fieldMap.put(name, queryField);
            return queryField;
        }
        return null;
    }

    protected QueryField getScriptField(String name) {
        if (name == null || name.length() == 0 || this.fieldMap == null) {
            return null;
        }
        QueryField queryField = this.fieldMap.get(name);
        if (queryField != null) {
            return queryField;
        }
        FieldDescriptor fieldDescriptor = this.getFieldByName(name);
        if (fieldDescriptor != null) {
            queryField = new QueryField(fieldDescriptor, this);
            this.fields.add(queryField);
            this.fieldMap.put(name, queryField);
            return queryField;
        }
        return null;
    }

    @Override
    public Object get(String name, Scriptable start) {
        QueryField field = this.getScriptField(name);
        if (field != null) {
            return name;
        }
        return super.get(name, start);
    }

    @Override
    public FieldDescriptor getFieldByName(String fieldName) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getFieldByName(fieldName);
    }

    public FieldDescriptor getFieldById(int id) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getFieldById(id);
    }

    protected void initMetadata() throws IOException, InformException {
        this.metadata = this.query.getTableMetadata(this.tableNodeId);
    }

    public ReturnedFields getReturnedFields() {
        return this.returnedFields;
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws InformException, IOException {
        switch (tag) {
            case 3: {
                this.tableNodeId = reader.getNodeID();
                this.initMetadata();
                break;
            }
            case 10: {
                this.dataLink = reader.getInt();
                if (this.dataLink == 0) break;
                this.directoryLink = 0;
                break;
            }
            case 11: {
                this.joinType = JoinType.fromInt(reader.getInt());
                break;
            }
            case 12: {
                reader.skip();
                this.fieldBinds = new FieldBindList();
                this.fieldBinds.Load(new TaggedReader(reader.getSubStream()));
                break;
            }
            case 14: {
                this.directoryLink = reader.getInt();
                if (this.directoryLink == 0) break;
                this.dataLink = 0;
                break;
            }
            case 15: {
                reader.skip();
                this.periodicBind = new PeriodicBind();
                this.periodicBind.load(new TaggedReader(reader.getSubStream()));
                break;
            }
            case 17: {
                reader.skip();
                this.returnedFields.load(reader.getRaw(202));
                break;
            }
            case 18: {
                this.excludable = false;
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    @Override
    protected void afterLoad() {
        super.afterLoad();
        if (this.getParentDatasource() == null) {
            this.dataLink = 0;
            this.directoryLink = 0;
            this.fieldBinds = null;
        }
    }

    @Override
    public void writeGetTableRecordsRefsContent(TaggedWriter out) throws InformException, IOException {
        if (this.getKind() != QueryNodeKind.QUERY) {
            out.putDouble(5, this.tableNodeId);
        }
    }

    public void calculateReference() {
        this.debugBuilderProcessed = false;
        if (this.dataLink != 0 && this.parent != null && this.parent instanceof QueryNode) {
            ((QueryNode)this.parent).referencedTo.add(this.getEntryId());
        }
        if (this.directoryLink != 0 && this.parent != null && this.parent instanceof QueryNode) {
            ((QueryNode)this.parent).referencedTo.add(this.getEntryId());
        }
        if (this.fieldBinds != null) {
            for (FieldBind bind : this.fieldBinds) {
                GenericQueryNode node;
                if (bind.type != FieldBind.BindType.FIELD || (node = this.query.findNodeById(bind.getBindedDatasource())) == null || !(node instanceof QueryNode)) continue;
                ((QueryNode)node).referencedTo.add(this.getEntryId());
            }
        }
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public IntegerSet getReferencedTo() {
        return this.referencedTo;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean value) {
        this.ignored = value;
    }

    @SmartScriptableObject.FunctionTag
    public void addFieldLink(QueryField left, QueryField right) {
        if (left == null || right == null) {
            return;
        }
        if (left.getEntryId() != this.getEntryId()) {
            if (right.getEntryId() != this.getEntryId()) {
                this.throwNodeError("\u041e\u0442\u0441\u0443\u0442\u0432\u0443\u0435\u0442 \u043f\u043e\u043b\u0435 \u0441\u0432\u044f\u0437\u0438 \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
            }
            QueryField f = left;
            left = right;
            right = f;
        }
        FieldBind bind = new FieldBind(left.key());
        bind.setBindedDatasource(right.getEntryId());
        bind.setFieldId(right.key());
        this.fieldBinds.binds.add(bind);
    }

    @SmartScriptableObject.PropertyTag
    public String getCaption() {
        if (this.description == null) {
            this.description = this.metadata == null ? "" : MtdEngine.getNodeName(this.tableNodeId);
        }
        return this.description;
    }

    @SmartScriptableObject.PropertyTag
    public String getRawName() {
        if (this.metadata == null) {
            return "";
        }
        return this.metadata.getRawName();
    }

    @SmartScriptableObject.PropertyTag
    public double getFilterID() {
        return 0.0;
    }

    @SmartScriptableObject.PropertyTag
    public double getTableID() {
        return this.tableNodeId;
    }

    public void setActualPoint(double value) {
        if (this.periodicBind == null) {
            this.periodicBind = new PeriodicBind();
        }
        this.periodicBind.setValue(value);
    }
}

