/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.TableLinkList;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class QueryNodeMetadata
implements DoubleHash.Entry {
    final TableDescriptor tableDescriptor;
    private HashMap<String, FieldDescriptor> fieldsByName;
    private IntegerHash<FieldDescriptor> fieldsById;
    private DatabaseCaps databaseCaps = null;

    public QueryNodeMetadata(double nodeId) throws IOException, InformException {
        this.tableDescriptor = new TableDescriptor(nodeId, true);
        this.fieldsByName = new HashMap();
        this.fieldsById = new IntegerHash();
        for (FieldDescriptor field : this.tableDescriptor.getFields()) {
            String name = field.getIdent();
            if (Strings.isVoid(name) && Strings.isVoid(name = field.getRawName())) continue;
            if (!this.fieldsByName.containsKey(name = name.toUpperCase())) {
                this.fieldsByName.put(name, field);
            }
            this.fieldsById.add(field);
        }
        FieldDescriptor field = this.tableDescriptor.getRecordIdField();
        if (field != null) {
            String name = field.getIdent();
            if (Strings.isVoid(name) && Strings.isVoid(name = field.getRawName())) {
                return;
            }
            if (!this.fieldsByName.containsKey(name = name.toUpperCase())) {
                this.fieldsByName.put(name, field);
            }
            this.fieldsById.add(field);
        }
    }

    public FieldDescriptor getFieldByName(String fieldName) {
        if (this.fieldsByName == null) {
            return null;
        }
        fieldName = fieldName.toUpperCase();
        return this.fieldsByName.get(fieldName);
    }

    public FieldDescriptor getFieldById(int id) {
        if (this.fieldsById == null) {
            return null;
        }
        FieldDescriptor result = this.fieldsById.get(id);
        if (result == null && id == -1) {
            result = this.tableDescriptor.getRecordIdField();
        }
        return result;
    }

    public double getDatabaseId() {
        return this.tableDescriptor.getDbId();
    }

    public TableDescriptor.Kind getKind() {
        return this.tableDescriptor.getKind();
    }

    public TableLinkList getLinkList() throws IOException, TaggedReaderException {
        return this.tableDescriptor.getLinkList();
    }

    public double getNodeId() {
        return this.tableDescriptor.getNodeId();
    }

    public String getRawName() {
        return this.tableDescriptor.getRawName();
    }

    public FieldDescriptor getRecordIdField() {
        return this.tableDescriptor.getRecordIdField();
    }

    public TableDescriptor getDescriptor() {
        return this.tableDescriptor;
    }

    public DatabaseType getDatabaseType() {
        return this.tableDescriptor.getDatabaseDescriptor().getDatabaseType();
    }

    public DatabaseCaps getMetadataCaps() {
        if (this.databaseCaps == null) {
            DatabaseDescriptor db = this.tableDescriptor.getDatabaseDescriptor();
            this.databaseCaps = db.getDatabaseType().caps();
        }
        return this.databaseCaps;
    }

    public boolean hasPeriodicStorage() {
        return this.tableDescriptor.isHasPeriodicStorage();
    }

    public Collection<FieldDescriptor> getFields() {
        return this.tableDescriptor.getFields();
    }

    @Override
    public double key() {
        return this.tableDescriptor.getNodeId();
    }
}

