/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.adt.DateTime;
import inform.adt.TimeInfo;
import inform.agent.db.types.DataType;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.FilterCondition;
import inform.agent.scripts.sql.expr.cnd.BinaryOperation;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryFieldEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryNullEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;
import java.util.ArrayList;

public class CompareOperation
extends BinaryOperation {
    private final int operationRangeId;
    private final boolean operationAny;
    private static final String[] eqParams = new String[]{"=", " IN", " OR ", " AND "};
    private static final String[] notEqParams = new String[]{"!=", " NOT IN", " AND ", " AND "};
    private static final String[] ltParams = new String[]{"<", null, " AND ", " AND "};
    private static final String[] ltEqParams = new String[]{"<=", null, " AND ", " AND "};
    private static final String[] gtParams = new String[]{">", null, " AND ", " AND "};
    private static final String[] gtEqParams = new String[]{">=", null, " AND ", " AND "};
    private static final String[] likeParams = new String[]{" like ", null, " OR ", " OR "};
    private static final String[] notLikeParams = new String[]{" not like ", null, " AND ", " AND "};
    private static final String[] startWithParams = new String[]{" like ", null, " OR ", " OR "};
    private static final String[] notStartWithParams = new String[]{" not like ", null, " AND ", " AND "};
    private static final Oper operEqual = new Oper(Expression.Token.equal, eqParams, true, true);
    private static final Oper operNotEqual = new Oper(Expression.Token.notEqual, notEqParams, false, true);
    private static final Oper operLess = new Oper(Expression.Token.less, ltParams, false, false);
    private static final Oper operLessEqual = new Oper(Expression.Token.lessEqual, ltEqParams, false, false);
    private static final Oper operGrater = new Oper(Expression.Token.greater, gtParams, false, false);
    private static final Oper operGraterEqual = new Oper(Expression.Token.greaterEqual, gtEqParams, false, false);
    private static final Oper operLike = new Oper(Expression.Token.like, likeParams, true, true);
    private static final Oper operNotLike = new Oper(Expression.Token.notLike, notLikeParams, false, true);
    private static final Oper operStart = new Oper(Expression.Token.startWith, startWithParams, true, true);
    private static final Oper operNotStart = new Oper(Expression.Token.notStartWith, notStartWithParams, false, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompareOperation(OperationTerm term, QueryEvaluator left, QueryEvaluator right) {
        super(term, left, right);
        this.operationRangeId = term.getRangeId();
        this.operationAny = term.isAny();
        Class<CompareOperation> clazz = CompareOperation.class;
        synchronized (CompareOperation.class) {
            if (CompareOperation.operEqual.swap == null) {
                CompareOperation.operGrater.swap = operLess;
                CompareOperation.operNotEqual.swap = operNotEqual;
                CompareOperation.operLess.swap = operGrater;
                CompareOperation.operLessEqual.swap = operGraterEqual;
                CompareOperation.operEqual.swap = operEqual;
                CompareOperation.operGraterEqual.swap = operLessEqual;
                CompareOperation.operLike.swap = operLike;
                CompareOperation.operNotLike.swap = operNotLike;
                CompareOperation.operStart.swap = operStart;
                CompareOperation.operNotStart.swap = operNotStart;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        Param p;
        if (this.isIgnored()) {
            return;
        }
        Expression.Token token = this.term.getToken();
        QueryEvaluator right = this.right;
        block0 : switch (token) {
            case startWith: 
            case like: 
            case notStartWith: 
            case notLike: {
                String v;
                QueryValueEvaluator value;
                if (!(this.term.getExpression() instanceof FilterCondition) || !(this.left instanceof QueryFieldEvaluator) || ((QueryFieldEvaluator)this.left).getDataType() != DataType.BOOLEAN || (value = right.getValue()) == null || (v = value.getAsString()) == null || v.length() != 0 && !v.equals(" ")) break;
                right = value.getNull();
                switch (token) {
                    case startWith: 
                    case like: {
                        token = Expression.Token.equal;
                        break block0;
                    }
                    case notStartWith: 
                    case notLike: {
                        token = Expression.Token.notEqual;
                    }
                }
            }
        }
        switch (token) {
            case equal: {
                p = new Param(operEqual);
                break;
            }
            case less: {
                p = new Param(operLess);
                if (this.left.isMultipleValue() || this.left.hasNull()) {
                    this.left.compactNonNullValues(false, this.operationRangeId == 5, p.op.opSql);
                }
                if (!right.isMultipleValue() && !right.hasNull()) break;
                right.compactNonNullValues(true, this.operationRangeId == 5, p.op.opSql);
                break;
            }
            case greater: {
                p = new Param(operGrater);
                if (this.left.isMultipleValue() || this.left.hasNull()) {
                    this.left.compactNonNullValues(true, this.operationRangeId == 5, p.op.opSql);
                }
                if (!right.isMultipleValue() && !right.hasNull()) break;
                right.compactNonNullValues(false, this.operationRangeId == 5, p.op.opSql);
                break;
            }
            case lessEqual: {
                p = new Param(operLessEqual);
                if (this.left.isMultipleValue() || this.left.hasNull()) {
                    this.left.compactNonNullValues(false, this.operationRangeId == 5, p.op.opSql);
                }
                if (!right.isMultipleValue() && !right.hasNull()) break;
                right.compactNonNullValues(true, this.operationRangeId == 5, p.op.opSql);
                break;
            }
            case greaterEqual: {
                p = new Param(operGraterEqual);
                if (this.left.isMultipleValue() || this.left.hasNull()) {
                    this.left.compactNonNullValues(true, this.operationRangeId == 5, p.op.opSql);
                }
                if (!right.isMultipleValue() && !right.hasNull()) break;
                right.compactNonNullValues(false, this.operationRangeId == 5, p.op.opSql);
                break;
            }
            case notEqual: {
                p = new Param(operNotEqual);
                break;
            }
            case like: {
                p = new Param(operLike);
                this.left.compactNullValues();
                right.compactNullValues();
                break;
            }
            case notLike: {
                p = new Param(operNotLike);
                this.left.compactNullValues();
                right.compactNullValues();
                break;
            }
            case startWith: {
                p = new Param(operStart);
                this.left.compactNullValues();
                right.compactNullValues();
                break;
            }
            case notStartWith: {
                p = new Param(operNotStart);
                this.left.compactNullValues();
                right.compactNullValues();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.generateCondition(p, sql, query, this.left, right);
    }

    public boolean isRanged() {
        switch (this.operationRangeId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void unrangedGenerate(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        if (p.leftNull && p.rightNull) {
            if (p.op.hasEqual) {
                sql.append("(0=0)");
            } else {
                sql.append("(0!=0)");
            }
        } else if (p.leftNull) {
            this.unrangedGenerate(p.swap(), sql, query, right, left);
        } else if (p.rightNull) {
            if (p.op.nullGeneration) {
                if (p.op.hasEqual) {
                    left.generate(sql, query);
                    sql.append(" IS NULL ");
                } else {
                    left.generate(sql, query);
                    sql.append(" IS NOT NULL ");
                }
            } else {
                left.generate(sql, query);
                sql.append(p.op.opSql);
                right.generate(sql, query);
            }
        } else {
            left.generate(sql, query);
            sql.append(p.op.opSql);
            String suffix = null;
            switch (p.op.id) {
                case like: 
                case notLike: {
                    suffix = right.generateLike(sql, query, true, true);
                    break;
                }
                case startWith: 
                case notStartWith: {
                    suffix = right.generateLike(sql, query, false, true);
                    break;
                }
                default: {
                    right.generate(sql, query);
                }
            }
            if (suffix != null) {
                sql.append(' ').append(suffix);
            }
        }
    }

    DateTimeInterval getStaticRange(double v) {
        DateTimeInterval p = new DateTimeInterval();
        TimeInfo t = new TimeInfo();
        DateTime.toTimeInfo(v, t);
        switch (this.operationRangeId) {
            case 1: {
                v = DateTime.create(t.year, t.month, t.day);
                p.setStartDate(v);
                p.setEndDate(v + 1.0);
                break;
            }
            case 2: {
                v = DateTime.create(t.year, t.month, 1);
                p.setStartDate(v);
                ++t.month;
                if (t.month > 12) {
                    t.month = 1;
                    ++t.year;
                }
                v = DateTime.create(t.year, t.month, 1);
                p.setEndDate(v);
                break;
            }
            case 3: {
                int nextMonth;
                int nextYear = t.year;
                if (t.month < 4) {
                    t.month = 1;
                    nextMonth = 4;
                } else if (t.month < 7) {
                    t.month = 4;
                    nextMonth = 7;
                } else if (t.month < 10) {
                    t.month = 7;
                    nextMonth = 10;
                } else {
                    t.month = 10;
                    nextMonth = 1;
                    ++nextYear;
                }
                v = DateTime.create(t.year, t.month, 1);
                p.setStartDate(v);
                v = DateTime.create(nextYear, nextMonth, 1);
                p.setEndDate(v);
                break;
            }
            case 4: {
                v = DateTime.create(t.year, 1, 1);
                p.setStartDate(v);
                v = DateTime.create(t.year + 1, 1, 1);
                p.setEndDate(v);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return p;
    }

    private void genarateRange(Param p, StringBuilder sql, Query query, DateTimeInterval right, QueryEvaluator left) throws Exception {
        switch (p.op.id) {
            case equal: {
                sql.append('(');
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getStartDate(), sql, query);
                sql.append(CompareOperation.operLessEqual.opSql);
                left.generate(sql, query);
                sql.append(" AND ");
                left.generate(sql, query);
                sql.append(CompareOperation.operLess.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getEndDate(), sql, query);
                sql.append(')');
                break;
            }
            case less: {
                left.generate(sql, query);
                sql.append(CompareOperation.operLess.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getStartDate(), sql, query);
                break;
            }
            case greater: {
                left.generate(sql, query);
                sql.append(CompareOperation.operGraterEqual.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getEndDate(), sql, query);
                break;
            }
            case lessEqual: {
                left.generate(sql, query);
                sql.append(CompareOperation.operLess.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getEndDate(), sql, query);
                break;
            }
            case greaterEqual: {
                left.generate(sql, query);
                sql.append(CompareOperation.operGraterEqual.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getStartDate(), sql, query);
                break;
            }
            case notEqual: {
                sql.append('(');
                left.generate(sql, query);
                sql.append(CompareOperation.operLess.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getStartDate(), sql, query);
                sql.append(" OR ");
                left.generate(sql, query);
                sql.append(CompareOperation.operGraterEqual.opSql);
                QueryValueEvaluator.generateValue(DataType.DATE_TIME, right.getEndDate(), sql, query);
                sql.append(')');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void generateSingleRanged(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        if (p.leftNull || p.rightNull) {
            this.unrangedGenerate(p, sql, query, left, right);
            return;
        }
        switch (this.operationRangeId) {
            case 5: {
                sql.append(" UPPER(");
                left.generateAsString(sql, query);
                sql.append(')').append(p.op.opSql).append(" UPPER(");
                String suffix = null;
                switch (p.op.id) {
                    case like: 
                    case notLike: {
                        suffix = right.generateLike(sql, query, true, true);
                        break;
                    }
                    case startWith: 
                    case notStartWith: {
                        suffix = right.generateLike(sql, query, false, true);
                        break;
                    }
                    default: {
                        right.generateAsString(sql, query);
                    }
                }
                if (suffix == null) {
                    sql.append(')');
                } else {
                    sql.append(") ").append(suffix);
                }
                return;
            }
            case 6: {
                if (p.leftValue != null && p.rightValue != null) {
                    if (p.leftNull) {
                        sql.append("(0").append(p.op.opSql).append("1)");
                    } else if (p.rightNull) {
                        sql.append("(1").append(p.op.opSql).append("0)");
                    } else {
                        int l = p.leftValue.getNumber() != 0.0 ? 1 : 0;
                        int r = p.rightValue.getNumber() != 0.0 ? 1 : 0;
                        sql.append('(').append(l).append(p.op.opSql).append(r).append(')');
                    }
                } else if (p.leftValue != null) {
                    this.generateSingle(p.swap(), sql, query, right, left);
                } else if (p.rightValue != null) {
                    boolean r = p.rightValue.getNumber() != 0.0;
                    switch (p.op.id) {
                        case equal: {
                            if (r) {
                                left.generate(sql, query);
                                sql.append("!=");
                                query.generateBoolValueSql(false, sql);
                                break;
                            }
                            sql.append('(');
                            left.generate(sql, query);
                            sql.append("=");
                            query.generateBoolValueSql(false, sql);
                            sql.append(" or ");
                            left.generate(sql, query);
                            sql.append(" is null)");
                            break;
                        }
                        case notEqual: {
                            if (r) {
                                sql.append('(');
                                left.generate(sql, query);
                                sql.append("=");
                                query.generateBoolValueSql(false, sql);
                                sql.append(" or ");
                                left.generate(sql, query);
                                sql.append(" is null)");
                                break;
                            }
                            left.generate(sql, query);
                            sql.append("!=");
                            query.generateBoolValueSql(false, sql);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 " + p.op.opSql + " \u0434\u043b\u044f \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0442\u0438\u043f\u0430");
                        }
                    }
                } else {
                    sql.append(" COALESCE(");
                    left.generate(sql, query);
                    sql.append(",");
                    query.generateBoolValueSql(false, sql);
                    sql.append(")").append(p.op.opSql).append(" COALESCE(");
                    right.generate(sql, query);
                    sql.append(",");
                    query.generateBoolValueSql(false, sql);
                    sql.append(")");
                }
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                this.unrangedGenerate(p, sql, query, left, right);
                return;
            }
        }
        if (p.leftRanged && p.rightRanged) {
            DateTimeInterval l = this.getStaticRange(p.leftValue.getNumber());
            DateTimeInterval r = this.getStaticRange(p.rightValue.getNumber());
            QueryValueEvaluator.generateValue(DataType.DATE_TIME, l.getStartDate(), sql, query);
            sql.append(p.op.opSql);
            QueryValueEvaluator.generateValue(DataType.DATE_TIME, r.getStartDate(), sql, query);
        } else if (p.leftRanged) {
            DateTimeInterval l = this.getStaticRange(p.leftValue.getNumber());
            this.genarateRange(p, sql, query, l, right);
        } else if (p.rightRanged) {
            DateTimeInterval r = this.getStaticRange(p.rightValue.getNumber());
            this.genarateRange(p, sql, query, r, left);
        } else {
            this.unrangedGenerate(p, sql, query, left, right);
        }
    }

    private void generateSubject(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        assert (p.rightSubject != null);
        left.generate(sql, query);
        if (p.op.multipleOpSql != null) {
            sql.append(p.op.multipleOpSql).append('(');
            right.generate(sql, query);
            sql.append(')');
        } else {
            sql.append(p.op.opSql);
            if (this.operationAny) {
                sql.append(" ANY");
            }
            sql.append('(');
            right.generate(sql, query);
            sql.append(')');
        }
    }

    private void generateSingle(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        if (p.rightSubject != null) {
            this.generateSubject(p, sql, query, left, right);
        } else if (p.leftSubject != null) {
            this.generateSubject(p.swap(), sql, query, right, left);
        } else {
            this.generateSingleRanged(p, sql, query, left, right);
        }
    }

    private void expandRight(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        boolean brace;
        if (p.rightValue == null) {
            throw new IllegalStateException();
        }
        Param expandParam = new Param(p.op);
        expandParam.leftMultiple = p.leftMultiple;
        expandParam.leftNull = p.leftNull;
        expandParam.leftRanged = p.leftRanged;
        expandParam.leftValue = p.leftValue;
        expandParam.rightMultiple = false;
        expandParam.rightRanged = p.rightRanged;
        expandParam.rightNull = false;
        int rightValueCount = p.rightValue.getArraySize(false);
        String op = "";
        boolean bl = brace = p.rightNull && !p.leftNull && rightValueCount > 0 || rightValueCount > 1;
        if (brace) {
            sql.append('(');
        }
        if (p.rightNull) {
            if (p.leftNull) {
                this.unrangedGenerate(p, sql, query, left, right);
            } else {
                expandParam.rightNull = true;
                QueryValueEvaluator Null2 = p.rightValue != null ? p.rightValue.getNull() : QueryNullEvaluator.Null;
                expandParam.rightValue = Null2;
                this.generateSingle(expandParam, sql, query, left, Null2);
                op = p.op.expandOpSql;
            }
        }
        if (rightValueCount == 1) {
            sql.append(op);
            expandParam.rightNull = false;
            expandParam.rightValue = p.rightValue.arrayTopEvaluator(false);
            this.generateSingle(expandParam, sql, query, left, expandParam.rightValue);
        } else if (rightValueCount != 0) {
            if (p.leftRanged || p.rightRanged || p.op.multipleOpSql == null) {
                ArrayList<QueryValueEvaluator> rightValues = new ArrayList<QueryValueEvaluator>();
                p.rightValue.getArray(rightValues, false);
                for (QueryValueEvaluator value : rightValues) {
                    sql.append(op);
                    expandParam.rightNull = false;
                    expandParam.rightValue = value;
                    this.generateSingle(expandParam, sql, query, left, value);
                    op = p.op.expandOpSql;
                }
            } else {
                sql.append(op);
                left.generate(sql, query);
                sql.append(p.op.multipleOpSql).append('(');
                right.generateExceptForNull(sql, query);
                sql.append(')');
            }
        }
        if (brace) {
            sql.append(')');
        }
    }

    private void expandLeft(Param p, StringBuilder sql, Query query, QueryEvaluator right) throws Exception {
        if (p.leftValue == null || p.rightValue == null) {
            throw new IllegalStateException();
        }
        Param expandParam = new Param(p.op);
        expandParam.rightMultiple = p.rightMultiple;
        expandParam.rightNull = p.rightNull;
        expandParam.rightRanged = p.rightRanged;
        expandParam.rightValue = p.rightValue;
        expandParam.leftMultiple = false;
        expandParam.leftRanged = p.leftRanged;
        expandParam.leftNull = false;
        ArrayList<QueryValueEvaluator> leftValues = new ArrayList<QueryValueEvaluator>();
        p.leftValue.getArray(leftValues, false);
        String op = "";
        sql.append('(');
        if (p.leftNull) {
            expandParam.leftNull = true;
            QueryValueEvaluator Null2 = p.leftValue != null ? p.leftValue.getNull() : QueryNullEvaluator.Null;
            expandParam.leftValue = Null2;
            this.expandRight(expandParam, sql, query, Null2, right);
            op = p.op.leftExpandOpSql;
        }
        for (QueryValueEvaluator value : leftValues) {
            sql.append(op);
            expandParam.leftNull = false;
            expandParam.leftValue = value;
            this.expandRight(expandParam, sql, query, value, right);
            op = p.op.leftExpandOpSql;
        }
        sql.append(')');
    }

    private void generateCondition(Param p, StringBuilder sql, Query query, QueryEvaluator left, QueryEvaluator right) throws Exception {
        boolean rightExpandable;
        boolean isRanged = this.isRanged();
        p.leftSubject = left.getSubject();
        if (p.leftSubject != null) {
            left = p.leftSubject;
        } else {
            p.leftValue = left.getValue();
            if (p.leftValue != null) {
                left = p.leftValue;
            }
        }
        p.rightSubject = right.getSubject();
        if (p.rightSubject != null) {
            right = p.rightSubject;
        } else {
            p.rightValue = right.getValue();
            if (p.rightValue != null) {
                right = p.rightValue;
            }
        }
        p.leftNull = left == null || left.hasNull();
        p.rightNull = right == null || right.hasNull();
        p.leftMultiple = left != null && left.isMultipleValue();
        p.rightMultiple = right != null && right.isMultipleValue();
        p.leftRanged = p.leftValue != null && isRanged;
        p.rightRanged = p.rightValue != null && isRanged;
        boolean leftExpandable = p.leftMultiple || p.leftRanged;
        boolean bl = rightExpandable = p.rightMultiple || p.rightRanged;
        if (!leftExpandable && !rightExpandable) {
            this.generateSingle(p, sql, query, left, right);
        } else if (!leftExpandable && rightExpandable) {
            this.expandRight(p, sql, query, left, right);
        } else if (!rightExpandable) {
            this.expandRight(p.swap(), sql, query, right, left);
        } else {
            this.expandLeft(p, sql, query, right);
        }
    }

    private class Param {
        final Oper op;
        QueryValueEvaluator leftValue = null;
        QueryValueEvaluator rightValue = null;
        QuerySubjectEvaluator leftSubject = null;
        QuerySubjectEvaluator rightSubject = null;
        boolean leftNull;
        boolean rightNull;
        boolean leftMultiple;
        boolean rightMultiple;
        boolean leftRanged;
        boolean rightRanged;

        Param(Oper op) {
            this.op = op;
        }

        Param swap() {
            Param p = new Param(this.op.swap);
            p.leftValue = this.rightValue;
            p.rightValue = this.leftValue;
            p.leftNull = this.rightNull;
            p.rightNull = this.leftNull;
            p.leftMultiple = this.rightMultiple;
            p.rightMultiple = this.leftMultiple;
            p.leftRanged = this.rightRanged;
            p.rightRanged = this.leftRanged;
            p.leftSubject = this.rightSubject;
            p.rightSubject = this.leftSubject;
            return p;
        }
    }

    private static class Oper {
        final Expression.Token id;
        final String opSql;
        final String multipleOpSql;
        final String expandOpSql;
        final String leftExpandOpSql;
        Oper swap;
        final boolean hasEqual;
        final boolean nullGeneration;

        Oper(Expression.Token id, String[] p, boolean hasEqual, boolean nullGeneration) {
            int i = 0;
            this.id = id;
            this.opSql = p[i++];
            this.multipleOpSql = p[i++];
            this.expandOpSql = p[i++];
            this.leftExpandOpSql = p[i];
            this.swap = null;
            this.hasEqual = hasEqual;
            this.nullGeneration = nullGeneration;
        }
    }
}

