/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.fn;

import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryFunctionEvaluator;

public class SQLAggregativeFunction
extends QueryFunctionEvaluator {
    public SQLAggregativeFunction(Term term) {
        super(term);
    }

    @Override
    public boolean isAggregative() {
        return true;
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        if (this.term.getToken() == Expression.Token.functionAgrCountAll) {
            sql.append("COUNT(*)");
            return;
        }
        if (this.arguments.size() != 1) {
            throw new IllegalStateException();
        }
        switch (this.term.getToken()) {
            case functionAgrSum: {
                sql.append("SUM(");
                break;
            }
            case functionAgrAvg: {
                sql.append("AVG(");
                break;
            }
            case functionAgrCount: {
                sql.append("COUNT(");
                break;
            }
            case functionAgrCountAll: {
                sql.append("COUNT(*)");
                return;
            }
            case functionAgrMin: {
                sql.append("MIN(");
                break;
            }
            case functionAgrMax: {
                sql.append("MAX(");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (QueryEvaluator arg : this.arguments) {
            if (arg.isIgnored()) continue;
            arg.generate(sql, query);
            break;
        }
        sql.append(')');
    }

    @Override
    public boolean isIgnored() {
        if (this.term.getToken() == Expression.Token.functionAgrCountAll && this.arguments.isEmpty()) {
            return this.term.isIgnored();
        }
        return super.isIgnored();
    }
}

