/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.fn;

import inform.adt.InformException;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.types.DataType;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryFunctionEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;

public class SQLMonthEndDateEvaluator
extends QueryFunctionEvaluator {
    public SQLMonthEndDateEvaluator(Term term) {
        super(term);
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        if (this.arguments.size() != 1) {
            throw new IllegalStateException();
        }
        DatabaseCaps caps = query.getDatabaseCaps();
        ValueTerm oneMonthTerm = new ValueTerm(this.term.getExpression());
        oneMonthTerm.setValue(DataType.INTEGER, 1);
        QueryValueEvaluator oneMonthArg = new QueryValueEvaluator(oneMonthTerm);
        ValueTerm oneDayTerm = new ValueTerm(this.term.getExpression());
        oneDayTerm.setValue(DataType.INTEGER, -1);
        QueryValueEvaluator oneDayArg = new QueryValueEvaluator(oneDayTerm);
        StringBuilder beginMonth = new StringBuilder();
        caps.truncDate(beginMonth, () -> {
            try {
                ((QueryEvaluator)this.arguments.get(0)).generate(beginMonth, query);
            }
            catch (Exception e) {
                throw InformException.wrap(e);
            }
        }, DatabaseCaps.TruncDateType.month);
        StringBuilder oneMonth = new StringBuilder();
        oneMonthArg.generate(oneMonth, query);
        String nextMonth = caps.addMonthsBegin() + (caps.addMonthsDateFirstArg() ? beginMonth : oneMonth) + caps.addMonthsMiddle() + (caps.addMonthsDateFirstArg() ? oneMonth : beginMonth) + caps.addMonthsEnd();
        sql.append(caps.addDaysBegin());
        sql.append(nextMonth);
        sql.append(caps.addDaysMiddle());
        oneDayArg.generate(sql, query);
        sql.append(caps.addDaysEnd());
    }

    @Override
    public boolean isIgnored() {
        if (super.isIgnored()) {
            return true;
        }
        return this.arguments.size() < 1 || ((QueryEvaluator)this.arguments.get(0)).isIgnored();
    }
}

