/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.stat;

import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerHash;
import inform.agent.scripts.stat.DataNodeProfile;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import java.util.ArrayList;
import java.util.Collections;

public class ModuleProfile
implements DoubleHash.Entry {
    private final double moduleId;
    private final IntegerHash<DatasourceProfile> datasources = new IntegerHash();
    private final DoubleHash<DirectoryProfile> directories = new DoubleHash();

    public ModuleProfile(double moduleId) {
        this.moduleId = moduleId;
    }

    public DatasourceProfile addDatasource(int uid, DataNodeProfile nodeProfile, double filterId) {
        DatasourceProfile d = this.datasources.get(uid);
        if (d == null) {
            d = new DatasourceProfile(uid, nodeProfile, filterId);
            this.datasources.add(d);
        }
        return d;
    }

    public DirectoryProfile addDirectory(DataNodeProfile nodeProfile) {
        DirectoryProfile d = this.directories.get(nodeProfile.getNodeId());
        if (d == null) {
            d = new DirectoryProfile(nodeProfile);
            this.directories.add(d);
        }
        return d;
    }

    @Override
    public double key() {
        return this.moduleId;
    }

    public void getProfile(StringBuilder profile) {
        ArrayList<DatasourceProfile> datasourceProfiles = new ArrayList<DatasourceProfile>(this.datasources.size());
        for (DatasourceProfile d : this.datasources) {
            datasourceProfiles.add(d);
        }
        Collections.sort(datasourceProfiles);
        for (DatasourceProfile d : datasourceProfiles) {
            d.getProfile(profile);
            profile.append('\n');
        }
        datasourceProfiles = null;
        ArrayList<DirectoryProfile> directoryProfiles = new ArrayList<DirectoryProfile>(this.directories.size());
        for (DirectoryProfile d : this.directories) {
            directoryProfiles.add(d);
        }
        Collections.sort(directoryProfiles);
        for (DirectoryProfile d : directoryProfiles) {
            d.getProfile(profile);
            profile.append('\n');
        }
    }
}

