/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.stat;

public class ProfileItem
implements Comparable<ProfileItem> {
    protected int recordCount = 0;
    protected int accessCount = 0;
    protected long requestCount = 0L;
    protected long requestTime = 0L;

    public void addRecordCount(int recordCount) {
        this.recordCount += recordCount;
    }

    public void incRecordCount() {
        ++this.recordCount;
    }

    public void addAccessCount() {
        ++this.accessCount;
    }

    public void addRequestTime(long requestTime) {
        this.requestTime += requestTime;
        ++this.recordCount;
    }

    public void addRequestCount() {
        ++this.requestCount;
    }

    @Override
    public int compareTo(ProfileItem p) {
        if (p == null) {
            return 1;
        }
        if (this.requestTime < p.requestTime) {
            return 1;
        }
        if (this.requestTime > p.requestTime) {
            return -1;
        }
        if (this.requestCount < p.requestCount) {
            return 1;
        }
        if (this.requestCount > p.requestCount) {
            return -1;
        }
        return 0;
    }

    public void getProfile(StringBuilder profile) {
        profile.append("          request time:  ").append((double)this.requestTime / 1000.0).append(" s\n");
        profile.append("          request count: ").append(this.requestCount).append('\n');
        profile.append("          record count:  ").append(this.recordCount).append('\n');
        profile.append("          access count:  ").append(this.accessCount);
    }
}

