/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.odt;

import inform.agent.scripts.textdocuments.odt.OdtDocument;
import inform.common.SmartScriptableObject;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class OdtFont
extends SmartScriptableObject {
    private final OdtDocument odtDocument;
    private final Map<String, String> propertiesFont;

    public OdtFont(OdtDocument odtDocument) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.propertiesFont = new HashMap<String, String>();
    }

    public OdtFont(OdtDocument odtDocument, OdtFont odtFont) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.propertiesFont = new HashMap<String, String>();
        if (odtFont != null) {
            this.propertiesFont.putAll(odtFont.getPropertiesFont());
        }
    }

    @Override
    public String getClassName() {
        return "OdtFont";
    }

    public Map<String, String> getPropertiesFont() {
        return this.propertiesFont;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getBold() {
        return Boolean.parseBoolean(this.propertiesFont.get("fo:font-weight"));
    }

    @SmartScriptableObject.FunctionTag
    public void setBold(boolean value) {
        if (value) {
            this.propertiesFont.put("fo:font-weight", "bold");
        } else {
            this.propertiesFont.put("fo:font-weight", "normal");
        }
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsItalic() {
        String value;
        switch (value = this.propertiesFont.get("fo:font-style")) {
            case "italic": {
                return true;
            }
        }
        return false;
    }

    @SmartScriptableObject.FunctionTag
    public void setItalic(boolean value) {
        if (value) {
            this.propertiesFont.put("fo:font-style", "italic");
        } else {
            this.propertiesFont.put("fo:font-style", "normal");
        }
    }

    @SmartScriptableObject.PropertyTag
    public String getFontFamily() {
        return this.propertiesFont.get("fo:font-family");
    }

    @SmartScriptableObject.FunctionTag
    public void setFontFamily(String value) {
        this.propertiesFont.put("fo:font-family", value);
    }

    @SmartScriptableObject.PropertyTag
    public int getFontSize() {
        return Integer.parseInt(this.propertiesFont.get("fo:font-size"));
    }

    @SmartScriptableObject.FunctionTag
    public void setFontSize(int value) {
        this.propertiesFont.put("fo:font-size", Integer.toString(value));
    }

    @SmartScriptableObject.PropertyTag
    public String getColor() {
        return this.propertiesFont.get("fo:color").startsWith("#") ? this.propertiesFont.get("fo:color").substring(1) : this.propertiesFont.get("fo:color");
    }

    @SmartScriptableObject.FunctionTag
    public void setColor(Object value) {
        org.odftoolkit.odfdom.type.Color color = OdtDocument.parseColor(value);
        Color awtColor = color.getAWTColor();
        String hex = String.format("#%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        this.propertiesFont.put("fo:color", hex);
    }
}

