/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.odt;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.textdocuments.odt.OdtDocument;
import inform.agent.scripts.textdocuments.odt.OdtStyle;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import org.mozilla.javascript.Undefined;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OdtParagraph
extends SmartScriptableObject {
    private static final String MESSAGE_CREATEPARAGRAPH_ERROR = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444";
    private static final String MESSAGE_BADINDEX_ERROR = "\u0417\u0430\u0434\u0430\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441";
    private static final String MESSAGE_BADPARAMETRS = "\u0412\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    private static final String MESSAGE_UNKNOWNFILE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438";
    private static final String MESSAGE_UNKNOWNCONTENT = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private final OdtDocument odtDocument;
    OdfTextParagraph paragraph;
    OdtStyle odtStyle;

    private OdtParagraph(OdtDocument odtDocument) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
    }

    private OdtParagraph(OdtDocument odtDocument, OdtStyle style) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        if (style != null) {
            this.odtStyle = style;
        }
    }

    public OdtParagraph(OdtDocument odtDocument, OdfTextParagraph paragraph) {
        this.setParentScope(odtDocument);
        this.odtDocument = odtDocument;
        this.paragraph = paragraph;
    }

    @Override
    public String getClassName() {
        return "OdtParagraph";
    }

    @SmartScriptableObject.PropertyTag
    public int getType() {
        return 1;
    }

    public static OdtParagraph insert(OdtDocument odtDocument, int index, OdtStyle style) throws Exception {
        Node targetNode;
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX_ERROR, new Object[0]));
        }
        OdtParagraph odtParagraph = new OdtParagraph(odtDocument, style);
        odtParagraph.paragraph = new OdfTextParagraph((OdfFileDom)odtDocument.textDocument.getContentDom());
        OdfContentDom contentDom = odtDocument.textDocument.getContentDom();
        StyleParagraphPropertiesElement element = new StyleParagraphPropertiesElement((OdfFileDom)contentDom);
        if (style != null) {
            for (Map.Entry<String, String> entry : style.getPropertiesStyle().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                element.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xsl-fo:1.0", key, value);
            }
        }
        odtParagraph.paragraph.getOrCreateUnqiueAutomaticStyle().appendChild((Node)element);
        OfficeTextElement rootElement = odtDocument.textDocument.getContentRoot();
        if (index >= odtDocument.textDocument.getContentRoot().getChildNodes().getLength()) {
            int lastIndex = odtDocument.textDocument.getContentRoot().getChildNodes().getLength() - 1;
            targetNode = rootElement.getChildNodes().item(lastIndex);
        } else {
            targetNode = rootElement.getChildNodes().item(index);
        }
        if (targetNode != null) {
            Node nextSibling = targetNode.getNextSibling();
            if (nextSibling != null) {
                rootElement.insertBefore((Node)odtParagraph.paragraph, nextSibling);
            } else {
                rootElement.appendChild((Node)odtParagraph.paragraph);
            }
        }
        if (odtParagraph.paragraph == null) {
            throw new InformException(String.format(MESSAGE_CREATEPARAGRAPH_ERROR, new Object[0]));
        }
        return odtParagraph;
    }

    @SmartScriptableObject.FunctionTag
    public void add(Object content, OdtStyle odtStyle, int pictureType, Object width, Object height) throws Exception {
        if (content instanceof String && pictureType == 0 && width instanceof Undefined && height instanceof Undefined) {
            OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)this.odtDocument.textDocument.getContentDom());
            textSpan.setTextContent(content.toString());
            StyleTextPropertiesElement element = new StyleTextPropertiesElement((OdfFileDom)this.odtDocument.textDocument.getContentDom());
            if (odtStyle != null && odtStyle.getFont() != null) {
                for (Map.Entry<String, String> entry : odtStyle.getFont().getPropertiesFont().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    element.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xsl-fo:1.0", key, value);
                }
            } else if (this.odtStyle != null && this.odtStyle.getFont() != null) {
                for (Map.Entry<String, String> entry : this.odtStyle.getFont().getPropertiesFont().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    element.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xsl-fo:1.0", key, value);
                }
            }
            textSpan.getOrCreateUnqiueAutomaticStyle().appendChild((Node)element);
            this.paragraph.appendChild((Node)textSpan);
        } else {
            String pt;
            InputStream is = null;
            if (content instanceof BinaryObject) {
                BinaryObject binary = (BinaryObject)content;
                is = new ByteArrayInputStream(binary.getInternalBuffer());
            } else if (content instanceof String) {
                File file = Core.mountfs.resolve(new File(content.toString()));
                if (!file.exists()) {
                    throw new InformException(String.format(MESSAGE_MISSINGFILE, content.toString()));
                }
                is = new FileInputStream(file);
            } else if (content instanceof DatasourceField) {
                DatasourceField field = (DatasourceField)content;
                if (field.getIsNull()) {
                    throw new InformException(MESSAGE_EMPTYFIELD);
                }
                switch (field.getDataType()) {
                    case BLOB: {
                        if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                            throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                        }
                        BinaryObject binary = field.getAsBinary();
                        assert (binary != null);
                        is = new ByteArrayInputStream(binary.getInternalBuffer());
                        break;
                    }
                    case FILE: {
                        is = ((BlobFileField)field).openFileStream();
                        break;
                    }
                    default: {
                        throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
                    }
                }
            } else {
                throw new InformException(MESSAGE_UNKNOWNCONTENT);
            }
            assert (is != null);
            switch (pictureType) {
                case 1: {
                    pt = ".png";
                    break;
                }
                case 2: {
                    pt = ".jpeg";
                    break;
                }
                default: {
                    throw new InformException(MESSAGE_UNKNOWNFILE);
                }
            }
            int wcm = 0;
            int hcm = 0;
            if (!(width instanceof Number) || !(height instanceof Number)) {
                throw new InformException(MESSAGE_BADPARAMETRS);
            }
            wcm = ((Number)width).intValue() / 38;
            hcm = ((Number)height).intValue() / 38;
            String uniqueName = "image_" + UUID.randomUUID() + pt;
            String imagePath = "Pictures/" + uniqueName;
            OdfPackage package1 = this.odtDocument.textDocument.getPackage();
            package1.insert(is, imagePath, null);
            OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)this.odtDocument.textDocument.getContentDom());
            Element drawFrame = textSpan.getOwnerDocument().createElementNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "draw:frame");
            drawFrame.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:svg:1.0", "svg:width", wcm + "cm");
            drawFrame.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:svg:1.0", "svg:height", hcm + "cm");
            drawFrame.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "draw:name", "ExampleImage");
            Element drawImage = textSpan.getOwnerDocument().createElementNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "draw:image");
            drawImage.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xlink:1.0", "xlink:href", imagePath);
            drawImage.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xlink:1.0", "xlink:type", "simple");
            drawImage.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xlink:1.0", "xlink:show", "embed");
            drawImage.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:xlink:1.0", "xlink:actuate", "onLoad");
            drawImage.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "draw:mime-type", "image/png");
            drawFrame.appendChild(drawImage);
            textSpan.appendChild((Node)drawFrame);
            this.paragraph.appendChild((Node)textSpan);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void clear() {
        Node child;
        while ((child = this.paragraph.getFirstChild()) != null) {
            this.paragraph.removeChild(child);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void addTab() throws Exception {
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)this.odtDocument.textDocument.getContentDom());
        TextTabElement element = textSpan.newTextTabElement();
        textSpan.appendChild((Node)element);
        this.paragraph.appendChild((Node)textSpan);
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceText(Object sourceText, Object newText) {
        if (sourceText instanceof String && newText instanceof String) {
            String sourceTxt = sourceText.toString();
            String newTxt = newText.toString();
            String updTxt = this.paragraph.getTextContent().replaceFirst(sourceTxt, newTxt);
            if (!updTxt.equals(this.paragraph.getTextContent())) {
                this.paragraph.setTextContent(updTxt);
                return true;
            }
            return false;
        }
        throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextAll(Object sourceText, Object newText) {
        if (sourceText instanceof String && newText instanceof String) {
            String sourceTxt = sourceText.toString();
            String newTxt = newText.toString();
            String updTxt = this.paragraph.getTextContent().replaceAll(sourceTxt, newTxt);
            if (!updTxt.equals(this.paragraph.getTextContent())) {
                this.paragraph.setTextContent(updTxt);
                return true;
            }
            return false;
        }
        throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
    }

    @SmartScriptableObject.PropertyTag
    public int getIndex() throws Exception {
        int parIndex = 0;
        for (Node node = this.odtDocument.textDocument.getContentRoot().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof OdfTextParagraph && this.paragraph.equals((Object)((OdfTextParagraph)node))) {
                return parIndex - 1;
            }
            ++parIndex;
        }
        return -1;
    }
}

