/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.word;

import inform.agent.scripts.textdocuments.word.WordDocument;
import inform.common.SmartScriptableObject;
import java.awt.Color;

public class WordFont
extends SmartScriptableObject {
    WordDocument wordDocument;
    private boolean isBold;
    private boolean isCapitalized;
    private boolean isItalic;
    private String fontFamily;
    private int fontSize;
    private String color;
    private int underlinePattern;
    private String underlineColor;
    private boolean isStrikeThrough;
    private String textHighlightColor;
    private boolean isVanish;

    public WordFont(WordDocument document) {
        this.setParentScope(document);
        this.wordDocument = document;
    }

    public WordFont(WordDocument document, WordFont font) {
        this.setParentScope(document);
        this.wordDocument = document;
        if (font != null) {
            this.cloneFontFrom(font);
        }
    }

    @Override
    public String getClassName() {
        return "WordFont";
    }

    @SmartScriptableObject.PropertyTag
    public boolean getBold() {
        return this.isBold;
    }

    @SmartScriptableObject.FunctionTag
    public void setBold(boolean value) {
        this.isBold = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsCapitalized() {
        return this.isCapitalized;
    }

    @SmartScriptableObject.FunctionTag
    public void setCapitalized(boolean value) {
        this.isCapitalized = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsItalic() {
        return this.isItalic;
    }

    @SmartScriptableObject.FunctionTag
    public void setItalic(boolean value) {
        this.isItalic = value;
    }

    @SmartScriptableObject.PropertyTag
    public String getFontFamily() {
        return this.fontFamily;
    }

    @SmartScriptableObject.FunctionTag
    public void setFontFamily(String value) {
        this.fontFamily = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getFontSize() {
        return this.fontSize;
    }

    @SmartScriptableObject.FunctionTag
    public void setFontSize(int value) {
        this.fontSize = value;
    }

    @SmartScriptableObject.PropertyTag
    public String getColor() {
        return this.color;
    }

    @SmartScriptableObject.FunctionTag
    public void setColor(Object value) {
        org.odftoolkit.odfdom.type.Color color = WordDocument.parseColor(value);
        Color awtColor = color.getAWTColor();
        this.color = String.format("%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    @SmartScriptableObject.PropertyTag
    public int getUnderline() {
        return this.underlinePattern;
    }

    @SmartScriptableObject.FunctionTag
    public void setUnderline(int value) {
        this.underlinePattern = value;
    }

    @SmartScriptableObject.PropertyTag
    public String getUnderlineColor() {
        return this.underlineColor;
    }

    @SmartScriptableObject.FunctionTag
    public void setUnderlineColor(Object value) {
        org.odftoolkit.odfdom.type.Color color = WordDocument.parseColor(value);
        Color awtColor = color.getAWTColor();
        this.underlineColor = String.format("%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsStrikeThrough() {
        return this.isStrikeThrough;
    }

    @SmartScriptableObject.FunctionTag
    public void setStrikeThrough(boolean value) {
        this.isStrikeThrough = value;
    }

    @SmartScriptableObject.PropertyTag
    public String getTextHighlightColor() {
        return this.textHighlightColor;
    }

    @SmartScriptableObject.FunctionTag
    public void setTextHighlightColor(String value) {
        this.textHighlightColor = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsVanish() {
        return this.isVanish;
    }

    @SmartScriptableObject.FunctionTag
    public void setVanish(boolean value) {
        this.isVanish = value;
    }

    private void cloneFontFrom(WordFont font) {
        if (font != null) {
            this.setBold(font.getBold());
            this.setCapitalized(font.getIsCapitalized());
            this.setItalic(font.getIsItalic());
            this.setFontFamily(font.getFontFamily());
            this.setFontSize(font.getFontSize());
            this.setColor(font.getColor());
            if (font.getUnderline() > 0 && font.getUnderline() < 19) {
                this.setUnderline(font.getUnderline());
            }
            this.setUnderlineColor(font.getUnderlineColor());
            this.setStrikeThrough(font.getIsStrikeThrough());
            this.setTextHighlightColor(font.getTextHighlightColor());
            this.setVanish(font.getIsVanish());
        }
    }
}

