/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.word;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.textdocuments.word.WordDocument;
import inform.agent.scripts.textdocuments.word.WordFont;
import inform.agent.scripts.textdocuments.word.WordStyle;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.mozilla.javascript.Undefined;

public class WordParagraph
extends SmartScriptableObject {
    private static final String MESSAGE_CREATEPARAGRAPH_ERROR = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444";
    private static final String MESSAGE_CREATECURSOR_ERROR = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441 \u0442\u0430\u043a\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0435\u0439 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435";
    private static final String MESSAGE_BADINDEX_ERROR = "\u0417\u0430\u0434\u0430\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441";
    private static final String MESSAGE_BADPARAMETRS = "\u0412\u0432\u0435\u0434\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b";
    private static final String MESSAGE_EMPTYBINARY = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
    private static final String MESSAGE_UNKNOWNFILE = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438";
    private static final String MESSAGE_UNKNOWNCONTENT = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private final WordDocument wordDocument;
    XWPFParagraph paragraph;
    WordStyle paragraphStyle;

    private WordParagraph(WordDocument wordDocument) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
    }

    private WordParagraph(WordDocument wordDocument, WordStyle paragraphStyle) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
        if (paragraphStyle != null) {
            this.paragraphStyle = paragraphStyle;
        }
    }

    public WordParagraph(WordDocument wordDocument, XWPFParagraph paragraph) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
        this.paragraph = paragraph;
    }

    @Override
    public String getClassName() {
        return "WordParagraph";
    }

    @SmartScriptableObject.PropertyTag
    public int getType() {
        return 1;
    }

    public static WordParagraph insert(WordDocument wordDocument, int index, WordStyle paragraphStyle) throws Exception {
        IBodyElement element;
        WordParagraph wordParagraph = new WordParagraph(wordDocument, paragraphStyle);
        List bodyElements = wordDocument.document.getBodyElements();
        if (index < 0) {
            throw new InformException(String.format(MESSAGE_BADINDEX_ERROR, new Object[0]));
        }
        if (index >= bodyElements.size()) {
            int lastIndex = bodyElements.size() - 1;
            element = (IBodyElement)bodyElements.get(lastIndex);
        } else {
            element = (IBodyElement)bodyElements.get(index);
        }
        XmlCursor cursor = null;
        if (element instanceof XWPFParagraph) {
            XWPFParagraph par = (XWPFParagraph)element;
            cursor = par.getCTP().newCursor();
        } else if (element instanceof XWPFTable) {
            XWPFTable table = (XWPFTable)element;
            cursor = table.getCTTbl().newCursor();
        }
        if (cursor == null) {
            throw new InformException(String.format(MESSAGE_CREATECURSOR_ERROR, new Object[0]));
        }
        if (index >= bodyElements.size()) {
            cursor.toNextSibling();
        }
        wordParagraph.paragraph = wordDocument.document.insertNewParagraph(cursor);
        wordParagraph.applyStyleToParagraph(wordParagraph.paragraph, paragraphStyle);
        if (wordParagraph.paragraph == null) {
            throw new InformException(String.format(MESSAGE_CREATEPARAGRAPH_ERROR, new Object[0]));
        }
        return wordParagraph;
    }

    @SmartScriptableObject.FunctionTag
    public void add(Object content, WordStyle wordStyle, int pictureType, Object width, Object height) throws Exception {
        XWPFRun run = this.paragraph.createRun();
        if (content instanceof String && pictureType == 0 && width instanceof Undefined && height instanceof Undefined) {
            run.setText((String)content);
        } else {
            int pt;
            InputStream is = null;
            if (content instanceof BinaryObject) {
                BinaryObject binary = (BinaryObject)content;
                if (binary.getSize() == 0) {
                    throw new InformException(MESSAGE_EMPTYBINARY);
                }
                is = new ByteArrayInputStream(binary.getInternalBuffer());
            } else if (content instanceof String) {
                File file = Core.mountfs.resolve(new File(content.toString()));
                if (!file.exists()) {
                    throw new InformException(String.format(MESSAGE_MISSINGFILE, content.toString()));
                }
                is = new FileInputStream(file);
            } else if (content instanceof DatasourceField) {
                DatasourceField field = (DatasourceField)content;
                if (field.getIsNull()) {
                    throw new InformException(MESSAGE_EMPTYFIELD);
                }
                switch (field.getDataType()) {
                    case BLOB: {
                        if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                            throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                        }
                        BinaryObject binary = field.getAsBinary();
                        assert (binary != null);
                        is = new ByteArrayInputStream(binary.getInternalBuffer());
                        break;
                    }
                    case FILE: {
                        is = ((BlobFileField)field).openFileStream();
                        break;
                    }
                    default: {
                        throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
                    }
                }
            } else {
                throw new InformException(MESSAGE_UNKNOWNCONTENT);
            }
            assert (is != null);
            switch (pictureType) {
                case 1: {
                    pt = Document.PICTURE_TYPE_PNG;
                    break;
                }
                case 2: {
                    pt = Document.PICTURE_TYPE_JPEG;
                    break;
                }
                default: {
                    throw new InformException(MESSAGE_UNKNOWNFILE);
                }
            }
            if (width instanceof Number && height instanceof Number) {
                run.addPicture(is, pt, "", Units.toEMU((double)((Number)width).intValue()), Units.toEMU((double)((Number)height).intValue()));
            } else {
                throw new InformException(MESSAGE_BADPARAMETRS);
            }
        }
        if (wordStyle != null) {
            this.applyStyleToRun(run, wordStyle);
        } else if (this.paragraphStyle != null && this.paragraphStyle.getFont() != null) {
            this.applyStyleToRun(run, this.paragraphStyle);
        }
    }

    @SmartScriptableObject.FunctionTag
    public void addTab() {
        XWPFRun run = this.paragraph.createRun();
        run.addTab();
    }

    @SmartScriptableObject.FunctionTag
    public void clear() {
        List runs = this.paragraph.getRuns();
        if (runs != null) {
            for (int i = 0; i < runs.size(); ++i) {
                this.paragraph.removeRun(i);
            }
        }
    }

    private void applyStyleToRun(XWPFRun run, WordStyle style) throws Exception {
        if (style.getFont() != null) {
            WordFont font = style.getFont();
            run.setBold(font.getBold());
            run.setCapitalized(font.getIsCapitalized());
            run.setItalic(font.getIsItalic());
            run.setFontFamily(font.getFontFamily());
            run.setFontSize(font.getFontSize());
            run.setColor(font.getColor());
            if (font.getUnderline() > 0 && font.getUnderline() < 19) {
                run.setUnderline(UnderlinePatterns.valueOf((int)font.getUnderline()));
                run.setUnderlineColor(font.getUnderlineColor());
            }
            run.setStrikeThrough(font.getIsStrikeThrough());
            run.setTextHighlightColor(font.getTextHighlightColor());
            run.setVanish(font.getIsVanish());
        }
    }

    private void applyStyleToParagraph(XWPFParagraph paragraph, WordStyle style) throws Exception {
        if (style != null) {
            if (style.getParagraphAlignment() > 0 && style.getParagraphAlignment() < 13) {
                paragraph.setAlignment(ParagraphAlignment.valueOf((int)style.getParagraphAlignment()));
            }
            paragraph.setIndentationLeft(style.getIndentationLeft());
            paragraph.setIndentationRight(style.getIndentationRight());
            if (style.getSpacingBetween() > 0.0) {
                paragraph.setSpacingBetween(style.getSpacingBetween());
            }
            paragraph.setSpacingBefore(style.getSpacingBefore());
            paragraph.setSpacingAfter(style.getSpacingAfter());
        }
    }

    public static boolean replaceTextInParagraph(String sourceText, String newText, XWPFParagraph paragraph, boolean all) {
        List runs = paragraph.getRuns();
        boolean success = false;
        if (runs != null) {
            for (XWPFRun run : runs) {
                String runText = run.getText(0);
                if (runText == null || !runText.contains(sourceText)) continue;
                runText = all ? runText.replace(sourceText, newText) : runText.replaceFirst(sourceText, newText);
                run.setText(runText, 0);
                if (!runText.equals(sourceText) && !all) {
                    return true;
                }
                if (!all) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceText(Object sourceText, Object newText) {
        if (sourceText instanceof String && newText instanceof String) {
            String sourceTxt = sourceText.toString();
            String newTxt = newText.toString();
            List runs = this.paragraph.getRuns();
            boolean success = false;
            if (runs != null) {
                for (XWPFRun run : runs) {
                    String runText = run.getText(0);
                    if (runText == null || !runText.contains(sourceTxt)) continue;
                    runText = runText.replaceFirst(sourceTxt, newTxt);
                    run.setText(runText, 0);
                    if (runText.equals(sourceTxt)) continue;
                    return true;
                }
                return success;
            }
            return false;
        }
        throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
    }

    @SmartScriptableObject.FunctionTag
    public boolean replaceTextAll(Object sourceText, Object newText) {
        if (sourceText instanceof String && newText instanceof String) {
            String sourceTxt = sourceText.toString();
            String newTxt = newText.toString();
            List runs = this.paragraph.getRuns();
            boolean success = false;
            if (runs != null) {
                for (XWPFRun run : runs) {
                    String runText = run.getText(0);
                    if (runText == null || !runText.contains(sourceTxt)) continue;
                    runText = runText.replace(sourceTxt, newTxt);
                    run.setText(runText, 0);
                    success = true;
                }
                return success;
            }
            return false;
        }
        throw new InformException(String.format(MESSAGE_BADPARAMETRS, new Object[0]));
    }

    @SmartScriptableObject.PropertyTag
    public int getIndex() {
        List bodyElements = this.wordDocument.document.getBodyElements();
        int index = 0;
        for (IBodyElement element : bodyElements) {
            if (element instanceof XWPFParagraph && element.equals(this.paragraph)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

