/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.textdocuments.word;

import inform.agent.scripts.textdocuments.word.WordDocument;
import inform.agent.scripts.textdocuments.word.WordFont;
import inform.common.SmartScriptableObject;

public class WordStyle
extends SmartScriptableObject {
    private final WordDocument wordDocument;
    private WordFont font;
    private int paragraphAlignment;
    private int indentationLeft;
    private int indentationRight;
    private double spacingBetween;
    private int spacingBefore;
    private int spacingAfter;

    @SmartScriptableObject.PropertyTag
    public int getParagraphAlignment() {
        return this.paragraphAlignment;
    }

    @SmartScriptableObject.FunctionTag
    public void setParagraphAlignment(int value) {
        this.paragraphAlignment = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getIndentationLeft() {
        return this.indentationLeft;
    }

    @SmartScriptableObject.FunctionTag
    public void setIndentationLeft(int value) {
        this.indentationLeft = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getIndentationRight() {
        return this.indentationRight;
    }

    @SmartScriptableObject.FunctionTag
    public void setIndentationRight(int value) {
        this.indentationRight = value;
    }

    @SmartScriptableObject.PropertyTag
    public double getSpacingBetween() {
        return this.spacingBetween;
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingBetween(double value) {
        this.spacingBetween = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getSpacingBefore() {
        return this.spacingBefore;
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingBefore(int value) {
        this.spacingBefore = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getSpacingAfter() {
        return this.spacingAfter;
    }

    @SmartScriptableObject.FunctionTag
    public void setSpacingAfter(int value) {
        this.spacingAfter = value;
    }

    @SmartScriptableObject.FunctionTag
    public void setFont(WordFont font) {
        this.font = font;
    }

    @SmartScriptableObject.PropertyTag
    public WordFont getFont() {
        return this.font;
    }

    public WordStyle(WordDocument wordDocument) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
    }

    public WordStyle(WordDocument wordDocument, WordStyle style) {
        this.setParentScope(wordDocument);
        this.wordDocument = wordDocument;
        if (style != null) {
            this.cloneStyleFrom(style);
        }
    }

    @Override
    public String getClassName() {
        return "WordStyle";
    }

    private void cloneStyleFrom(WordStyle style) {
        if (style != null) {
            if (style.getFont() != null) {
                this.setFont(style.getFont());
            }
            if (style.getParagraphAlignment() > 0 && style.getParagraphAlignment() < 13) {
                this.setParagraphAlignment(style.getParagraphAlignment());
            }
            this.setIndentationLeft(style.getIndentationLeft());
            this.setIndentationRight(style.getIndentationRight());
            if (style.getSpacingBetween() > 0.0) {
                this.setSpacingBetween(style.getSpacingBetween());
            }
            this.setSpacingBefore(style.getSpacingBefore());
            this.setSpacingAfter(style.getSpacingAfter());
        }
    }
}

