/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.common.SmartScriptableObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class GZipReader
extends SmartScriptableObject {
    private final String _sourceGZipFile;
    private String _comment = "";
    private String _name = "";
    private final FileInputStream _fis;
    private final GZIPInputStreamExt _gis;

    public GZipReader(String fileName) throws IOException, InformException {
        this._sourceGZipFile = Core.mountfs.resolvePath(fileName);
        this._name = new File(fileName).getName();
        int pos = this._name.lastIndexOf(".");
        if (pos > 0) {
            this._name = this._name.substring(0, pos);
        }
        this._fis = new FileInputStream(this._sourceGZipFile);
        this._gis = new GZIPInputStreamExt(this._fis);
        if (!this._gis.name.isEmpty()) {
            this._name = this._gis.name;
        }
        if (!this._gis.comment.isEmpty()) {
            this._comment = this._gis.comment;
        }
    }

    @Override
    public String getClassName() {
        return "GZipReader";
    }

    @SmartScriptableObject.PropertyTag
    public String getcomment() {
        return this._comment;
    }

    @SmartScriptableObject.PropertyTag
    public String getname() {
        return this._name;
    }

    @SmartScriptableObject.FunctionTag
    public void saveToFile(String targetFile) throws IOException, InformException {
        try (FileOutputStream fos = new FileOutputStream(Core.mountfs.resolvePath(targetFile));){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = this._gis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getasBinary() throws IOException, InformException {
        BufferedInputStream bis = new BufferedInputStream(this._gis);
        BinaryObject binary = new BinaryObject();
        binary.loadFromStream(bis);
        return binary;
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(BlobField field) throws Exception, InformException {
        if (field == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u043f\u0443\u0441\u0442\u043e\u0435 \u043f\u043e\u043b\u0435!");
        }
        BufferedInputStream bis = new BufferedInputStream(this._gis);
        BinaryObject binary = new BinaryObject();
        binary.loadFromStream(bis);
        field.assign(binary);
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws Exception, InformException {
        this._gis.close();
        this._fis.close();
    }

    private class GZIPInputStreamExt
    extends InflaterInputStream {
        protected CRC32 crc;
        protected boolean eos;
        private boolean closed;
        public String comment;
        public String name;
        public static final int GZIP_MAGIC = 35615;
        private static final int FTEXT = 1;
        private static final int FHCRC = 2;
        private static final int FEXTRA = 4;
        private static final int FNAME = 8;
        private static final int FCOMMENT = 16;
        private byte[] tmpbuf;

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        public GZIPInputStreamExt(InputStream in) throws IOException {
            super(in);
            this.crc = new CRC32();
            this.closed = false;
            this.comment = "";
            this.name = "";
            this.tmpbuf = new byte[128];
            this.inf = new Inflater(true);
            this.readHeader(in);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            this.ensureOpen();
            if (this.eos) {
                return -1;
            }
            int n = super.read(buf, off, len);
            if (n == -1) {
                if (!this.readTrailer()) return this.read(buf, off, len);
                this.eos = true;
                return n;
            } else {
                this.crc.update(buf, off, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                super.close();
                this.eos = true;
                this.closed = true;
            }
        }

        private int readHeader(InputStream this_in) throws IOException {
            int buff;
            boolean isNull;
            int i;
            byte[] bytes;
            int MAX_BUF_SIZE;
            CheckedInputStream in = new CheckedInputStream(this_in, this.crc);
            this.crc.reset();
            if (this.readUShort(in) != 35615) {
                throw new ZipException("Not in GZIP format");
            }
            if (this.readUByte(in) != 8) {
                throw new ZipException("Unsupported compression method");
            }
            int flg = this.readUByte(in);
            this.skipBytes(in, 6);
            int n = 10;
            if ((flg & 4) == 4) {
                int m = this.readUShort(in);
                this.skipBytes(in, m);
                n += m + 2;
            }
            if ((flg & 8) == 8) {
                MAX_BUF_SIZE = 256;
                bytes = new byte[MAX_BUF_SIZE];
                i = 0;
                do {
                    buff = this.readUByte(in);
                    if (i < MAX_BUF_SIZE) {
                        bytes[i] = (byte)buff;
                    }
                    ++i;
                    isNull = buff == 0;
                    ++n;
                } while (!isNull);
                if (i > MAX_BUF_SIZE) {
                    i = MAX_BUF_SIZE;
                }
                GZipReader.this._name = new String(Arrays.copyOfRange(bytes, 0, i), "WINDOWS-1251");
            }
            if ((flg & 0x10) == 16) {
                MAX_BUF_SIZE = 512;
                bytes = new byte[MAX_BUF_SIZE];
                i = 0;
                do {
                    buff = this.readUByte(in);
                    if (i < MAX_BUF_SIZE) {
                        bytes[i] = (byte)buff;
                    }
                    ++i;
                    isNull = buff == 0;
                    ++n;
                } while (!isNull);
                if (i > MAX_BUF_SIZE) {
                    i = MAX_BUF_SIZE;
                }
                GZipReader.this._comment = new String(Arrays.copyOfRange(bytes, 0, i), "WINDOWS-1251");
            }
            if ((flg & 2) == 2) {
                int v = (int)this.crc.getValue() & 0xFFFF;
                if (this.readUShort(in) != v) {
                    throw new ZipException("Corrupt GZIP header");
                }
                n += 2;
            }
            this.crc.reset();
            return n;
        }

        private boolean readTrailer() throws IOException {
            InputStream in = this.in;
            int n = this.inf.getRemaining();
            if (n > 0) {
                in = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            if (this.readUInt(in) != this.crc.getValue() || this.readUInt(in) != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
                throw new ZipException("Corrupt GZIP trailer");
            }
            if (this.in.available() > 0 || n > 26) {
                int m = 8;
                try {
                }
                catch (IOException ze) {
                    Core.logger.error(null, ze);
                    return true;
                }
                this.inf.reset();
                if (n > (m += this.readHeader(in))) {
                    this.inf.setInput(this.buf, this.len - n + m, n - m);
                }
                return false;
            }
            return true;
        }

        private long readUInt(InputStream in) throws IOException {
            long s = this.readUShort(in);
            return (long)this.readUShort(in) << 16 | s;
        }

        private int readUShort(InputStream in) throws IOException {
            int b = this.readUByte(in);
            return this.readUByte(in) << 8 | b;
        }

        private int readUByte(InputStream in) throws IOException {
            int b = in.read();
            if (b == -1) {
                throw new EOFException();
            }
            if (b < -1 || b > 255) {
                throw new IOException(this.in.getClass().getName() + ".read() returned value out of range -1..255: " + b);
            }
            return b;
        }

        private void skipBytes(InputStream in, int n) throws IOException {
            while (n > 0) {
                int len = in.read(this.tmpbuf, 0, n < this.tmpbuf.length ? n : this.tmpbuf.length);
                if (len == -1) {
                    throw new EOFException();
                }
                n -= len;
            }
        }
    }
}

