/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.common.SmartScriptableObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZipWriter
extends SmartScriptableObject {
    private final String _targetGZipFile;
    private final GZIPOutputStreamExt _gzipOS;
    private final FileOutputStream _fos;
    private boolean _isWriterFixed;
    private String _comment;
    private String _name;

    public GZipWriter(String targetGZipFile) throws IOException, InformException {
        this._targetGZipFile = Core.mountfs.resolvePath(targetGZipFile);
        this._fos = new FileOutputStream(this._targetGZipFile);
        this._gzipOS = new GZIPOutputStreamExt(this._fos);
        this._isWriterFixed = false;
        this._comment = "";
        this._name = "";
    }

    @Override
    public String getClassName() {
        return "GZipWriter";
    }

    @SmartScriptableObject.PropertyTag
    public String getcomment() {
        return this._comment;
    }

    public void setcomment(String comment) throws InformException, UnsupportedEncodingException {
        if (this._isWriterFixed) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430 \u0432 \u0430\u0440\u0445\u0438\u0432!");
        }
        this._comment = comment;
        this._gzipOS.comment = comment;
    }

    @SmartScriptableObject.PropertyTag
    public String getname() {
        return this._name;
    }

    public void setname(String name) throws InformException, UnsupportedEncodingException {
        if (this._isWriterFixed) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430 \u0432 \u0430\u0440\u0445\u0438\u0432!");
        }
        this._name = name;
        this._gzipOS.name = name;
    }

    @SmartScriptableObject.FunctionTag
    public void writeFromFile(String sourceFile) throws IOException, InformException {
        String fileName = Core.mountfs.resolvePath(sourceFile);
        if (this._name.isEmpty()) {
            this.setname(new File(fileName).getName());
        }
        try (FileInputStream fis = new FileInputStream(fileName);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                this._gzipOS.write(buffer, 0, len);
            }
        }
        this._isWriterFixed = true;
    }

    @SmartScriptableObject.FunctionTag
    public void writeFromBinary(BinaryObject binary) throws IOException, InformException {
        if (binary == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        try (InputStream is = BinaryObject.toInputStream(binary);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                this._gzipOS.write(buffer, 0, len);
            }
        }
        this._isWriterFixed = true;
    }

    @SmartScriptableObject.FunctionTag
    public void writeFromBlob(BlobField field) throws Exception {
        if (field == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f!");
        }
        this.writeFromBinary(field.getAsBinary());
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException, InformException {
        this._gzipOS.close();
        this._fos.close();
        this._isWriterFixed = true;
    }

    private class GZIPOutputStreamExt
    extends DeflaterOutputStream {
        protected CRC32 crc;
        private static final int GZIP_MAGIC = 35615;
        private static final int TRAILER_SIZE = 8;
        private static final int FNAME = 8;
        private static final int FCOMMENT = 16;
        private boolean isHeaderWrited;
        public String comment;
        public String name;

        public GZIPOutputStreamExt(OutputStream out) throws IOException {
            super(out, false);
            this.crc = new CRC32();
            this.comment = "";
            this.name = "";
            this.def = new Deflater(-1, true);
            this.isHeaderWrited = false;
            this.crc.reset();
        }

        private void writeHeader() throws IOException {
            if (this.isHeaderWrited) {
                return;
            }
            byte flag = 0;
            if (!this.name.isEmpty()) {
                flag = (byte)(flag | 8);
            }
            if (!this.comment.isEmpty()) {
                flag = (byte)(flag | 0x10);
            }
            this.out.write(new byte[]{31, -117, 8, flag, 0, 0, 0, 0, 0, 0});
            if (!this.name.isEmpty()) {
                this.out.write(this.name.getBytes("WINDOWS-1251"));
                this.out.write(0);
            }
            if (!this.comment.isEmpty()) {
                this.out.write(this.comment.getBytes("WINDOWS-1251"));
                this.out.write(0);
            }
            this.isHeaderWrited = true;
        }

        @Override
        public synchronized void write(byte[] buf, int off, int len) throws IOException {
            if (!this.isHeaderWrited) {
                this.writeHeader();
            }
            super.write(buf, off, len);
            this.crc.update(buf, off, len);
        }

        @Override
        public void finish() throws IOException {
            if (!this.isHeaderWrited) {
                this.writeHeader();
            }
            if (!this.def.finished()) {
                this.def.finish();
                while (!this.def.finished()) {
                    int len = this.def.deflate(this.buf, 0, this.buf.length);
                    if (this.def.finished() && len <= this.buf.length - 8) {
                        this.writeTrailer(this.buf, len);
                        this.out.write(this.buf, 0, len += 8);
                        return;
                    }
                    if (len <= 0) continue;
                    this.out.write(this.buf, 0, len);
                }
                byte[] trailer = new byte[8];
                this.writeTrailer(trailer, 0);
                this.out.write(trailer);
            }
        }

        private void writeTrailer(byte[] buf, int offset) throws IOException {
            this.writeInt((int)this.crc.getValue(), buf, offset);
            this.writeInt(this.def.getTotalIn(), buf, offset + 4);
        }

        private void writeInt(int i, byte[] buf, int offset) throws IOException {
            this.writeShort(i & 0xFFFF, buf, offset);
            this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
        }

        private void writeShort(int s, byte[] buf, int offset) throws IOException {
            buf[offset] = (byte)(s & 0xFF);
            buf[offset + 1] = (byte)(s >> 8 & 0xFF);
        }
    }
}

