/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.zip.ZipWriterEntry;
import inform.common.SmartScriptableObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipReaderEntry
extends ZipWriterEntry {
    private final ZipFile _zipFile;

    public ZipReaderEntry(ZipEntry entry, ZipFile zipFile) throws IOException {
        super(entry);
        this._canModified = false;
        this._zipFile = zipFile;
    }

    @Override
    public String getClassName() {
        return "ZipReaderEntry";
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getasBinary() throws IOException, InformException {
        BufferedInputStream bis = new BufferedInputStream(this._zipFile.getInputStream(this._entry));
        BinaryObject binary = new BinaryObject();
        binary.loadFromStream(bis);
        return binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public void saveToFile(String fileName) throws IOException, InformException {
        block8: {
            try {
                byte[] buf = new byte[1024];
                if (this._entry == null) break block8;
                File newFile = new File(Core.mountfs.resolvePath(fileName));
                File dir = newFile.getParentFile();
                if (dir != null) {
                    dir.mkdirs();
                }
                if (this._entry.isDirectory()) {
                    newFile.mkdirs();
                    return;
                }
                InputStream is = this._zipFile.getInputStream(this._entry);
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int n;
                    while ((n = is.read(buf, 0, 1024)) > -1) {
                        fos.write(buf, 0, n);
                    }
                }
            }
            catch (Exception e) {
                throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430!");
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(DatasourceField field) throws Exception, InformException {
        if (field == null) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u043f\u0443\u0441\u0442\u043e\u0435 \u043f\u043e\u043b\u0435!");
        }
        BufferedInputStream bis = new BufferedInputStream(this._zipFile.getInputStream(this._entry));
        BinaryObject binary = new BinaryObject();
        binary.loadFromStream(bis);
        field.setAsBinary(binary);
    }
}

