/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.Core;
import inform.agent.web.AsmoServlet;
import inform.agent.web.FutureInfo;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import java.io.PrintWriter;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncTaskServlet
extends AsmoServlet {
    public AsyncTaskServlet() {
        super(AsmoServlet.Type.JSON);
    }

    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        resp.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
        PrintWriter w = resp.getWriter();
        String asyncId = null;
        try {
            String[] path = req.getPathInfo().split("/");
            asyncId = path[1];
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            w.append(JSON.mkError("NOTFOUND"));
            return;
        }
        resp.setCharacterEncoding("UTF-8");
        Session session = (Session)req.getSession();
        if (session == null || null == asyncId) {
            w.append(JSON.mkError("NOTFOUND"));
            return;
        }
        Future<Object> f = session.store().get(asyncId, Object.class);
        if (f == null) {
            w.append(JSON.mkError("NOTFOUND"));
        } else {
            String changes;
            if (req.getParameter("cancel") != null) {
                f.cancel(true);
            }
            String string = changes = f instanceof FutureInfo ? ((FutureInfo)((Object)f)).poolJSON() : "";
            if (f.isDone()) {
                if (f.isCancelled()) {
                    w.append("{\"error\":\"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e\",\"changes\":[").append(changes).append("]}");
                } else {
                    try {
                        f.get();
                        w.append("{\"state\":\"DONE\",\"changes\":[").append(changes).append("]}");
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                        w.append("{\"error\":").append(JSON.toString(e)).append(",\"changes\":[").append(changes).append("]}");
                    }
                }
            } else {
                w.append("{\"state\":\"RUNNING\",\"changes\":[").append(changes).append("]}");
            }
        }
        w.flush();
    }
}

