/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class ConfigurationNode {
    private static final int TAG_TOPIC_NAME = 1;
    private static final int TAG_TOPIC_VALUE = 2;
    private static final int TAG_TOPIC_NODE_ID = 3;
    private final double id;
    private final Collection<Topic> topics = new ArrayList<Topic>(1);

    private ConfigurationNode(double id, byte[] content) throws IOException {
        this.id = id;
        if (content != null && content.length != 0) {
            TaggedReader reader = new TaggedReader(content);
            String name = null;
            double node = 0.0;
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        name = reader.getAnsi();
                        break;
                    }
                    case 3: {
                        node = reader.getDouble();
                        break;
                    }
                    case 2: {
                        this.topics.add(new Topic(name, node, reader.getRaw()));
                        name = null;
                        node = 0.0;
                    }
                }
            }
        }
    }

    public byte[] topic(double node, String name) {
        for (Topic t : this.topics) {
            if (t.node != node || !name.equals(t.name)) continue;
            return t.value;
        }
        return null;
    }

    public Folder folder(double node, String name) {
        for (Topic t : this.topics) {
            if (t.node != node || !name.equals(t.name)) continue;
            return t.folder();
        }
        Topic t = new Topic(name, node, Empty.byteArray);
        this.topics.add(t);
        return t.folder();
    }

    private void store(TaggedWriter writer) throws IOException {
        for (Topic t : this.topics) {
            byte[] value;
            writer.putAnsi(1, t.name);
            writer.putDouble(3, t.node);
            Folder f = t._folder;
            if (f != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                f.store(out);
                t.value = value = out.toByteArray();
            } else {
                value = t.value;
            }
            writer.putRaw(2, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationNode load(double user, String name) throws SQLException, IOException {
        byte[] content = null;
        double id = 0.0;
        try (Connector.Metabase db = new Connector.Metabase();
             PreparedStatement ps = db.connection().prepareStatement("ConfigurationNode.load(user,name)", "SELECT id, conf_content FROM mtd_conf_nodes WHERE conf_user=? AND conf_name=?");){
            ps.setDouble(1, user);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery(null);){
                if (rs.next()) {
                    id = rs.getDouble(1);
                    content = rs.getBlobBytes(2);
                }
            }
        }
        if (content == null) {
            content = Empty.byteArray;
        }
        if (id == 0.0) {
            id = Core.generateId();
        }
        return new ConfigurationNode(id, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(ConfigurationNode conf, double user, String name) throws SQLException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        conf.store(new TaggedWriter(out));
        out.flush();
        try (Connector.Metabase db = new Connector.Metabase();){
            int uc;
            try (PreparedStatement ps = db.connection().prepareStatement("ConfigurationNode.store(user,name)", "UPDATE mtd_conf_nodes SET conf_content=? WHERE conf_user=? AND conf_name=?");){
                ps.setBlob(1, out.internalBuffer(), out.size());
                ps.setDouble(2, user);
                ps.setString(3, name);
                uc = ps.executeUpdate(null);
            }
            if (uc == 0) {
                ps = db.connection().prepareStatement("ConfigurationNode.store(user,name)", "INSERT INTO mtd_conf_nodes(id,conf_user,conf_name,conf_content) VALUES(?,?,?,?)");
                try {
                    ps.setDouble(1, conf.id);
                    ps.setDouble(2, user);
                    ps.setString(3, name);
                    ps.setBlob(4, out.internalBuffer(), out.size());
                    ps.executeUpdate(null);
                }
                finally {
                    ps.close();
                }
            }
            db.commit();
        }
    }

    public static class Topic {
        final String name;
        final double node;
        private byte[] value;
        private Folder _folder;

        Topic(String name, double node, byte[] value) {
            this.name = name;
            this.node = node;
            this.value = value;
        }

        Folder folder() {
            Folder f = this._folder;
            if (f == null) {
                this._folder = f = new Folder(this.value);
            }
            return f;
        }
    }

    public static class Folder {
        private static final int TAG_CONF_NODE = 1;
        private final DoubleHash<Item> items = new DoubleHash();

        private Folder(byte[] data) {
            if (data != null && data.length != 0) {
                try {
                    TaggedReader reader = new TaggedReader(data);
                    while (reader.next()) {
                        double id = reader.getDouble(1);
                        byte[] raw = reader.getRaw(202);
                        this.items.add(new Item(id, raw));
                    }
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
            }
        }

        private void store(ByteArrayOutputStream out) throws IOException {
            if (this.items.empty()) {
                return;
            }
            TaggedWriter writer = new TaggedWriter(out);
            for (Item i : this.items) {
                writer.putDouble(1, i.id);
                writer.putRaw(202, i.data);
            }
            writer.flush();
        }

        public byte[] content(double id) {
            Item i = this.items.get(id);
            return i == null ? null : i.data;
        }

        public void content(double id, byte[] data) {
            Item i = this.items.get(id);
            if (i == null) {
                i = new Item(id, data);
                this.items.add(i);
            } else {
                i.data = data;
            }
        }

        private static class Item
        implements DoubleHash.Entry {
            final double id;
            byte[] data;

            Item(double id, byte[] data) {
                this.id = id;
                this.data = data;
            }

            @Override
            public double key() {
                return this.id;
            }
        }
    }
}

