/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.web.DocumentGeneratorStringBuilder;
import inform.agent.web.utils.ClientFont;
import inform.agent.web.utils.HtmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class DocumentGenerator {
    private final String styleKey;
    private int imageIndex = 0;
    private ArrayList<TextStyle> textStyles = new ArrayList();
    private ArrayList<ParagraphStyle> paragraphStyles = new ArrayList();
    private ArrayList<ListStyle> listStyles = new ArrayList();
    private double styleLib = 0.0;

    public DocumentGenerator(String styleKey) {
        this.styleKey = styleKey;
    }

    public void generate(TaggedReader reader, PrintWriter out, String title) throws IOException, TaggedReaderException, InformException {
        DocumentGeneratorStringBuilder body = new DocumentGeneratorStringBuilder();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.writeDocData(reader.getSubStreamReader(), body);
                    break;
                }
                case 2: {
                    this.readStyles(reader.getSubStreamReader());
                }
            }
        }
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//RU\">");
        out.println("<html>");
        out.println("<head>");
        if (title != null) {
            out.println(String.format("<title>%s</title>", title));
        }
        out.println("<style type='text/css'>");
        this.generateCSS(out);
        out.println("</style>");
        out.println("</head>");
        out.println("<body bgcolor='white'>");
        out.println(body.toString());
        out.println("</body>");
        out.println("</html>");
    }

    private void readStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.readTextStyles(reader.getStreamReader());
                    break;
                }
                case 2: {
                    this.readParagraphStyles(reader.getStreamReader());
                    break;
                }
                case 3: {
                    this.readListStyles(reader.getStreamReader());
                    break;
                }
                case 4: {
                    this.styleLib = reader.getNodeID();
                }
            }
        }
    }

    private void writeDocData(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException, InformException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.writeTextItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 4: {
                    this.writeHypertextItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 9: {
                    break;
                }
                case 3: {
                    this.writePictureItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 6: {
                    this.writeTabItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 8: {
                    this.writePageBreakItem(dest);
                    break;
                }
                case 7: {
                    this.writeMarkerItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 5: {
                    this.writeTableItem(reader.getSubStreamReader(), dest);
                    break;
                }
                case 10: {
                    this.writeCheckPointItem(reader.getSubStreamReader(), dest);
                }
            }
        }
    }

    private void generateCSS(Appendable out) throws IOException {
        for (TextStyle textStyle : this.textStyles) {
            out.append('.').append(this.getCssTextStyleName(textStyle.id)).append(" {\n");
            textStyle.generate(out);
            out.append("}\n");
        }
        for (ParagraphStyle paragraphStyle : this.paragraphStyles) {
            out.append("p.").append(this.getCssParagraphStyleName(paragraphStyle.id)).append(" {\n");
            paragraphStyle.generate(out);
            out.append("}\n");
        }
    }

    private String getCssTextStyleName(int styleNo) {
        return "ts_" + this.styleKey + "_" + styleNo;
    }

    private String getCssParagraphStyleName(int paraNo) {
        return "ps_" + this.styleKey + "_" + paraNo;
    }

    private void readTextStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        TextStyle style = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    if (style != null) {
                        this.textStyles.add(style);
                    }
                    style = new TextStyle(reader.getInt());
                    break;
                }
                case 1: {
                    style.font.load(reader.getRaw());
                    break;
                }
                case 2: {
                    style.background = reader.getInt();
                    break;
                }
                case 5: {
                    style.subSuperScriptType = reader.getInt();
                    break;
                }
                case 6: {
                    style.libId = reader.getInt();
                    break;
                }
                case 7: {
                    style.jump = true;
                }
            }
        }
        if (style != null) {
            this.textStyles.add(style);
        }
    }

    private void readParagraphStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        ParagraphStyle style = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 9: {
                    if (style != null) {
                        this.paragraphStyles.add(style);
                    }
                    style = new ParagraphStyle(reader.getInt());
                    break;
                }
                case 1: {
                    style.align = reader.getInt();
                    break;
                }
                case 6: {
                    style.firstIndent = reader.getInt();
                    break;
                }
                case 2: {
                    style.leftMargin = reader.getInt();
                    break;
                }
                case 3: {
                    style.rightMargin = reader.getInt();
                    break;
                }
                case 4: {
                    style.topMargin = reader.getInt();
                    break;
                }
                case 5: {
                    style.bottomMargin = reader.getInt();
                    break;
                }
                case 7: {
                    style.lineSpacing = reader.getInt();
                    break;
                }
                case 8: {
                    style.lineSpacingType = reader.getInt();
                    break;
                }
                case 10: {
                    style.libId = reader.getInt();
                }
            }
        }
        if (style != null) {
            this.paragraphStyles.add(style);
        }
    }

    private void readListStyles(TaggedReader reader) throws IOException, TaggedReaderException {
        ListStyle style = null;
        boolean std = false;
        block10: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    if (style != null) {
                        this.listStyles.add(style);
                    }
                    style = new ListStyle(reader.getInt());
                    break;
                }
                case 2: {
                    if (style == null) break;
                    style.name = reader.getAnsi();
                    break;
                }
                case 3: {
                    if (style == null) break;
                    TaggedReader subReader = reader.getStreamReader();
                    ListStyleLevel level = null;
                    while (subReader.getNextTag() != 0) {
                        switch (subReader.getCurrentTag()) {
                            case 1: {
                                level = new ListStyleLevel(subReader.getInt());
                                style.levels.add(level);
                                break;
                            }
                            case 2: {
                                if (level == null) break;
                                level.formatString = subReader.getString();
                            }
                        }
                    }
                    continue block10;
                }
                case 4: {
                    std = true;
                }
            }
        }
        if (style != null) {
            this.listStyles.add(style);
        }
    }

    private void closePrevParagraph(DocumentGeneratorStringBuilder dest) {
        if (dest.isPrgrStarted()) {
            dest.append(dest.getPrgrStarted());
        }
        dest.setPrgrStarted("");
    }

    private void closePrevParagraphAndStartNew(DocumentGeneratorStringBuilder dest, int paraNo) {
        if (dest.isMarkerStarted()) {
            this.closeList(dest);
        }
        this.closePrevParagraph(dest);
        dest.append(String.format("<p class=\"%s\">", this.getCssParagraphStyleName(paraNo)));
        dest.setPrgrStarted("</p>");
    }

    private void closePrevMark(DocumentGeneratorStringBuilder dest) {
        this.closePrevParagraph(dest);
        dest.append("</li>");
        dest.setMarkerStarted(false);
    }

    private void closeList(DocumentGeneratorStringBuilder dest) {
        if (dest.isMarkerStarted()) {
            this.closePrevMark(dest);
        }
        if (!dest.getLastListTag().isEmpty()) {
            dest.append("</").append(dest.getLastListTag()).append(">");
        }
        dest.setLastListTag("");
    }

    private void writeTableData(TaggedReader reader, DocumentGeneratorStringBuilder dest, int tBgColor, int tBrColor) throws IOException, TaggedReaderException, InformException {
        boolean rowStarted = true;
        boolean first = true;
        int prevRowNo = -1;
        int width = -1;
        int height = -1;
        int rowspan = 1;
        int colspan = 1;
        int bgColor = 0x1FFFFFFF;
        int brColor = 0x1FFFFFFF;
        int borders = 0;
        DocumentGeneratorStringBuilder cellData = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    width = -1;
                    height = -1;
                    rowspan = 1;
                    colspan = 1;
                    bgColor = tBgColor;
                    brColor = tBrColor;
                    borders = 0;
                    break;
                }
                case 3: {
                    int tmp = reader.getInt();
                    rowStarted = prevRowNo != tmp;
                    prevRowNo = tmp;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    width = reader.getInt();
                    break;
                }
                case 6: {
                    height = reader.getInt();
                    break;
                }
                case 7: {
                    rowspan = reader.getInt();
                    break;
                }
                case 8: {
                    colspan = reader.getInt();
                    break;
                }
                case 11: {
                    int bg = reader.getInt();
                    if (bg == 0x1FFFFFFF) break;
                    bgColor = bg;
                    break;
                }
                case 12: {
                    int br = reader.getInt();
                    if (br == 0x1FFFFFFF) break;
                    brColor = br;
                    break;
                }
                case 9: {
                    borders = reader.getInt();
                    break;
                }
                case 10: {
                    cellData = new DocumentGeneratorStringBuilder();
                    this.writeDocData(reader.getSubStreamReader(), cellData);
                    break;
                }
                case 2: {
                    if (rowStarted) {
                        dest.append(first ? "" : "</tr>\n").append("<tr>\n");
                    }
                    Object styleStr = String.format("style=\"padding:0px; border-width: 1px; border-style:solid; background-color: %s; border-color: %s;", HtmlUtils.vColor(bgColor), HtmlUtils.vColor(brColor));
                    styleStr = (String)styleStr + ((borders & 0xFF) != 0 ? "border-left-style: solid; border-left-width:1px;" : "border-left-style: hidden;");
                    styleStr = (String)styleStr + ((borders >> 8 & 0xFF) != 0 ? "border-right-style: solid; border-right-width:1px;" : "border-right-style: hidden;");
                    styleStr = (String)styleStr + ((borders >> 16 & 0xFF) != 0 ? "border-top-style: solid; border-top-width:1px;" : "border-top-style: hidden;");
                    styleStr = (String)styleStr + ((borders >> 24 & 0xFF) != 0 ? "border-bottom-style: solid; border-bottom-width:1px;" : "border-bottom-style: hidden;");
                    styleStr = (String)styleStr + "\"";
                    Object whString = "";
                    if (width != 0) {
                        whString = (String)whString + "width=" + width;
                    }
                    if (height != 0) {
                        whString = (String)whString + "height=" + height;
                    }
                    dest.append(String.format("<td %s colspan=%s rowspan=%s %s >%s</td>\n", whString, colspan, rowspan, styleStr, cellData == null ? "" : cellData.toString()));
                    first = false;
                }
            }
        }
        dest.append("</tr>\n");
    }

    private void writeTableItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException, InformException {
        int bgColor = 0x1FFFFFFF;
        int brColor = 0;
        int paraNo = 0;
        boolean isLast = false;
        DocumentGeneratorStringBuilder tableData = new DocumentGeneratorStringBuilder();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    reader.skipInt();
                    break;
                }
                case 2: {
                    reader.skipInt();
                    break;
                }
                case 11: {
                    bgColor = reader.getInt();
                    break;
                }
                case 12: {
                    brColor = reader.getInt();
                    break;
                }
                case 4: {
                    this.writeTableData(reader.getSubStreamReader(), tableData, bgColor, brColor);
                    break;
                }
                case 5: {
                    isLast = true;
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (tableData.length() != 0) {
            if (isLast) {
                this.closePrevParagraphAndStartNew(dest, paraNo);
            }
            String styleStr = String.format("style=\"border-spacing:0; border-width: 0px; border-collapse: collapse; background-color: %s; border-color: %s\"", HtmlUtils.vColor(bgColor), HtmlUtils.vColor(brColor));
            dest.append(String.format("<table %s >\n%s</table>\n", styleStr, tableData.toString()));
            this.closePrevParagraph(dest);
        }
    }

    private void writeMarkerItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException {
        int styleNo = 0;
        int level = 0;
        int start = 1;
        boolean startIsSet = false;
        boolean markerRestart = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    styleNo = reader.getInt();
                    break;
                }
                case 5: {
                    reader.skipInt();
                    break;
                }
                case 2: {
                    level = reader.getInt();
                    break;
                }
                case 3: {
                    start = reader.getInt();
                    startIsSet = true;
                    break;
                }
                case 4: {
                    markerRestart = true;
                }
            }
        }
        if (dest.isMarkerStarted()) {
            this.closePrevMark(dest);
        }
        if (startIsSet || markerRestart) {
            this.closePrevParagraph(dest);
            this.closeList(dest);
            Object tagStr = String.format("start=\"%s\" ", start);
            for (ListStyle ls : this.listStyles) {
                if (ls.id != styleNo || ls.levels.size() <= level) continue;
                ListStyleLevel styleLevel = ls.levels.get(level);
                switch (styleLevel.type) {
                    case 0: {
                        tagStr = "<ul type=\"disc\" ";
                        dest.setLastListTag("ul");
                        break;
                    }
                    case 3: {
                        tagStr = "<ol type = \"1\"";
                        dest.setLastListTag("ol");
                    }
                }
            }
            tagStr = (String)tagStr + String.format("start=\"%s\">", start);
            dest.append((CharSequence)tagStr);
        }
        dest.append("<li>");
        dest.setMarkerStarted(true);
    }

    private void writeTabItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException {
        String text = "";
        boolean isLast = false;
        int paraNo = -1;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    text = reader.getString();
                    break;
                }
                case 4: {
                    isLast = true;
                    break;
                }
                case 3: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (isLast) {
            this.closePrevParagraphAndStartNew(dest, paraNo);
        }
        dest.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private void writePageBreakItem(DocumentGeneratorStringBuilder dest) {
        dest.append("<hr/>");
    }

    private void writeTextItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException {
        String text = "";
        int styleNo = 0;
        int paraNo = 0;
        boolean isLast = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    text = reader.getString();
                    break;
                }
                case 2: {
                    styleNo = reader.getInt();
                    break;
                }
                case 4: {
                    isLast = true;
                    break;
                }
                case 3: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (text.isEmpty()) {
            if (!dest.isMarkerStarted()) {
                text = "\n";
            } else {
                return;
            }
        }
        if (isLast) {
            this.closePrevParagraphAndStartNew(dest, paraNo);
        }
        dest.append(String.format("<span class=\"%s\">%s</span>", this.getCssTextStyleName(styleNo), HtmlUtils.htmlEnquote(text)));
    }

    private void writeCheckPointItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException {
        int id = -1;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    id = reader.getInt();
                }
            }
        }
        dest.append(String.format("<a name=\"%s\"> </a>", id));
    }

    private void writeHypertextItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException, InformException {
        double hypertextNodeId = 0.0;
        String caption = "";
        int styleNo = -1;
        int paraNo = 0;
        int anchorId = -1;
        boolean isLast = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 151: {
                    hypertextNodeId = reader.getDouble();
                    break;
                }
                case 4: {
                    caption = reader.getString();
                    break;
                }
                case 7: {
                    isLast = true;
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                    break;
                }
                case 8: {
                    styleNo = reader.getInt();
                    break;
                }
                case 9: {
                    anchorId = reader.getInt();
                }
            }
        }
        if (isLast) {
            this.closePrevParagraphAndStartNew(dest, paraNo);
        }
        dest.append("<a class=\"").append(this.getCssTextStyleName(styleNo)).append("\" href=\"");
        if (hypertextNodeId < 0.0) {
            HtmlUtils.enquoteAttribute(caption, '\"', dest);
        } else {
            if (hypertextNodeId != 0.0) {
                dest.append("/node/").append((long)hypertextNodeId);
            }
            if (anchorId != -1) {
                dest.append('#').append(anchorId);
            }
        }
        dest.append("\">").append(HtmlUtils.htmlEnquote(caption)).append("</a>");
    }

    private void writePictureItem(TaggedReader reader, DocumentGeneratorStringBuilder dest) throws IOException, TaggedReaderException, InformException {
        double pictNodeId = 0.0;
        int height = 0;
        int width = 0;
        int currPictIndex = -1;
        int paraNo = 0;
        boolean isLast = false;
        byte[] imageContent = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 151: {
                    pictNodeId = reader.getDouble();
                    break;
                }
                case 2: {
                    height = reader.getInt();
                    if (height <= 2048) break;
                    height = 2048;
                    break;
                }
                case 3: {
                    width = reader.getInt();
                    if (width <= 2048) break;
                    width = 2048;
                    break;
                }
                case 5: {
                    ++this.imageIndex;
                    imageContent = reader.getRaw();
                    break;
                }
                case 7: {
                    isLast = true;
                    break;
                }
                case 6: {
                    paraNo = reader.getInt();
                }
            }
        }
        if (isLast) {
            this.closePrevParagraphAndStartNew(dest, paraNo);
        }
        dest.append("<img");
        if (height != 0) {
            dest.append(" height=").append(height);
        }
        if (width != 0) {
            dest.append(" width=").append(width);
        }
        dest.append(" src=\"");
        if (pictNodeId != 0.0) {
            dest.append(this.generateImageFromNode(pictNodeId));
        } else if (currPictIndex != -1) {
            dest.append(this.generateImageFromBytes(imageContent));
        }
        dest.append("\">");
    }

    protected abstract String generateImageFromBytes(byte[] var1);

    protected abstract String generateImageFromNode(double var1);

    private static class ListStyle {
        int id;
        String name;
        ArrayList<ListStyleLevel> levels = new ArrayList();

        public ListStyle(int id) {
            this.id = id;
        }
    }

    private static class ListStyleLevel {
        int type;
        String formatString;

        public ListStyleLevel(int type) {
            this.type = type;
        }
    }

    private static class ParagraphStyle {
        int id;
        int align = 0;
        int firstIndent = 0;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        int lineSpacing = 0;
        int lineSpacingType = 0;
        int libId = 0;

        public ParagraphStyle(int id) {
            this.id = id;
        }

        public void generate(Appendable out) throws IOException {
            out.append("text-align:");
            switch (this.align) {
                case 1: {
                    out.append("right");
                    break;
                }
                case 2: {
                    out.append("center");
                    break;
                }
                case 3: {
                    out.append("justify");
                    break;
                }
                default: {
                    out.append("left");
                }
            }
            out.append(";\n");
            if (this.firstIndent > 0) {
                out.append("text-indent:").append(Integer.toString(this.firstIndent)).append("px;\n");
            }
            out.append("margin-top:").append(Integer.toString(this.topMargin)).append("px;\n");
            out.append("margin-bottom:").append(Integer.toString(this.bottomMargin)).append("px;\n");
            out.append("margin-left:").append(Integer.toString(this.leftMargin)).append("px;\n");
            out.append("margin-right:").append(Integer.toString(this.rightMargin)).append("px;\n");
        }
    }

    private static class TextStyle {
        int id;
        ClientFont font = new ClientFont();
        int background = 0x1FFFFFFF;
        int subSuperScriptType = 0;
        int libId = 0;
        boolean jump = false;

        public TextStyle(int id) {
            this.id = id;
        }

        public void generate(Appendable out) throws IOException {
            out.append("background-color:").append(HtmlUtils.vColor(this.background)).append(";\n");
            out.append("font-family:").append(this.font.getName()).append(";\n");
            out.append("font-size:").append(Double.toString(this.subSuperScriptType == 0 ? (double)this.font.getSize() : (double)Math.round((double)this.font.getSize() * 0.75))).append("pt;\n");
            out.append("color:").append(HtmlUtils.vColor(this.font.getColor())).append(";\n");
            out.append("font-weight:").append((this.font.getStyle() & 1) != 0 ? "bold" : "normal").append(";\n");
            out.append("font-style:").append((this.font.getStyle() & 2) != 0 ? "italic" : "normal").append(";\n");
            out.append("text-decoration:").append((this.font.getStyle() & 4) != 0 || this.jump ? "underline" : "none").append(";\n");
            out.append(this.subSuperScriptType == 1 ? "vertical-align: sub;" : "");
            out.append(this.subSuperScriptType == 2 ? "vertical-align: super;" : "");
        }
    }
}

