/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.utils.ClientFont;
import java.io.IOException;

public class DocumentJSON {
    public static void write(TaggedReader reader, JsonWriter out) throws IOException {
        out.object();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 2: {
                    DocumentJSON.readStyles(reader.getSubStreamReader(), out.prop("styles"));
                    break;
                }
                case 1: {
                    DocumentJSON.writeDocData(reader.getSubStreamReader(), out.prop("content"));
                }
            }
        }
        out.end();
    }

    private static void readStyles(TaggedReader reader, JsonWriter out) throws IOException {
        out.object();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    DocumentJSON.readTextStyles(reader.getStreamReader(), out.prop("text"));
                    break;
                }
                case 2: {
                    DocumentJSON.readParaStyles(reader.getStreamReader(), out.prop("para"));
                }
            }
        }
        out.end();
    }

    private static void writeDocData(TaggedReader reader, JsonWriter out) throws IOException {
        out.array();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    DocumentJSON.writeTextItem(reader.getSubStreamReader(), out.prop());
                }
            }
        }
        out.end();
    }

    private static void readTextStyles(TaggedReader reader, JsonWriter out) throws IOException {
        out.array();
        int length = 0;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    if (length > 0) {
                        out.end();
                    }
                    int id = reader.getInt();
                    while (length < id) {
                        out.prop().val(null);
                        ++length;
                    }
                    out.prop().object();
                    ++length;
                    break;
                }
                case 1: {
                    ClientFont f = new ClientFont();
                    f.load(reader.getRaw());
                    out.prop("font").object().prop("name").val(f.getName()).prop("size").val(f.getSize()).prop("color").val(f.getColor()).prop("style").val(f.getStyle()).end();
                    break;
                }
                case 2: {
                    out.prop("background").val(reader.getInt());
                    break;
                }
                case 5: {
                    out.prop("super").val(reader.getInt());
                    break;
                }
                case 7: {
                    out.prop("hyper").val(true);
                }
            }
        }
        if (length > 0) {
            out.end();
        }
        out.end();
    }

    private static void readParaStyles(TaggedReader reader, JsonWriter out) throws IOException {
        out.array();
        int length = 0;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 9: {
                    if (length > 0) {
                        out.end();
                    }
                    int id = reader.getInt();
                    while (length < id) {
                        out.prop().val(null);
                        ++length;
                    }
                    out.prop().object();
                    ++length;
                    break;
                }
                case 1: {
                    out.prop("align").val(reader.getInt());
                }
            }
        }
        if (length > 0) {
            out.end();
        }
        out.end();
    }

    private static void writeTextItem(TaggedReader reader, JsonWriter out) throws IOException {
        out.object().prop("@").val("text");
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    out.prop("text").val(reader.getString());
                    break;
                }
                case 2: {
                    out.prop("tstyle").val(reader.getInt());
                    break;
                }
                case 4: {
                    out.prop("last").val(true);
                    break;
                }
                case 3: {
                    out.prop("pstyle").val(reader.getInt());
                }
            }
        }
        out.end();
    }
}

