/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.Cache;
import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.net.Security;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.web.AsmoServlet;
import inform.agent.web.DocumentGenerator;
import inform.agent.web.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class DocumentServlet
extends AsmoServlet.WithSession {
    private static final Cache<String, byte[]> globalImageCache = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageInCache(String url, byte[] image) {
        Cache<String, byte[]> cache = globalImageCache;
        synchronized (cache) {
            globalImageCache.put(url, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCachedImage(String url) {
        Cache<String, byte[]> cache = globalImageCache;
        synchronized (cache) {
            return globalImageCache.get(url);
        }
    }

    public DocumentServlet() {
        super(AsmoServlet.Type.HTML);
    }

    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        String url = req.getRequestURI();
        String[] path = null;
        double nodeId = 0.0;
        try {
            path = req.getPathInfo().split("/");
            nodeId = Double.parseDouble(path[1]);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            return;
        }
        BasicNode node = MtdEngine.getValidNode(nodeId).getRealNode();
        Session.User user = session.user();
        Acl acl = Security.acl(node);
        if ((user.accessMask(acl) & 0x4000000) == 0) {
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        DocumentServlet.exec((AbstractConnection)((Request)req).getConnection(), url, path, node, resp, user, this.root());
    }

    static void exec(AbstractConnection connection, final String url, String[] path, BasicNode node, HttpServletResponse resp, Session.User user, final String root) throws Exception {
        if (path.length == 5 || path.length == 3) {
            byte[] image = DocumentServlet.getCachedImage(url);
            if (image == null) {
                String base = url.replaceAll("/[^/]+$", "");
                byte[] content = DocumentServlet.content(connection, node, path, user);
                if (content != null) {
                    image = DocumentServlet.getDocumentImage(base, node, new TaggedReader(content), url, root);
                }
            }
            if (image == null) {
                resp.sendError(404);
            } else {
                resp.getOutputStream().write(image);
            }
            return;
        }
        byte[] content = DocumentServlet.content(connection, node, path, user);
        if (content == null) {
            return;
        }
        DocumentGenerator gen = new DocumentGenerator(Long.toString((long)node.getId())){
            int currPictIndex;

            @Override
            protected String generateImageFromBytes(byte[] content) {
                String result = DocumentServlet.getImageUrl(url, this.currPictIndex, content);
                DocumentServlet.putImageInCache(result, content);
                ++this.currPictIndex;
                return result;
            }

            @Override
            protected String generateImageFromNode(double nodeId) {
                return String.format("%s/node/%.0f", root, nodeId);
            }
        };
        resp.setCharacterEncoding("WINDOWS-1251");
        resp.setContentType("text/html");
        resp.setStatus(200);
        gen.generate(new TaggedReader(content), new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true), node.getName());
    }

    /*
     * Exception decompiling
     */
    private static byte[] content(AbstractConnection connection, BasicNode node, String[] path, Session.User user) throws InterruptedException, SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getImageUrl(String docBase, int pictIndex, byte[] imageContent) {
        return String.format("%s/%s.%s", docBase, pictIndex, FileSystemLibrary.getFileType(imageContent));
    }

    public static byte[] getDocumentImage(String docBase, BasicNode node, TaggedReader reader, String imageUrl, String root) throws Exception {
        while (reader.next()) {
            if (reader.getCurrentTag() != 1) continue;
            return DocumentServlet.fillDocumentImageCache(docBase, reader.getSubStreamReader(), imageUrl);
        }
        return null;
    }

    private static byte[] fillDocumentImageCache(String docBase, TaggedReader reader, String imageUrl) throws IOException {
        int pictIdx = 0;
        byte[] resultImage = null;
        while (reader.next()) {
            if (reader.getCurrentTag() != 3) continue;
            TaggedReader subReader = reader.getSubStreamReader();
            while (subReader.next()) {
                if (subReader.getCurrentTag() != 5) continue;
                byte[] curImageContent = subReader.getRaw();
                int curPictIdx = pictIdx++;
                String curImageUrl = DocumentServlet.getImageUrl(docBase, curPictIdx, curImageContent);
                if (resultImage == null && imageUrl.equals(curImageUrl)) {
                    resultImage = curImageContent;
                }
                DocumentServlet.putImageInCache(curImageUrl, curImageContent);
            }
        }
        return resultImage;
    }
}

