/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.am.Telemeter;
import inform.agent.web.Session;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletHandler;

public class RequestHandler
extends ServletHandler {
    private static final Map<Thread, Rq> REQUESTS = new IdentityHashMap<Thread, Rq>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Thread thread = Thread.currentThread();
        Map<Thread, Rq> map = REQUESTS;
        synchronized (map) {
            REQUESTS.put(thread, new Rq((Session)request.getSession()));
        }
        try {
            super.doHandle(target, baseRequest, request, response);
        }
        finally {
            map = REQUESTS;
            synchronized (map) {
                REQUESTS.remove(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        Map<Thread, Rq> map = REQUESTS;
        synchronized (map) {
            for (Map.Entry<Thread, Rq> e : REQUESTS.entrySet()) {
                Thread thread = e.getKey();
                Rq rq = e.getValue();
                gatherer.webRequest(rq.id, gatherer.time() - rq.started, rq.session, thread.getState().toString(), thread);
            }
        }
    }

    private static class Rq {
        final long started = System.currentTimeMillis();
        final int id = Telemeter.genId();
        final Session session;

        public Rq(Session session) {
            this.session = session;
        }
    }
}

