/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.Core;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class RequestLog
extends AbstractHandler {
    private final Handler handler;

    public RequestLog(Handler handler) {
        this.handler = handler;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handler.start();
    }

    protected void doStop() throws Exception {
        this.handler.stop();
        super.doStop();
    }

    public void setServer(Server server) {
        super.setServer(server);
        this.handler.setServer(server);
    }

    private void log(Request rq, Response rs, long dt) {
        int status = rs.getStatus();
        if (status <= 0) {
            status = 404;
        }
        Core.logger.info("{} \"{} {} {}\" {} L:{} T:{}", rq.getRemoteAddr(), rq.getMethod(), rq.getUri(), rq.getProtocol(), status, rs.getContentCount(), dt);
    }

    private void log(Request rq, Throwable e, long dt) {
        Core.logger.error(rq.getRemoteAddr() + " \"" + rq.getMethod() + " " + rq.getUri() + " " + rq.getProtocol() + "\" T:" + dt, e);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long st = System.currentTimeMillis();
        try {
            this.handler.handle(target, baseRequest, request, response);
            this.log(baseRequest, (Response)response, System.currentTimeMillis() - st);
        }
        catch (Throwable e) {
            this.log(baseRequest, e, System.currentTimeMillis() - st);
        }
    }
}

