/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.scripts.AbstractScriptableTask;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.web.Helpers;
import inform.agent.web.RequestTaskResponse;
import inform.agent.web.Session;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.MultiPartInputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class RequestTask
extends AbstractScriptableTask {
    boolean needResponse = true;
    private static final int TAG_SCRIPT = 1;
    private static final int TAG_ON_EXECUTE = 3;
    private static final int TAG_CHARSET = 10;
    private static final int TAG_COMPONENT_NAME = 20;
    private final String script;
    private final String onExecute;
    final HttpServletRequest req;
    final HttpServletResponse resp;
    int status = 202;

    public RequestTask(ServerSideHost ssHost, BasicNode node, HttpServletRequest req, HttpServletResponse resp, Session.User user, String rootInfo) throws InformException, IOException {
        super(node, null, ssHost, new ParametersList(), null, null);
        this.req = req;
        this.resp = resp;
        RequestTaskResponse response = new RequestTaskResponse(this, (Scriptable)this);
        RequestTask.putConstProperty(this, "response", response);
        TaggedReader in = new TaggedReader(node.getContent());
        String _script = "";
        String _execCall = null;
        String charset = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 152: {
                    Helpers.datamodelParameters(this.parameters, in.getSubStreamData(), this.constants);
                    break;
                }
                case 1: {
                    _script = in.getAnsi();
                    break;
                }
                case 3: {
                    _execCall = in.getAnsi();
                    break;
                }
                case 20: {
                    ServerSideComponent c = ComponentsFactory.readAndCreateComponent(null, this, this, 20, in);
                    if (c == null) break;
                    c.setParentScope(this);
                    this.components.add(c);
                    RequestTask.putConstProperty(this, c.getName(), c);
                    break;
                }
                case 10: {
                    if (in.getCurrentTagSize() <= 0) break;
                    charset = in.getAnsi();
                    response.setCharset(charset);
                }
            }
        }
        RequestTask.putConstProperty(this, "request", new Request(this, req, user, rootInfo, charset));
        this.components.afterLoad();
        this.script = _script;
        this.onExecute = _execCall;
    }

    @SmartScriptableObject.FunctionTag
    public void sendResponse() throws IOException {
        if (this.resp == null) {
            return;
        }
        this.resp.flushBuffer();
        if (this.resp instanceof Response) {
            ((Response)this.resp).complete();
            this.needResponse = false;
        }
    }

    private String arr(byte[] a) {
        StringBuilder r = new StringBuilder();
        boolean nc = false;
        for (byte b : a) {
            if (nc) {
                r.append(',');
            }
            r.append('0').append('x').append(Integer.toHexString(b & 0xFF));
            nc = true;
        }
        return r.toString();
    }

    @SmartScriptableObject.FunctionTag
    public String userHash(double id) throws InformException {
        UserNode node = MtdEngine.getUserNode(id);
        if (node == null) {
            return null;
        }
        byte[] h = node.getSecurityHash();
        return this.arr(h);
    }

    @SmartScriptableObject.FunctionTag
    public String userSalt(double id) throws InformException {
        UserNode node = MtdEngine.getUserNode(id);
        if (node == null) {
            return null;
        }
        return new String(node.getSecuritySalt(), TaggedWriter.ANSI);
    }

    public void execute() throws Throwable {
        this.execute(new AbstractScriptableTask.ExecuteAction<Void>(){

            @Override
            public Void execute(Context context) {
                context.evaluateString(RequestTask.this, RequestTask.this.script, RequestTask.this.node.toLogString(), 1, null);
                if (RequestTask.this.onExecute != null) {
                    ScriptableObject.callMethod(context, RequestTask.this, RequestTask.this.onExecute, null);
                }
                return null;
            }
        });
        if (this.status == 202) {
            this.resp.setStatus(200);
        }
    }

    @Override
    public String getClassName() {
        return "WebRequestModule";
    }

    private static class Request
    extends SmartScriptableObject {
        private final HttpServletRequest rq;
        private Parameters parameters;
        private Headers headers;
        private Parts parts;
        private Content content;
        private String pathInfo;

        public Request(Scriptable scope, HttpServletRequest rq, Session.User user, String rootInfo, String charset) throws IOException, InformException {
            this.setParentScope(scope);
            this.rq = rq;
            if (charset != null) {
                this.rq.setCharacterEncoding(charset);
            }
            Request.putConstProperty(this, "user", user);
            Request.putConstProperty(this, "rootInfo", rootInfo);
        }

        @Override
        public String getClassName() {
            return "WebRequestModule.Request";
        }

        @SmartScriptableObject.PropertyTag
        Parameters getParameters() {
            if (this.parameters == null) {
                this.parameters = new Parameters();
            }
            return this.parameters;
        }

        @SmartScriptableObject.PropertyTag
        Headers getHeaders() {
            if (this.headers == null) {
                this.headers = new Headers();
            }
            return this.headers;
        }

        @SmartScriptableObject.PropertyTag
        Parts getParts() throws Exception {
            if (this.parts == null) {
                this.parts = new Parts();
            }
            return this.parts;
        }

        @SmartScriptableObject.PropertyTag
        Content getContent() {
            if (this.content == null) {
                this.content = new Content();
            }
            return this.content;
        }

        @SmartScriptableObject.PropertyTag
        String getPathInfo() {
            if (this.pathInfo != null) {
                return this.pathInfo;
            }
            StringBuilder pathInfo = new StringBuilder();
            String[] sp = this.rq.getPathInfo().split("/");
            for (int i = 2; i < sp.length; ++i) {
                pathInfo.append('/').append(sp[i]);
            }
            this.pathInfo = pathInfo.toString();
            return this.pathInfo;
        }

        @SmartScriptableObject.PropertyTag
        public String getRemoteAddress() {
            return this.rq.getRemoteAddr();
        }

        @SmartScriptableObject.PropertyTag
        public String getRemoteHost() {
            return this.rq.getRemoteHost();
        }

        @SmartScriptableObject.PropertyTag
        public int getRemotePort() {
            return this.rq.getRemotePort();
        }

        @SmartScriptableObject.PropertyTag
        public String getLocalAddress() {
            return this.rq.getLocalAddr();
        }

        @SmartScriptableObject.PropertyTag
        public int getLocalPort() {
            return this.rq.getLocalPort();
        }

        class Content
        extends SmartScriptableObject {
            private byte[] data_;

            Content() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] asBytes() throws IOException {
                if (this.data_ == null) {
                    int cnt = Request.this.rq.getContentLength();
                    if (cnt <= 0) {
                        return new byte[0];
                    }
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream(cnt);
                    try (ServletInputStream in = Request.this.rq.getInputStream();){
                        IO.transfer((InputStream)in, tmp);
                    }
                    this.data_ = tmp.toByteArray();
                }
                return this.data_;
            }

            @SmartScriptableObject.PropertyTag
            public BinaryObject getAsBinary() throws IOException {
                return new BinaryObject(this.asBytes());
            }

            @SmartScriptableObject.PropertyTag
            public String getAsString() throws IOException {
                return new String(this.asBytes(), Request.this.rq.getCharacterEncoding());
            }

            @SmartScriptableObject.FunctionTag
            public String toString(Object charsetName) throws IOException {
                String csName = charsetName != null && charsetName != Undefined.instance ? charsetName.toString() : Request.this.rq.getCharacterEncoding();
                return new String(this.asBytes(), csName);
            }
        }

        class Parts
        extends ScriptableObject {
            public Parts() throws IOException, ServletException {
                String contentType = Request.this.rq.getContentType();
                if (contentType != null && contentType.startsWith("multipart/form-data")) {
                    for (Part p : Request.this.rq.getParts()) {
                        Parts.putConstProperty(this, p.getName(), new JPart((MultiPartInputStream.MultiPart)p));
                    }
                }
            }

            @Override
            public String getClassName() {
                return "Parts";
            }

            class JPart
            extends SmartScriptableObject {
                private final MultiPartInputStream.MultiPart part;

                public JPart(MultiPartInputStream.MultiPart part) {
                    this.part = part;
                }

                @SmartScriptableObject.PropertyTag
                public String getName() {
                    return this.part.getName();
                }

                @SmartScriptableObject.PropertyTag
                public String getFileName() {
                    String h = this.part.getHeader("content-disposition");
                    if (h != null) {
                        for (String e : h.split(";")) {
                            String[] sp = e.trim().split("=");
                            if (sp.length <= 1 || !"filename".equals(sp[0])) continue;
                            return new File(sp[1].replaceAll("\"", "")).getName();
                        }
                    }
                    return this.part.getContentDispositionFilename();
                }

                @SmartScriptableObject.PropertyTag
                public long getSize() {
                    return this.part.getSize();
                }

                private byte[] asBytes() throws IOException {
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream((int)this.part.getSize());
                    try (InputStream in = this.part.getInputStream();){
                        IO.transfer(in, tmp);
                    }
                    return tmp.toByteArray();
                }

                @SmartScriptableObject.PropertyTag
                public BinaryObject getAsBinary() throws IOException {
                    return new BinaryObject(this.asBytes());
                }

                @SmartScriptableObject.PropertyTag
                public String getAsString() throws IOException {
                    return new String(this.asBytes(), Request.this.rq.getCharacterEncoding());
                }

                @SmartScriptableObject.FunctionTag
                public String toString(Object charsetName) throws IOException {
                    String csName = charsetName instanceof String ? (String)charsetName : Request.this.rq.getCharacterEncoding();
                    return new String(this.asBytes(), csName);
                }
            }
        }

        class Headers
        extends ScriptableObject {
            public Headers() {
                Enumeration i = Request.this.rq.getHeaderNames();
                while (i.hasMoreElements()) {
                    String n = i.nextElement().toString();
                    Headers.putConstProperty(this, n, Request.this.rq.getHeader(n));
                }
            }

            @Override
            public String getClassName() {
                return "Headers";
            }
        }

        class Parameters
        extends ScriptableObject {
            public Parameters() {
                Enumeration i = Request.this.rq.getParameterNames();
                while (i.hasMoreElements()) {
                    String n = i.nextElement().toString();
                    Parameters.putConstProperty(this, n, Request.this.rq.getParameter(n));
                }
            }

            @Override
            public String getClassName() {
                return "Parameters";
            }
        }
    }
}

