/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemesManager;
import inform.agent.scripts.SSContext;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SchemeServlet
extends AsmoServlet {
    HashMap<String, Integer> HashMap = new HashMap();
    private final SSContext ssContext = null;

    void error(String msg) {
        throw new InformException(msg);
    }

    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        String pathInfo = req.getPathInfo();
        String str = null;
        try {
            str = pathInfo.split("/")[1];
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            this.error("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0442\u0430\u0439\u043b\u0443");
        }
        if (null == str) {
            this.error("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0442\u0430\u0439\u043b\u0443");
        }
        if (str.equalsIgnoreCase("layersConfig")) {
            this.executeLayersConfig(req, resp);
        } else {
            this.executeTile(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTile(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        block25: {
            String pathInfo = null;
            long startTime = System.currentTimeMillis();
            try {
                String[] coords;
                String[] paths;
                pathInfo = req.getPathInfo();
                if (Ini.TraceScheme) {
                    Core.logger.info("SCHEME: get tile({})", (Object)pathInfo);
                }
                if ((paths = pathInfo.split("/")).length < 4) {
                    this.error("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0442\u0430\u0439\u043b\u0443");
                }
                String id = paths[1];
                double nodeId = -1.0;
                try {
                    nodeId = Double.valueOf(id);
                }
                catch (NumberFormatException e) {
                    throw new InformException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0442\u0430\u0439\u043b\u0443", e);
                }
                if (-1.0 == nodeId) {
                    this.error("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0442\u0430\u0439\u043b\u0443");
                }
                SchemeKeepSettings keepSettings = this.getKeepSettings(nodeId);
                String sScheme = paths[2];
                double schemeId = Double.valueOf(sScheme);
                int coordIdx = 3;
                String layersConfig = "";
                if (paths.length > 4) {
                    layersConfig = paths[3];
                    coordIdx = 4;
                }
                if ((coords = paths[coordIdx].split("s")) == null || coords.length < 3) {
                    this.error("\u041d\u0435\u0442 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 \u0442\u0430\u0439\u043b\u0430");
                }
                String sz = coords[0];
                String sx = coords[1];
                String sy = coords[2];
                if (sx != null && sy != null && sz != null) {
                    int x = Integer.parseInt(sx);
                    int y = Integer.parseInt(sy);
                    int z = Integer.parseInt(sz);
                    byte[] image = null;
                    String eTag = null;
                    String CallCountStr = "s:" + NumberConverter.doubleToString(schemeId) + ",l:" + layersConfig + ",x:" + sx + ",y:" + sy + ",z:" + sz;
                    Integer CallCount = this.HashMap.get(CallCountStr);
                    if (CallCount == null) {
                        CallCount = 0;
                    }
                    Integer n = CallCount;
                    Integer n2 = CallCount = Integer.valueOf(CallCount + 1);
                    this.HashMap.put(CallCountStr, CallCount);
                    if (Ini.SchemeTailEmpty) {
                        SchemeEngine Engine2 = new SchemeEngine(null);
                        image = Engine2.RasterDbg(schemeId, x, y, z, CallCount);
                    } else {
                        ConnectionManager dbMgr = new ConnectionManager(this.ssContext, "SchemeServlet");
                        try {
                            Scheme scheme = SchemesManager.getScheme(null, dbMgr, keepSettings.getSchemeTable(), schemeId, keepSettings.getSchemeBlob(), keepSettings.getSchemeDate(), true, true, keepSettings);
                            if (scheme != null) {
                                String str;
                                eTag = Long.toHexString(scheme.getSchemeSize()) + "_" + Long.toHexString((long)(scheme.getSchemeDate() * 24.0 * 3600.0)) + "_" + CallCountStr;
                                if (eTag.equals(str = req.getHeader("If-None-Match"))) {
                                    resp.setStatus(304);
                                    return;
                                }
                                SchemeEngine Engine3 = new SchemeEngine(scheme);
                                image = Engine3.Raster(dbMgr, layersConfig, x, y, z, CallCount);
                            }
                        }
                        finally {
                            dbMgr.release();
                        }
                    }
                    if (image != null) {
                        resp.setHeader("Cache-Control", "public, max-age=10");
                        resp.setHeader("Content-Type", "image/png");
                        if (eTag != null) {
                            resp.setHeader("ETag", eTag);
                        }
                        ServletOutputStream stream = resp.getOutputStream();
                        stream.write(image);
                    }
                    break block25;
                }
                this.error("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            }
            finally {
                if (Ini.TraceScheme) {
                    long totalTime = System.currentTimeMillis() - startTime;
                    Core.logger.info("SCHEME: tile({}) done {}ms", (Object)pathInfo, (Object)totalTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeLayersConfig(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        String pathInfo = null;
        long startTime = System.currentTimeMillis();
        try {
            pathInfo = req.getPathInfo();
            if (Ini.TraceScheme) {
                Core.logger.info("SCHEME: get layers config({})", (Object)pathInfo);
            }
            String[] paths = pathInfo.split("/");
            String id = pathInfo.split("/")[2];
            double nodeId = Double.valueOf(id);
            SchemeKeepSettings keepSettings = this.getKeepSettings(nodeId);
            String sScheme = paths[3];
            double schemeId = Double.valueOf(sScheme);
            String eTag = null;
            ConnectionManager dbMgr = new ConnectionManager(this.ssContext, "SchemeServlet");
            try {
                Scheme scheme = SchemesManager.getScheme(null, dbMgr, keepSettings.getSchemeTable(), schemeId, keepSettings.getSchemeBlob(), keepSettings.getSchemeDate(), true, true, keepSettings);
                if (scheme != null) {
                    String str;
                    eTag = Long.toHexString(scheme.getSchemeSize()) + " " + Long.toHexString((long)(scheme.getSchemeDate() * 24.0 * 3600.0)) + " " + NumberConverter.doubleToString(schemeId);
                    if (eTag.equals(str = req.getHeader("If-None-Match"))) {
                        resp.setStatus(304);
                        return;
                    }
                    scheme.parse(dbMgr, false);
                    scheme.sortObjects();
                    scheme.calcSchemeBounds();
                    SchemeObject so = null;
                    String name = "";
                    boolean visible = false;
                    boolean nc = false;
                    resp.setCharacterEncoding("WINDOWS-1251");
                    resp.setHeader("Cache-Control", "no-cache");
                    resp.setHeader("Content-Type", "application/json");
                    resp.setHeader("ETag", eTag);
                    PrintWriter w = resp.getWriter();
                    w.append('[');
                    for (int i = 0; i < scheme.SortLayers.size(); ++i) {
                        so = scheme.SortLayers.get(i);
                        if (so == null) continue;
                        SchemeObject schemeObject = so;
                        synchronized (schemeObject) {
                            if (so.BG != null) {
                                if (nc) {
                                    w.append(',');
                                }
                                nc = true;
                                name = "";
                                if (so.BG.StringProps != null) {
                                    name = so.BG.StringProps.Caption;
                                }
                                visible = ((PhxLayer)so.BG).Visible;
                                w.append("{\"n\":").append(JSON.toString(name));
                                w.append(",\"v\":").append(JSON.toString(visible));
                                w.append('}');
                            }
                            continue;
                        }
                    }
                    w.append(']');
                }
            }
            finally {
                dbMgr.release();
            }
        }
        finally {
            if (Ini.TraceScheme) {
                long totalTime = System.currentTimeMillis() - startTime;
                Core.logger.info("SCHEME: layers config{} done {}ms", (Object)pathInfo, (Object)totalTime);
            }
        }
    }

    protected SchemeKeepSettings getKeepSettings(double nodeId) throws Throwable {
        SchemeKeepSettings keepSettings = null;
        BasicNode node = MtdEngine.getValidNode(nodeId).getRealNode();
        if (node == null) {
            this.error("MtdEngine.getValidNode node == null");
        }
        switch (node.getType()) {
            case 52: {
                byte[] content = node.getContent();
                if (content.length > 0) {
                    TaggedReader reader = new TaggedReader(content);
                    keepSettings = new SchemeKeepSettings(reader);
                    if (keepSettings.getSchemeTable() == 0.0) {
                        this.error("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u0445\u0435\u043c \u0432 \u0443\u0437\u043b\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                    }
                    if (keepSettings.getSchemeBlob() != 0) break;
                    this.error("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \u0441\u0445\u0435\u043c\u044b \u0432 \u0443\u0437\u043b\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                    break;
                }
                this.error("\u041d\u0443\u043b\u0435\u0432\u043e\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0443\u0437\u043b\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c");
                break;
            }
            default: {
                this.error("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0445\u0435\u043c [" + NumberConverter.doubleToString(nodeId) + "] (" + node.getType() + ")");
            }
        }
        return keepSettings;
    }
}

