/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.AgentJARVersion;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Resource;
import inform.agent.web.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticContentServlet
extends AsmoServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        String path = req.getPathInfo();
        if (path != null && path.endsWith("core.js")) {
            resp.setHeader("Cache-Control", "no-store");
            resp.setHeader("Content-Type", "text/javascript");
            String res = Resource.asString(((Object)((Object)this)).getClass(), "/WEB-ROOT" + path, this.root());
            Session.User user = ((Session)req.getSession(true)).user();
            res = res.replace("'{USER}'", JSON.toString(user));
            resp.setCharacterEncoding("WINDOWS-1251");
            resp.getWriter().append(res);
            return;
        }
        resp.setHeader("Cache-Control", "max-age=60");
        String eTag = AgentJARVersion.ETAG;
        resp.setHeader("ETag", eTag);
        String ifNoneMatch = req.getHeader("If-None-Match");
        if (ifNoneMatch != null && eTag.equals(ifNoneMatch)) {
            resp.setStatus(304);
            return;
        }
        if (path != null) {
            InputStream in;
            String mime = req.getServletContext().getMimeType(path);
            if (mime != null) {
                resp.setHeader("Content-Type", mime);
            }
            if ((in = ((Object)((Object)this)).getClass().getResourceAsStream("/WEB-ROOT" + path)) != null) {
                try {
                    this.transfer(in, (OutputStream)resp.getOutputStream());
                    return;
                }
                finally {
                    in.close();
                }
            }
        }
        resp.setStatus(404);
    }

    private void transfer(InputStream from, OutputStream to) throws IOException {
        int l;
        int MIN_BUFFER_SIZE = 1024;
        int MAX_BUFFER_SIZE = 0x100000;
        int buffSize = from.available();
        if (buffSize < 1024) {
            buffSize = 1024;
        } else if (buffSize > 0x100000) {
            buffSize = 0x100000;
        }
        byte[] buff = new byte[buffSize];
        while ((l = from.read(buff)) >= 0) {
            to.write(buff, 0, l);
        }
    }
}

