/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.data;

import inform.adt.collections.IntegerHash;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.scripts.Dataset;

class DataNode
implements IntegerHash.Entry {
    final Dataset datasource;
    Rowset rowset = null;
    int level = -1;
    boolean explicit;
    double recordId;

    DataNode(Dataset datasource, int level, boolean explicit) {
        this.datasource = datasource;
        this.explicit = explicit;
        this.level = level;
    }

    @Override
    public int key() {
        return this.datasource.getId();
    }

    void setLevel(int level) {
        if (this.level < level) {
            this.level = level;
        }
    }

    double getCurrentRecordId() {
        if (this.rowset != null) {
            Row row = this.rowset.getCurrentRow();
            if (row == null) {
                return 0.0;
            }
            return row.getId();
        }
        return 0.0;
    }

    void reset() throws Exception {
        this.rowset = this.datasource.executeSelect();
        this.recordId = 0.0;
        if (this.rowset != null) {
            this.setPosition(0);
            Row row = this.rowset.getCurrentRow();
            if (row != null) {
                this.recordId = row.getId() - 1.0;
            }
        }
    }

    void setPosition(int recordIndex) {
        if (this.rowset != null) {
            this.rowset.setRecordIndex(recordIndex);
        }
    }

    boolean isEof() {
        return this.rowset == null || this.rowset.getCurrentRow() == null;
    }
}

