/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval;

import inform.agent.db.types.DataType;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Parameter;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebValueEvaluator
extends WebEvaluator {
    private final TypedValue value;

    public WebValueEvaluator(Term term, DataType dataType, Object value) {
        super(term);
        this.value = new TypedValue(dataType, value);
    }

    public WebValueEvaluator(ValueTerm term) {
        this(term, term.getType(), term.getValue());
    }

    public WebValueEvaluator(ParameterTerm term) {
        super(term);
        Parameter p = term.getParameter();
        this.value = new TypedValue(p.getDataType(), p.getValue());
    }

    public WebValueEvaluator(ConstantTerm term) {
        super(term);
        Constant c = term.getConstant();
        this.value = new TypedValue(c.getDataType(), c.getValue());
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored();
    }

    @Override
    public TypedValue evaluate() throws Exception {
        return this.value;
    }

    @Override
    public boolean isStringType() throws Exception {
        return WebValueEvaluator.isStringable(this.value.getType());
    }
}

