/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.expr.eval.func;

import inform.agent.db.types.ValueCaster;
import inform.agent.expr.Term;
import inform.agent.web.expr.eval.WebEvaluator;
import inform.agent.web.expr.eval.func.WebFunctionEvaluator;
import inform.agent.web.utils.TypedValue;

public class WebMinEvaluator
extends WebFunctionEvaluator {
    public WebMinEvaluator(Term term) {
        super(term);
    }

    @Override
    public TypedValue evaluate() throws Exception {
        TypedValue value = null;
        String str = null;
        double num = 0.0;
        boolean isString = false;
        for (WebEvaluator arg : this.arguments) {
            TypedValue v;
            if (arg == null || (v = arg.evaluate()) == null) continue;
            if (value == null) {
                value = v;
                if (WebMinEvaluator.isStringable(v.getType())) {
                    str = ValueCaster.toString(v.getValue());
                    isString = true;
                    continue;
                }
                num = ValueCaster.toDouble(v.getValue());
                isString = false;
                continue;
            }
            if (isString) {
                String a = ValueCaster.toString(v.getValue());
                if (str.compareTo(a) <= 0) continue;
                value = v;
                str = a;
                continue;
            }
            double a = ValueCaster.toDouble(v.getValue());
            if (!(num > a)) continue;
            value = v;
            num = a;
        }
        return value;
    }

    @Override
    public boolean isStringType() throws Exception {
        for (WebEvaluator arg : this.arguments) {
            if (arg.isStringType()) continue;
            return true;
        }
        return false;
    }
}

