/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Strings;
import inform.agent.web.JSON;
import java.io.IOException;
import java.util.Arrays;

public class JsonWriter {
    private final Appendable out;
    private int[] stack = new int[32];
    private int pos;
    private int offset;
    private boolean next;

    public JsonWriter(Appendable out, int offset) {
        this.out = out;
        this.offset = offset;
    }

    public JsonWriter object() throws IOException {
        return this.begin(false);
    }

    public JsonWriter array() throws IOException {
        return this.begin(true);
    }

    public JsonWriter end() throws IOException {
        int v;
        boolean object;
        boolean bl = object = ((v = this.stack[--this.pos]) & 1) == 0;
        if (object) {
            --this.offset;
        }
        if (this.next && object) {
            this.out.append('\n').append(Strings.dup('\t', this.offset));
        }
        this.out.append(object ? (char)'}' : ']');
        this.next = (v & 2) != 0;
        return this;
    }

    private JsonWriter begin(boolean array) throws IOException {
        if (this.pos == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.pos + 32);
        }
        this.stack[this.pos++] = (array ? 1 : 0) | (this.next ? 2 : 0);
        if (!array) {
            ++this.offset;
        }
        this.out.append(array ? (char)'[' : '{');
        this.next = false;
        return this;
    }

    public JsonWriter underscore(String name, JsonPropable p) throws IOException {
        this.prop("_");
        this.js(name);
        p.commonProp(this);
        return this;
    }

    public JsonWriter prop(String name) throws IOException {
        this.prop();
        this.out.append(JSON.toString(name)).append(':');
        return this;
    }

    public JsonWriter prop() throws IOException {
        if (this.next) {
            this.out.append(',');
        }
        this.next = true;
        int v = this.stack[this.pos - 1];
        if ((v & 1) == 0) {
            this.out.append('\n').append(Strings.dup('\t', this.offset));
        }
        return this;
    }

    public JsonWriter val(Object value) throws IOException {
        this.out.append(JSON.toString(value));
        return this;
    }

    public JsonWriter js(String js) throws IOException {
        this.out.append(js);
        return this;
    }

    public static interface JsonPropable {
        public void commonProp(JsonWriter var1) throws IOException;
    }
}

