/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ParameterSyncs
implements Iterable<Entry> {
    private static final int TAG_SS_SYNC_PARAM_ITEM = 1;
    private final Collection<Entry> entries = new ArrayList<Entry>();

    public ParameterSyncs(TaggedReader reader) throws IOException {
        while (reader.next()) {
            if (reader.getCurrentTag() != 1) continue;
            this.entries.add(new Entry(reader.getSubStreamReader()));
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public static class Entry {
        static final int TAG_SS_SYNC_PARAM_NAME = 1;
        static final int TAG_SS_SYNC_PARAM_DATASOURCE = 2;
        static final int TAG_SS_SYNC_PARAM_FIELD = 3;
        public final String name;
        public final int dsid;
        public final int[] fpath;

        Entry(TaggedReader r) throws IOException {
            String _name = null;
            int _dsid = 0;
            int[] _fpath = null;
            while (r.next()) {
                switch (r.getCurrentTag()) {
                    case 1: {
                        _name = r.getString();
                        break;
                    }
                    case 2: {
                        _dsid = r.getInt();
                        break;
                    }
                    case 3: {
                        _fpath = LittleEndian.toIntArray(r.getRaw());
                    }
                }
            }
            this.name = _name;
            this.dsid = _dsid;
            this.fpath = _fpath;
        }
    }
}

